/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.captureRegion;

import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.referenceFrames.ZUpFrame;

public class AchievableCaptureRegionCalculatorWithDelay {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FrameConvexPolygon2D supportFootPolygon = new FrameConvexPolygon2D();
    private final FramePoint2D footCentroid = new FramePoint2D(worldFrame);
    private final FramePoint2D predictedICPAtTouchdown = new FramePoint2D(worldFrame);
    private final FramePoint2D predictedICPAfterTransfer = new FramePoint2D(worldFrame);
    private final FramePoint2D extremeCoP = new FramePoint2D();
    private final FramePoint2D capturePoint = new FramePoint2D(worldFrame);
    private final FrameConvexPolygon2D unconstrainedCaptureRegion = new FrameConvexPolygon2D(worldFrame);
    private final FrameConvexPolygon2D unconstrainedCaptureRegionAtTouchdown = new FrameConvexPolygon2D(worldFrame);
    private final PoseReferenceFrame supportFrame = new PoseReferenceFrame("supportFrame", worldFrame);
    private final ZUpFrame supportSoleZUp = new ZUpFrame(worldFrame, (ReferenceFrame)this.supportFrame, "supportZUpFrame");

    public boolean calculateCaptureRegion(double swingTimeRemaining, double nextTransferDuration, FramePoint2DReadOnly currentICP, double omega0, FramePose3DReadOnly supportPose, FrameConvexPolygon2DReadOnly footPolygon) {
        this.supportFrame.setPoseAndUpdate(supportPose);
        this.supportSoleZUp.update();
        this.supportFootPolygon.setIncludingFrame((FrameVertex2DSupplier)footPolygon);
        this.supportFootPolygon.changeFrameAndProjectToXYPlane((ReferenceFrame)this.supportSoleZUp);
        this.capturePoint.setIncludingFrame((FrameTuple2DReadOnly)currentICP);
        this.capturePoint.changeFrame((ReferenceFrame)this.supportSoleZUp);
        this.footCentroid.setIncludingFrame((FrameTuple2DReadOnly)this.supportFootPolygon.getCentroid());
        this.predictedICPAtTouchdown.setToZero((ReferenceFrame)this.supportSoleZUp);
        swingTimeRemaining = MathTools.clamp((double)swingTimeRemaining, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.unconstrainedCaptureRegion.clear((ReferenceFrame)this.supportSoleZUp);
        this.unconstrainedCaptureRegionAtTouchdown.clear((ReferenceFrame)this.supportSoleZUp);
        if (this.supportFootPolygon.isPointInside((FramePoint2DReadOnly)this.capturePoint)) {
            this.unconstrainedCaptureRegion.setToNaN();
            this.unconstrainedCaptureRegionAtTouchdown.setToNaN();
            return true;
        }
        for (int i = 0; i < this.supportFootPolygon.getNumberOfVertices(); ++i) {
            this.extremeCoP.setIncludingFrame((FrameTuple2DReadOnly)this.supportFootPolygon.getVertex(i));
            this.extremeCoP.changeFrame((ReferenceFrame)this.supportSoleZUp);
            CapturePointTools.computeDesiredCapturePointPosition(omega0, swingTimeRemaining, (FramePoint2DReadOnly)this.capturePoint, (FramePoint2DReadOnly)this.extremeCoP, (FixedFramePoint2DBasics)this.predictedICPAtTouchdown);
            AchievableCaptureRegionCalculatorWithDelay.computeCoPLocationToCapture((FramePoint2DReadOnly)this.predictedICPAtTouchdown, (FramePoint2DReadOnly)this.extremeCoP, omega0, nextTransferDuration, (FramePoint2DBasics)this.predictedICPAfterTransfer);
            this.unconstrainedCaptureRegionAtTouchdown.addVertexMatchingFrame((FramePoint2DReadOnly)this.predictedICPAtTouchdown, false);
            this.unconstrainedCaptureRegion.addVertexMatchingFrame((FramePoint2DReadOnly)this.predictedICPAfterTransfer, false);
        }
        this.unconstrainedCaptureRegionAtTouchdown.update();
        this.unconstrainedCaptureRegion.update();
        return false;
    }

    public FrameConvexPolygon2DReadOnly getUnconstrainedCaptureRegionAtTouchdown() {
        return this.unconstrainedCaptureRegionAtTouchdown;
    }

    public FrameConvexPolygon2DReadOnly getUnconstrainedCaptureRegion() {
        return this.unconstrainedCaptureRegion;
    }

    public static void computeCoPLocationToCapture(FramePoint2DReadOnly initialICP, FramePoint2DReadOnly initialCMP, double omega, double duration, FramePoint2DBasics finalCMPToPack) {
        finalCMPToPack.setToZero(initialCMP.getReferenceFrame());
        double omegaT = omega * duration;
        double exponential = Math.exp(omegaT);
        finalCMPToPack.setAndScale(omegaT * exponential, (FrameTuple2DReadOnly)initialICP);
        finalCMPToPack.scaleAdd(exponential * (1.0 - omegaT) - 1.0, (FrameTuple2DReadOnly)initialCMP, (FrameTuple2DReadOnly)finalCMPToPack);
        finalCMPToPack.scale(1.0 / (exponential - 1.0));
    }
}

