/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment;

import java.awt.Color;
import java.util.List;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.ConvexStepConstraintOptimizer;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.YoConstraintOptimizerParameters;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.StepConstraintRegion;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class EnvironmentConstraintHandler {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double defaultDesiredDistanceInside = 0.04;
    private static final boolean defaultUsePredictedContactPoints = false;
    private static final double defaultMaxConcaveEstimateRatio = 1.1;
    private final DoubleProvider desiredDistanceInsideConstraint;
    private final BooleanProvider usePredictedContactPoints;
    private final DoubleProvider maxConcaveEstimateRatio;
    private final YoBoolean foundSolution;
    private final YoBoolean isEnvironmentConstraintValid;
    private final YoConstraintOptimizerParameters parameters;
    private final SideDependentList<? extends ContactablePlaneBody> contactableFeet;
    private final YoFrameConvexPolygon2D yoConvexHullConstraint;
    private final FrameConvexPolygon2D reachabilityRegionInConstraintPlane = new FrameConvexPolygon2D();
    private StepConstraintRegion stepConstraintRegion = null;
    private final FramePoint3D projectedReachablePoint = new FramePoint3D();
    private final ConvexPolygon2D footstepPolygon = new ConvexPolygon2D();
    private final RigidBodyTransform footOrientationTransform = new RigidBodyTransform();
    private final FramePoint2D stepXY = new FramePoint2D();
    private final ICPControlPlane icpControlPlane;
    private final ConvexStepConstraintOptimizer stepConstraintOptimizer;
    private final Point2DBasics centroidToThrowAway = new Point2D();
    private final FramePose3D originalPose = new FramePose3D();
    private final RigidBodyTransform footstepTransform = new RigidBodyTransform();

    public EnvironmentConstraintHandler(ICPControlPlane icpControlPlane, SideDependentList<? extends ContactablePlaneBody> contactableFeet, String yoNamePrefix, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.icpControlPlane = icpControlPlane;
        this.contactableFeet = contactableFeet;
        this.stepConstraintOptimizer = new ConvexStepConstraintOptimizer(registry);
        this.parameters = new YoConstraintOptimizerParameters(registry);
        this.desiredDistanceInsideConstraint = new DoubleParameter("desiredDistanceInsideEnvironmentConstraint", registry, 0.04);
        this.usePredictedContactPoints = new BooleanParameter("usePredictedContactPointsInStep", registry, false);
        this.maxConcaveEstimateRatio = new DoubleParameter("maxConcaveEstimateRatio", registry, 1.1);
        this.isEnvironmentConstraintValid = new YoBoolean("isEnvironmentConstraintValid", registry);
        this.yoConvexHullConstraint = new YoFrameConvexPolygon2D(yoNamePrefix + "ConvexHullConstraint", "", worldFrame, 12, registry);
        this.foundSolution = new YoBoolean("foundSolution", registry);
        if (yoGraphicsListRegistry != null) {
            YoArtifactPolygon activePlanarRegionViz = new YoArtifactPolygon("ConvexHullConstraint", this.yoConvexHullConstraint, Color.RED, false);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)activePlanarRegionViz);
        }
    }

    public void setStepConstraintRegion(StepConstraintRegion stepConstraintRegion) {
        this.stepConstraintRegion = stepConstraintRegion;
        this.stepConstraintOptimizer.reset();
    }

    public boolean hasStepConstraintRegion() {
        return this.stepConstraintRegion != null;
    }

    public void reset() {
        this.foundSolution.set(false);
        this.stepConstraintRegion = null;
        this.yoConvexHullConstraint.clear();
        this.isEnvironmentConstraintValid.set(false);
        this.stepConstraintOptimizer.reset();
    }

    public void setReachabilityRegion(FrameConvexPolygon2DReadOnly reachabilityRegion) {
        if (this.stepConstraintRegion == null) {
            return;
        }
        this.reachabilityRegionInConstraintPlane.clear();
        for (int i = 0; i < reachabilityRegion.getNumberOfVertices(); ++i) {
            this.icpControlPlane.projectPointFromControlPlaneOntoConstraintRegion(worldFrame, reachabilityRegion.getVertex(i), this.projectedReachablePoint, this.stepConstraintRegion);
            this.reachabilityRegionInConstraintPlane.addVertex((FramePoint3DReadOnly)this.projectedReachablePoint);
        }
        this.reachabilityRegionInConstraintPlane.update();
    }

    public boolean validateConvexityOfPlanarRegion() {
        double convexHullArea;
        if (this.stepConstraintRegion == null) {
            this.isEnvironmentConstraintValid.set(true);
            return this.isEnvironmentConstraintValid.getBooleanValue();
        }
        double concaveHullArea = EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)this.stepConstraintRegion.getConcaveHullVertices(), (int)this.stepConstraintRegion.getConcaveHullSize(), (boolean)true, (Point2DBasics)this.centroidToThrowAway);
        this.isEnvironmentConstraintValid.set(concaveHullArea / (convexHullArea = this.stepConstraintRegion.getConvexHullInConstraintRegion().getArea()) < this.maxConcaveEstimateRatio.getValue());
        return this.isEnvironmentConstraintValid.getBooleanValue();
    }

    public boolean applyEnvironmentConstraintToFootstep(RobotSide upcomingFootstepSide, FixedFramePose3DBasics footstepPoseToPack, List<Point2D> predictedContactPoints) {
        if (this.stepConstraintRegion == null) {
            this.foundSolution.set(true);
            return false;
        }
        this.computeFootstepPolygon(upcomingFootstepSide, predictedContactPoints, (Orientation3DReadOnly)footstepPoseToPack.getOrientation());
        this.yoConvexHullConstraint.set((Vertex2DSupplier)this.stepConstraintRegion.getConvexHullInConstraintRegion());
        this.yoConvexHullConstraint.applyTransform((Transform)this.stepConstraintRegion.getTransformToWorld(), false);
        this.stepXY.set((FrameTuple3DReadOnly)footstepPoseToPack.getPosition());
        if (!this.yoConvexHullConstraint.isPointInside((FramePoint2DReadOnly)this.stepXY)) {
            this.yoConvexHullConstraint.orthogonalProjection((FramePoint2DBasics)this.stepXY);
            footstepPoseToPack.getPosition().set((FrameTuple2DReadOnly)this.stepXY);
        }
        footstepPoseToPack.get((RigidBodyTransformBasics)this.footstepTransform);
        this.footstepPolygon.applyTransform((Transform)this.footstepTransform, false);
        this.parameters.setDesiredDistanceInside(this.desiredDistanceInsideConstraint.getValue());
        RigidBodyTransformReadOnly wiggleTransform = this.stepConstraintOptimizer.findConstraintTransform((ConvexPolygon2DReadOnly)this.footstepPolygon, (ConvexPolygon2DReadOnly)this.yoConvexHullConstraint, this.parameters);
        this.originalPose.set((FramePose3DReadOnly)footstepPoseToPack);
        if (wiggleTransform != null) {
            this.foundSolution.set(true);
            footstepPoseToPack.applyTransform((Transform)wiggleTransform);
        } else {
            this.foundSolution.set(false);
        }
        footstepPoseToPack.getPosition().setZ(this.stepConstraintRegion.getPlaneZGivenXY(footstepPoseToPack.getX(), footstepPoseToPack.getY()));
        footstepPoseToPack.getOrientation().set(this.stepConstraintRegion.getTransformToWorld().getRotation());
        return this.originalPose.getPositionDistance((FramePose3DReadOnly)footstepPoseToPack) > 1.0E-5 || this.originalPose.getOrientationDistance((FramePose3DReadOnly)footstepPoseToPack) > 1.0E-5;
    }

    public boolean foundSolution() {
        return this.foundSolution.getBooleanValue();
    }

    private void computeFootstepPolygon(RobotSide upcomingFootstepSide, List<? extends Point2DBasics> predictedContactPoints, Orientation3DReadOnly orientation) {
        if (predictedContactPoints.isEmpty() || !this.usePredictedContactPoints.getValue()) {
            predictedContactPoints = ((ContactablePlaneBody)this.contactableFeet.get((Enum)upcomingFootstepSide)).getContactPoints2d();
        }
        this.footstepPolygon.clear();
        for (int i = 0; i < predictedContactPoints.size(); ++i) {
            this.footstepPolygon.addVertex((Point2DReadOnly)predictedContactPoints.get(i));
        }
        this.footstepPolygon.update();
        this.footOrientationTransform.getRotation().set(orientation);
        this.footstepPolygon.applyTransform((Transform)this.footOrientationTransform, false);
    }
}

