/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.ConstraintOptimizerParametersReadOnly;
import us.ihmc.commonWalkingControlModules.polygonWiggling.PolygonWiggler;
import us.ihmc.convexOptimization.quadraticProgram.QuadProgSolver;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.MatrixMissingTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class ConvexStepConstraintOptimizer {
    private static final boolean DEBUG = false;
    private static final boolean warmStart = true;
    private static final double polygonWeight = 1000000.0;
    private static final double regularization = 1.0E-10;
    private static final double moveWeight = 1.0;
    private static int[] emptyArray = new int[0];
    private final DMatrixRMaj G = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj g = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj J = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj j = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj A = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj b = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Aineq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj bineq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Aeq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj beq = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj p = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj bFull = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj solution = new DMatrixRMaj(1, 6);
    private final QuadProgSolver solver = new QuadProgSolver();
    private final RigidBodyTransform transformToReturn = new RigidBodyTransform();
    private boolean invariantConstraintRegionValuesComputed = false;
    private boolean invariantOptimizationValuesComputed = false;
    private final YoInteger iterations;

    public ConvexStepConstraintOptimizer(YoRegistry registry) {
        this.iterations = new YoInteger("StepConstrationOptimizerIterations", registry);
    }

    public void reset() {
        this.iterations.set(0);
        this.invariantConstraintRegionValuesComputed = false;
        this.invariantOptimizationValuesComputed = false;
    }

    public RigidBodyTransformReadOnly findConstraintTransform(ConvexPolygon2DReadOnly polygonToWiggle, ConvexPolygon2DReadOnly planeToWiggleInto, ConstraintOptimizerParametersReadOnly parameters) {
        return this.findConstraintTransform(polygonToWiggle, planeToWiggleInto, parameters, emptyArray);
    }

    public RigidBodyTransformReadOnly findConstraintTransform(ConvexPolygon2DReadOnly polygonToWiggle, ConvexPolygon2DReadOnly planeToWiggleInto, ConstraintOptimizerParametersReadOnly parameters, int[] startingVerticesToIgnore) {
        int numberOfPoints = polygonToWiggle.getNumberOfVertices();
        boolean parametersChanged = parameters.pollParametersChanged();
        if (!this.invariantConstraintRegionValuesComputed || parametersChanged) {
            this.computeInvariantConstraintValues(planeToWiggleInto, parameters, startingVerticesToIgnore, numberOfPoints);
        }
        int constraintsPerPoint = this.A.getNumRows();
        int variables = 2;
        int slackVariables = constraintsPerPoint * numberOfPoints;
        int totalVariables = variables + slackVariables;
        this.j.set((DMatrixD1)this.bFull);
        for (int i = 0; i < numberOfPoints; ++i) {
            polygonToWiggle.getVertex(i).get((DMatrix)this.p);
            MatrixTools.multAddBlock((double)-1.0, (DMatrix1Row)this.A, (DMatrix1Row)this.p, (DMatrix1Row)this.j, (int)(constraintsPerPoint * i), (int)0);
        }
        this.solution.reshape(numberOfPoints, 1);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.j, (DMatrixD1)this.solution);
        boolean areConstraintsAlreadyValid = true;
        for (int i = 0; i < this.solution.numRows; ++i) {
            if (!(this.solution.get(i, 0) > 1.0E-5)) continue;
            areConstraintsAlreadyValid = false;
            break;
        }
        if (areConstraintsAlreadyValid) {
            this.transformToReturn.setToZero();
            return this.transformToReturn;
        }
        if (!this.invariantOptimizationValuesComputed) {
            this.computeInvariantOptimizationValues(numberOfPoints);
            this.computeInequalityConstraints(parameters, totalVariables, numberOfPoints);
        } else if (parametersChanged) {
            this.computeInequalityConstraints(parameters, totalVariables, numberOfPoints);
        }
        this.g.reshape(totalVariables, 1);
        CommonOps_DDRM.multTransA((double)-1000000.0, (DMatrix1Row)this.J, (DMatrix1Row)this.j, (DMatrix1Row)this.g);
        try {
            this.solution.reshape(totalVariables, 1);
            this.iterations.set(this.solver.solve(this.G, this.g, this.Aeq, this.beq, this.Aineq, this.bineq, this.solution, false));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        if (MatrixTools.containsNaN((DMatrix1Row)this.solution)) {
            LogTools.info((String)"Could not find transform!");
            return null;
        }
        this.transformToReturn.getTranslation().set(this.solution.get(0), this.solution.get(1), 0.0);
        return this.transformToReturn;
    }

    private void computeInvariantConstraintValues(ConvexPolygon2DReadOnly planeToWiggleInto, ConstraintOptimizerParametersReadOnly parameters, int[] startingVerticesToIgnore, int numberOfPoints) {
        PolygonWiggler.convertToInequalityConstraints(planeToWiggleInto, this.A, this.b, parameters.getDesiredDistanceInside(), startingVerticesToIgnore);
        int constraintsPerPoint = this.A.getNumRows();
        int variables = 2;
        int slackVariables = constraintsPerPoint * numberOfPoints;
        int totalVariables = variables + slackVariables;
        int constraints = constraintsPerPoint * numberOfPoints;
        this.J.reshape(constraints, totalVariables);
        this.bFull.reshape(constraints, 1);
        MatrixMissingTools.setDiagonalValues((DMatrix1Row)this.J, (double)-1.0, (int)0, (int)variables);
        for (int i = 0; i < numberOfPoints; ++i) {
            CommonOps_DDRM.insert((DMatrix)this.A, (DMatrix)this.J, (int)(constraintsPerPoint * i), (int)0);
            CommonOps_DDRM.insert((DMatrix)this.b, (DMatrix)this.bFull, (int)(constraintsPerPoint * i), (int)0);
        }
        this.invariantConstraintRegionValuesComputed = true;
    }

    private void computeInvariantOptimizationValues(int numberOfPoints) {
        int constraintsPerPoint = this.A.getNumRows();
        int variables = 2;
        int slackVariables = constraintsPerPoint * numberOfPoints;
        int totalVariables = variables + slackVariables;
        this.G.reshape(totalVariables, totalVariables);
        CommonOps_DDRM.multInner((DMatrix1Row)this.J, (DMatrix1Row)this.G);
        CommonOps_DDRM.scale((double)1000000.0, (DMatrixD1)this.G);
        MatrixTools.addDiagonal((DMatrix)this.G, (double)1.0E-10);
        for (int i = 0; i < variables; ++i) {
            this.G.add(i, i, 1.0);
        }
        this.invariantOptimizationValuesComputed = true;
    }

    private void computeInequalityConstraints(ConstraintOptimizerParametersReadOnly parameters, int totalVariables, int numberOfPoints) {
        int constraintsPerPoint = this.A.getNumRows();
        int variables = 2;
        int constraints = constraintsPerPoint * numberOfPoints;
        int boundConstraints = parameters.getConstrainMaxAdjustment() ? 4 : 0;
        this.Aeq.reshape(0, totalVariables);
        this.Aineq.reshape(constraints + boundConstraints, totalVariables);
        this.bineq.reshape(constraints + boundConstraints, 1);
        if (parameters.getConstrainMaxAdjustment()) {
            PolygonWiggler.addTranslationConstraint(this.Aineq, this.bineq, constraints, parameters.getMaxX(), -parameters.getMaxX(), parameters.getMaxY(), -parameters.getMaxY());
        }
        MatrixMissingTools.setDiagonalValues((DMatrix1Row)this.Aineq, (double)1.0, (int)0, (int)variables);
    }
}

