/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation;

import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.Supplier;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionTools;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.FootstepUtils;
import us.ihmc.tools.functional.IntDoubleConsumer;

public class SplitFractionFromPositionCalculator {
    private final FramePose3D stanceFootPose = new FramePose3D();
    private final FramePose3D nextFootPose = new FramePose3D();
    private final SplitFractionCalculatorParametersReadOnly splitFractionParameters;
    private IntSupplier numberOfStepsProvider;
    private IntFunction<FramePose3DReadOnly> stepPoseGetter;
    private Supplier<? extends Pose3DReadOnly> firstSupportPoseProvider;
    private DoubleSupplier finalTransferWeightDistributionProvider;
    private DoubleSupplier finalTransferSplitFractionProvider;
    private IntToDoubleFunction transferWeightDistributionProvider;
    private IntToDoubleFunction transferSplitFractionProvider;
    private DoubleConsumer finalTransferWeightDistributionConsumer;
    private DoubleConsumer finalTransferSplitFractionConsumer;
    private IntDoubleConsumer transferWeightDistributionConsumer;
    private IntDoubleConsumer transferSplitFractionConsumer;

    public SplitFractionFromPositionCalculator(SplitFractionCalculatorParametersReadOnly splitFractionParameters) {
        this.splitFractionParameters = splitFractionParameters;
    }

    public void setNumberOfStepsProvider(IntSupplier numberOfStepsProvider) {
        this.numberOfStepsProvider = numberOfStepsProvider;
    }

    public void setFinalTransferWeightDistributionProvider(DoubleSupplier finalTransferWeightDistributionProvider) {
        this.finalTransferWeightDistributionProvider = finalTransferWeightDistributionProvider;
    }

    public void setFinalTransferSplitFractionProvider(DoubleSupplier finalTransferSplitFractionProvider) {
        this.finalTransferSplitFractionProvider = finalTransferSplitFractionProvider;
    }

    public void setFinalTransferWeightDistributionConsumer(DoubleConsumer finalTransferWeightDistributionConsumer) {
        this.finalTransferWeightDistributionConsumer = finalTransferWeightDistributionConsumer;
    }

    public void setFinalTransferSplitFractionConsumer(DoubleConsumer finalTransferSplitFractionConsumer) {
        this.finalTransferSplitFractionConsumer = finalTransferSplitFractionConsumer;
    }

    public void setTransferWeightDistributionProvider(IntToDoubleFunction transferWeightDistributionProvider) {
        this.transferWeightDistributionProvider = transferWeightDistributionProvider;
    }

    public void setTransferSplitFractionProvider(IntToDoubleFunction transferSplitFractionProvider) {
        this.transferSplitFractionProvider = transferSplitFractionProvider;
    }

    public void setTransferWeightDistributionConsumer(IntDoubleConsumer transferWeightDistributionConsumer) {
        this.transferWeightDistributionConsumer = transferWeightDistributionConsumer;
    }

    public void setTransferSplitFractionConsumer(IntDoubleConsumer transferSplitFractionConsumer) {
        this.transferSplitFractionConsumer = transferSplitFractionConsumer;
    }

    public void setFirstSupportPoseProvider(Supplier<? extends Pose3DReadOnly> firstSupportPoseProvider) {
        this.firstSupportPoseProvider = firstSupportPoseProvider;
    }

    public void setStepPoseGetter(IntFunction<FramePose3DReadOnly> stepPoseGetter) {
        this.stepPoseGetter = stepPoseGetter;
    }

    public void computeSplitFractionsFromPosition() {
        if (this.numberOfStepsProvider.getAsInt() == 0 || !this.splitFractionParameters.calculateSplitFractionsFromPositions()) {
            return;
        }
        double defaultTransferSplitFraction = this.splitFractionParameters.getDefaultTransferSplitFraction();
        double defaultWeightDistribution = 0.5;
        for (int stepNumber = 0; stepNumber < this.numberOfStepsProvider.getAsInt(); ++stepNumber) {
            double weightDistributionToSet;
            double splitFractionToSet;
            double transferWeightDistribution;
            double currentWeightDistribution;
            double currentSplitFraction;
            boolean isABigStepUp;
            if (stepNumber == 0) {
                this.stanceFootPose.setIncludingFrame(FootstepUtils.worldFrame, this.firstSupportPoseProvider.get());
            } else {
                this.stanceFootPose.set(this.stepPoseGetter.apply(stepNumber - 1));
            }
            this.nextFootPose.set(this.stepPoseGetter.apply(stepNumber));
            double stepHeight = this.nextFootPose.getZ() - this.stanceFootPose.getZ();
            boolean isABigStepDown = stepHeight < -this.splitFractionParameters.getStepHeightForLargeStepDown();
            boolean bl = isABigStepUp = stepHeight > this.splitFractionParameters.getStepHeightForLargeStepUp();
            if (!isABigStepDown && !isABigStepUp) continue;
            double largeStepHeight = isABigStepDown ? this.splitFractionParameters.getStepHeightForLargeStepDown() : this.splitFractionParameters.getStepHeightForLargeStepUp();
            double largestStepHeight = isABigStepDown ? this.splitFractionParameters.getLargestStepDownHeight() : this.splitFractionParameters.getLargestStepUpHeight();
            double alpha = Math.min(1.0, (Math.abs(stepHeight) - largeStepHeight) / (largestStepHeight - largeStepHeight));
            double splitFractionAtFullDepth = isABigStepDown ? this.splitFractionParameters.getTransferSplitFractionAtFullDepth() : this.splitFractionParameters.getTransferSplitFractionForStepUpAtFullDepth();
            double transferSplitFraction = InterpolationTools.linearInterpolate((double)defaultTransferSplitFraction, (double)splitFractionAtFullDepth, (double)alpha);
            if (stepNumber == this.numberOfStepsProvider.getAsInt() - 1) {
                currentSplitFraction = this.finalTransferSplitFractionProvider.getAsDouble();
                currentWeightDistribution = this.finalTransferWeightDistributionProvider.getAsDouble();
                double transferFinalWeightDistribution = isABigStepDown ? this.splitFractionParameters.getTransferFinalWeightDistributionAtFullDepth() : this.splitFractionParameters.getTransferFinalWeightDistributionForStepUpAtFullDepth();
                transferWeightDistribution = InterpolationTools.linearInterpolate((double)defaultWeightDistribution, (double)transferFinalWeightDistribution, (double)alpha);
                splitFractionToSet = SplitFractionTools.appendSplitFraction(transferSplitFraction, currentSplitFraction, defaultTransferSplitFraction);
                weightDistributionToSet = SplitFractionTools.appendWeightDistribution(transferWeightDistribution, currentWeightDistribution, defaultWeightDistribution);
                this.finalTransferSplitFractionConsumer.accept(splitFractionToSet);
                this.finalTransferWeightDistributionConsumer.accept(weightDistributionToSet);
                continue;
            }
            currentSplitFraction = this.transferSplitFractionProvider.applyAsDouble(stepNumber + 1);
            currentWeightDistribution = this.transferWeightDistributionProvider.applyAsDouble(stepNumber + 1);
            double splitFractionWeightDistributionAtFullDepth = isABigStepDown ? this.splitFractionParameters.getTransferWeightDistributionAtFullDepth() : this.splitFractionParameters.getTransferWeightDistributionForStepUpAtFullDepth();
            transferWeightDistribution = InterpolationTools.linearInterpolate((double)defaultWeightDistribution, (double)splitFractionWeightDistributionAtFullDepth, (double)alpha);
            splitFractionToSet = SplitFractionTools.appendSplitFraction(transferSplitFraction, currentSplitFraction, defaultTransferSplitFraction);
            weightDistributionToSet = SplitFractionTools.appendWeightDistribution(transferWeightDistribution, currentWeightDistribution, defaultWeightDistribution);
            this.transferSplitFractionConsumer.accept(stepNumber + 1, splitFractionToSet);
            this.transferWeightDistributionConsumer.accept(stepNumber + 1, weightDistributionToSet);
        }
    }
}

