/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPIndexHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPInput;
import us.ihmc.matrixlib.MatrixTools;

public class ICPQPInputCalculator {
    private boolean considerAngularMomentumInAdjustment = true;
    private boolean considerFeedbackInAdjustment = true;
    private final ICPQPIndexHandler indexHandler;
    private final DMatrixRMaj identity = CommonOps_DDRM.identity((int)2, (int)2);
    final DMatrixRMaj tmpObjective = new DMatrixRMaj(2, 1);
    final DMatrixRMaj feedbackJacobian = new DMatrixRMaj(2, 6);
    final DMatrixRMaj feedbackObjective = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj feedbackJtW = new DMatrixRMaj(6, 2);
    final DMatrixRMaj adjustmentJacobian = new DMatrixRMaj(2, 6);
    final DMatrixRMaj adjustmentObjective = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj adjustmentJtW = new DMatrixRMaj(6, 2);
    final LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.linear((int)2);
    private final DMatrixRMaj invertedFeedbackGain = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj aTb = new DMatrixRMaj(6, 6);

    public ICPQPInputCalculator(ICPQPIndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public void setConsiderAngularMomentumInAdjustment(boolean considerAngularMomentumInAdjustment) {
        this.considerAngularMomentumInAdjustment = considerAngularMomentumInAdjustment;
    }

    public void setConsiderFeedbackInAdjustment(boolean considerFeedbackInAdjustment) {
        this.considerFeedbackInAdjustment = considerFeedbackInAdjustment;
    }

    public static void computeCoPFeedbackTask(ICPQPInput icpQPInputToPack, DMatrixRMaj feedbackWeight) {
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)0, (int)0, (DMatrix1Row)feedbackWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
    }

    public void computeCoPFeedbackRateTask(ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        this.computeQuadraticTask(this.indexHandler.getCoPFeedbackIndex(), icpQPInputToPack, rateWeight, objective);
    }

    public void computeCMPFeedbackRateTask(ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        if (this.indexHandler.hasCMPFeedbackTask()) {
            this.computeQuadraticTask(this.indexHandler.getCMPFeedbackIndex(), icpQPInputToPack, rateWeight, objective);
        }
    }

    public void computeFeedbackRateTask(ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        int copIndex = this.indexHandler.getCoPFeedbackIndex();
        int cmpIndex = this.indexHandler.getCMPFeedbackIndex();
        this.computeQuadraticTask(copIndex, icpQPInputToPack, rateWeight, objective);
        if (this.indexHandler.hasCMPFeedbackTask()) {
            this.computeQuadraticTask(cmpIndex, icpQPInputToPack, rateWeight, objective, false);
            MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)copIndex, (int)cmpIndex, (DMatrix1Row)rateWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)cmpIndex, (int)copIndex, (DMatrix1Row)rateWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        }
    }

    public void computeCMPFeedbackTask(ICPQPInput icpQPInputToPack, DMatrixRMaj cmpFeedbackWeight) {
        this.tmpObjective.zero();
        this.computeCMPFeedbackTask(icpQPInputToPack, cmpFeedbackWeight, this.tmpObjective);
    }

    public void computeCMPFeedbackTask(ICPQPInput icpQPInputToPack, DMatrixRMaj cmpFeedbackWeight, DMatrixRMaj differenceObjective) {
        this.computeQuadraticTask(0, icpQPInputToPack, cmpFeedbackWeight, differenceObjective);
    }

    public void computeFootstepTask(int footstepNumber, ICPQPInput icpQPInputToPack, DMatrixRMaj footstepWeight, DMatrixRMaj objective) {
        int footstepIndex = 2 * footstepNumber;
        this.computeQuadraticTask(footstepIndex, icpQPInputToPack, footstepWeight, objective);
    }

    public void computeFootstepRateTask(int footstepNumber, ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        int footstepIndex = 2 * footstepNumber;
        this.computeQuadraticTask(footstepIndex, icpQPInputToPack, rateWeight, objective);
    }

    public void computeDynamicsTask(ICPQPInput icpQPInput, DMatrixRMaj currentICPError, DMatrixRMaj referenceFootstepLocation, DMatrixRMaj feedbackGain, DMatrixRMaj weight, double footstepRecursionMultiplier, double footstepAdjustmentSafetyFactor) {
        this.invertedFeedbackGain.zero();
        this.solver.setA((Matrix)feedbackGain);
        this.solver.invert((Matrix)this.invertedFeedbackGain);
        int size = 2;
        if (this.indexHandler.hasCMPFeedbackTask()) {
            size += 2;
        }
        if (this.indexHandler.useStepAdjustment()) {
            size += 2;
        }
        this.feedbackJacobian.reshape(2, size);
        this.feedbackJtW.reshape(size, 2);
        this.adjustmentJacobian.reshape(2, size);
        this.adjustmentJtW.reshape(size, 2);
        this.feedbackJacobian.zero();
        this.feedbackJtW.zero();
        this.feedbackObjective.zero();
        this.adjustmentJacobian.zero();
        this.adjustmentJtW.zero();
        this.adjustmentObjective.zero();
        if (this.considerFeedbackInAdjustment && this.considerAngularMomentumInAdjustment) {
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCMPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            }
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
            if (this.indexHandler.useStepAdjustment()) {
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.identity, (int)0, (int)0, (int)2, (int)2, (double)(footstepRecursionMultiplier / footstepAdjustmentSafetyFactor));
                MatrixTools.addMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix1Row)referenceFootstepLocation, (int)0, (int)0, (int)2, (int)1, (double)footstepRecursionMultiplier);
            }
        } else if (this.considerFeedbackInAdjustment) {
            if (!this.indexHandler.hasCMPFeedbackTask()) {
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
                if (this.indexHandler.useStepAdjustment()) {
                    MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.identity, (int)0, (int)0, (int)2, (int)2, (double)(footstepRecursionMultiplier / footstepAdjustmentSafetyFactor));
                    MatrixTools.addMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix1Row)referenceFootstepLocation, (int)0, (int)0, (int)2, (int)1, (double)footstepRecursionMultiplier);
                }
            } else {
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCMPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
                if (this.indexHandler.useStepAdjustment()) {
                    MatrixTools.setMatrixBlock((DMatrix)this.adjustmentJacobian, (int)0, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
                    MatrixTools.setMatrixBlock((DMatrix)this.adjustmentJacobian, (int)0, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.identity, (int)0, (int)0, (int)2, (int)2, (double)(footstepRecursionMultiplier / footstepAdjustmentSafetyFactor));
                    MatrixTools.addMatrixBlock((DMatrix)this.adjustmentObjective, (int)0, (int)0, (DMatrix1Row)referenceFootstepLocation, (int)0, (int)0, (int)2, (int)1, (double)footstepRecursionMultiplier);
                    MatrixTools.addMatrixBlock((DMatrix)this.adjustmentObjective, (int)0, (int)0, (DMatrix1Row)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
                }
            }
        } else if (this.considerAngularMomentumInAdjustment) {
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCMPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            }
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
            if (this.indexHandler.useStepAdjustment()) {
                if (this.indexHandler.hasCMPFeedbackTask()) {
                    MatrixTools.setMatrixBlock((DMatrix)this.adjustmentJacobian, (int)0, (int)this.indexHandler.getCMPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
                }
                MatrixTools.setMatrixBlock((DMatrix)this.adjustmentJacobian, (int)0, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.identity, (int)0, (int)0, (int)2, (int)2, (double)(footstepRecursionMultiplier / footstepAdjustmentSafetyFactor));
                MatrixTools.addMatrixBlock((DMatrix)this.adjustmentObjective, (int)0, (int)0, (DMatrix1Row)referenceFootstepLocation, (int)0, (int)0, (int)2, (int)1, (double)footstepRecursionMultiplier);
                MatrixTools.addMatrixBlock((DMatrix)this.adjustmentObjective, (int)0, (int)0, (DMatrix1Row)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
            }
        } else {
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            if (this.indexHandler.hasCMPFeedbackTask()) {
                MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)this.indexHandler.getCMPFeedbackIndex(), (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
            }
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
            if (this.indexHandler.useStepAdjustment()) {
                MatrixTools.setMatrixBlock((DMatrix)this.adjustmentJacobian, (int)0, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.identity, (int)0, (int)0, (int)2, (int)2, (double)(footstepRecursionMultiplier / footstepAdjustmentSafetyFactor));
                MatrixTools.addMatrixBlock((DMatrix)this.adjustmentObjective, (int)0, (int)0, (DMatrix1Row)referenceFootstepLocation, (int)0, (int)0, (int)2, (int)1, (double)footstepRecursionMultiplier);
                MatrixTools.addMatrixBlock((DMatrix)this.adjustmentObjective, (int)0, (int)0, (DMatrix1Row)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
            }
        }
        CommonOps_DDRM.multTransA((DMatrix1Row)this.feedbackJacobian, (DMatrix1Row)weight, (DMatrix1Row)this.feedbackJtW);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.feedbackJtW, (DMatrix1Row)this.feedbackJacobian, (DMatrix1Row)icpQPInput.quadraticTerm);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.feedbackJtW, (DMatrix1Row)this.feedbackObjective, (DMatrix1Row)icpQPInput.linearTerm);
        this.multAddInner(0.5, this.feedbackObjective, weight, icpQPInput.residualCost);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.adjustmentJacobian, (DMatrix1Row)weight, (DMatrix1Row)this.adjustmentJtW);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.adjustmentJtW, (DMatrix1Row)this.adjustmentJacobian, (DMatrix1Row)icpQPInput.quadraticTerm);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.adjustmentJtW, (DMatrix1Row)this.adjustmentObjective, (DMatrix1Row)icpQPInput.linearTerm);
        this.multAddInner(0.5, this.adjustmentObjective, weight, icpQPInput.residualCost);
    }

    public void computeDynamicConstraintError(DMatrixRMaj solution, DMatrixRMaj errorToPack) {
        errorToPack.reshape(2, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.feedbackJacobian, (DMatrix1Row)solution, (DMatrix1Row)errorToPack);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.adjustmentJacobian, (DMatrix1Row)solution, (DMatrix1Row)errorToPack);
        CommonOps_DDRM.addEquals((DMatrixD1)errorToPack, (double)-1.0, (DMatrixD1)this.feedbackObjective);
        CommonOps_DDRM.addEquals((DMatrixD1)errorToPack, (double)-1.0, (DMatrixD1)this.adjustmentObjective);
    }

    public void submitCoPFeedbackTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int feedbackCoPIndex = this.indexHandler.getCoPFeedbackIndex();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)feedbackCoPIndex, (int)feedbackCoPIndex, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)feedbackCoPIndex, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)2, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public void submitCMPFeedbackTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int angularMomentumIndex = this.indexHandler.getCMPFeedbackIndex();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)angularMomentumIndex, (int)angularMomentumIndex, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)angularMomentumIndex, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)2, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public void submitFeedbackRateTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int feedbackCoPIndex = this.indexHandler.getCoPFeedbackIndex();
        int size = icpQPInput.linearTerm.getNumRows();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)feedbackCoPIndex, (int)feedbackCoPIndex, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)size, (int)size, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)feedbackCoPIndex, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)size, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public void submitDynamicsTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int size = icpQPInput.linearTerm.getNumRows();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)size, (int)size, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)size, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public void submitFootstepTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int numberOfFootstepVariables = this.indexHandler.getNumberOfFootstepVariables();
        int footstepStartIndex = this.indexHandler.getFootstepStartIndex();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)footstepStartIndex, (int)footstepStartIndex, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)numberOfFootstepVariables, (int)numberOfFootstepVariables, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)footstepStartIndex, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)numberOfFootstepVariables, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    void computeQuadraticTask(int startIndex, ICPQPInput icpQPInputToPack, DMatrixRMaj weight, DMatrixRMaj objective) {
        this.computeQuadraticTask(startIndex, icpQPInputToPack, weight, objective, true);
    }

    void computeQuadraticTask(int startIndex, ICPQPInput icpQPInputToPack, DMatrixRMaj weight, DMatrixRMaj objective, boolean includeResidual) {
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)startIndex, (int)startIndex, (DMatrix1Row)weight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.multAddBlock((DMatrix1Row)weight, (DMatrix1Row)objective, (DMatrix1Row)icpQPInputToPack.linearTerm, (int)startIndex, (int)0);
        if (includeResidual) {
            this.multAddInner(0.5, objective, weight, icpQPInputToPack.residualCost);
        }
    }

    private void multAddInner(double scalar, DMatrixRMaj jac, DMatrixRMaj weight, DMatrixRMaj resultToPack) {
        this.quadraticMultAddTransA(scalar, jac, weight, jac, resultToPack);
    }

    private void quadraticMultAddTransA(double scalar, DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj resultToPack) {
        this.aTb.reshape(a.getNumCols(), b.getNumCols());
        CommonOps_DDRM.multTransA((double)scalar, (DMatrix1Row)a, (DMatrix1Row)b, (DMatrix1Row)this.aTb);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.aTb, (DMatrix1Row)c, (DMatrix1Row)resultToPack);
    }
}

