/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import java.awt.Color;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.captureRegion.OneStepCaptureRegionCalculator;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class PlanarRegionConstraintProvider {
    private static final double maxNormalAngleFromVertical = 0.3;
    private static final double distanceFromEdgeForStepping = 0.04;
    private static final double distanceFromEdgeForSwitching = 0.03;
    private static final double minimumAreaForSearch = 0.01;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoFrameConvexPolygon2D yoActivePlanarRegion;
    private final YoFrameConvexPolygon2D yoActivePlanarRegionInControlPlane;
    private final YoFrameConvexPolygon2D yoShrunkActivePlanarRegion;
    private final SideDependentList<? extends ContactablePlaneBody> contactableFeet;
    private final BipedSupportPolygons bipedSupportPolygons;
    private final RecyclingArrayList<PlanarRegion> planarRegionsList = new RecyclingArrayList(PlanarRegion.class);
    private final YoDouble distanceToPlanarRegionEdgeForNoOverhang;
    private final YoInteger numberOfPlanarListsToConsider;
    private final BooleanProvider usePlanarRegionConstraints;
    private final YoBoolean switchPlanarRegionConstraintsAutomatically;
    private final OneStepCaptureRegionCalculator captureRegionCalculator;
    private final ICPControlPlane icpControlPlane;
    private PlanarRegion activePlanarRegion = null;
    private final FrameConvexPolygon2D activePlanarRegionConvexHull = new FrameConvexPolygon2D();
    private final ConvexPolygon2D activePlanarRegionConvexHullInControlFrame = new ConvexPolygon2D();
    private final ConvexPolygon2D projectedAndShrunkConvexHull = new ConvexPolygon2D();
    private final RigidBodyTransform planeTransformToWorld = new RigidBodyTransform();
    private final ReferenceFrame planeReferenceFrame;
    private final ConvexPolygonScaler scaler = new ConvexPolygonScaler();
    private final ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
    private final ConvexPolygon2D tempProjectedPolygon = new ConvexPolygon2D();
    private final ConvexPolygon2D tempShrunkProjectedPolygon = new ConvexPolygon2D();
    private final FramePoint2D tempPoint2D = new FramePoint2D();
    private boolean hasConstraintChanged = false;
    private final boolean allowUsePlanarRegionConstraints;
    private final Vector3D planeNormal = new Vector3D();
    private final Vector3D verticalAxis = new Vector3D(0.0, 0.0, 1.0);
    private final ConvexPolygon2D footstepPolygon = new ConvexPolygon2D();
    private final FramePose3D footstepPose = new FramePose3D();
    private final FramePoint2D footstepXYPosition = new FramePoint2D();
    private final FrameVector3D footstepNormal = new FrameVector3D();
    private final FrameVector3D planarRegionNormal = new FrameVector3D();
    private final AxisAngle rotation = new AxisAngle();

    public PlanarRegionConstraintProvider(ICPControlPlane icpControlPlane, WalkingControllerParameters walkingParameters, ICPOptimizationParameters optimizationParameters, BipedSupportPolygons bipedSupportPolygons, SideDependentList<ReferenceFrame> soleZUpFrames, SideDependentList<? extends ContactablePlaneBody> contactableFeet, String yoNamePrefix, boolean visualize, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.icpControlPlane = icpControlPlane;
        this.contactableFeet = contactableFeet;
        this.bipedSupportPolygons = bipedSupportPolygons;
        this.allowUsePlanarRegionConstraints = optimizationParameters.allowUsePlanarRegionConstraints();
        if (this.allowUsePlanarRegionConstraints) {
            this.captureRegionCalculator = new OneStepCaptureRegionCalculator(soleZUpFrames, walkingParameters, yoNamePrefix, registry, yoGraphicsListRegistry);
            this.yoActivePlanarRegion = new YoFrameConvexPolygon2D(yoNamePrefix + "ActivePlanarRegionConstraint", "", worldFrame, 12, registry);
            this.yoShrunkActivePlanarRegion = new YoFrameConvexPolygon2D(yoNamePrefix + "ShrunkActivePlanarRegionConstraint", "", worldFrame, 12, registry);
            this.yoActivePlanarRegionInControlPlane = new YoFrameConvexPolygon2D(yoNamePrefix + "ActivePlanarRegionConstraintInControlPlane", "", worldFrame, 12, registry);
            this.distanceToPlanarRegionEdgeForNoOverhang = new YoDouble(yoNamePrefix + "DistanceToPlanarRegionEdgeForNoOverhang", registry);
            this.numberOfPlanarListsToConsider = new YoInteger(yoNamePrefix + "NumberOfPlanarListsToConsider", registry);
            this.usePlanarRegionConstraints = new BooleanParameter(yoNamePrefix + "UsePlanarRegionConstraints", registry, optimizationParameters.usePlanarRegionConstraints());
            this.switchPlanarRegionConstraintsAutomatically = new YoBoolean(yoNamePrefix + "SwitchPlanarRegionConstraintsAutomatically", registry);
            this.switchPlanarRegionConstraintsAutomatically.set(optimizationParameters.switchPlanarRegionConstraintsAutomatically());
            this.planeReferenceFrame = new ReferenceFrame("planeReferenceFrame", worldFrame){

                protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                    transformToParent.set(PlanarRegionConstraintProvider.this.planeTransformToWorld);
                }
            };
            if (yoGraphicsListRegistry != null) {
                YoArtifactPolygon activePlanarRegionViz = new YoArtifactPolygon("ActivePlanarRegionViz", this.yoActivePlanarRegion, Color.RED, false, true);
                YoArtifactPolygon activePlanarRegionInControlPlaneViz = new YoArtifactPolygon("ActivePlanarRegionInControlPlaneViz", this.yoActivePlanarRegionInControlPlane, Color.RED, false);
                YoArtifactPolygon shrunkPlanarViz = new YoArtifactPolygon("ShrunkActivePlanarRegionInControlPlaneViz", this.yoShrunkActivePlanarRegion, Color.PINK, false);
                activePlanarRegionViz.setVisible(visualize);
                activePlanarRegionInControlPlaneViz.setVisible(visualize);
                shrunkPlanarViz.setVisible(visualize);
                yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)activePlanarRegionViz);
                yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)activePlanarRegionInControlPlaneViz);
                yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)shrunkPlanarViz);
            }
        } else {
            this.captureRegionCalculator = null;
            this.yoActivePlanarRegion = null;
            this.yoShrunkActivePlanarRegion = null;
            this.yoActivePlanarRegionInControlPlane = null;
            this.distanceToPlanarRegionEdgeForNoOverhang = null;
            this.numberOfPlanarListsToConsider = null;
            this.usePlanarRegionConstraints = null;
            this.switchPlanarRegionConstraintsAutomatically = null;
            this.planeReferenceFrame = null;
        }
    }

    public void setActivePlanarRegion(PlanarRegion planarRegion) {
        this.planarRegionsList.clear();
        if (planarRegion != null) {
            ((PlanarRegion)this.planarRegionsList.add()).set(planarRegion);
        } else {
            this.yoActivePlanarRegion.clear();
            this.yoShrunkActivePlanarRegion.clear();
            this.yoActivePlanarRegionInControlPlane.clear();
        }
    }

    public void setPlanarRegions(List<PlanarRegion> planarRegions) {
        if (this.allowUsePlanarRegionConstraints) {
            this.planarRegionsList.clear();
            this.numberOfPlanarListsToConsider.set(0);
            for (int i = 0; i < planarRegions.size(); ++i) {
                PlanarRegion planarRegion = planarRegions.get(i);
                planarRegion.getNormal((Vector3DBasics)this.planeNormal);
                double angle = this.planeNormal.angle((Vector3DReadOnly)this.verticalAxis);
                if (!(angle < 0.3)) continue;
                ((PlanarRegion)this.planarRegionsList.add()).set(planarRegions.get(i));
                this.numberOfPlanarListsToConsider.increment();
            }
        }
    }

    public void computeDistanceFromEdgeForNoOverhang(RobotSide upcomingFootstepSide, List<Point2D> predictedContactPoints) {
        if (this.allowUsePlanarRegionConstraints) {
            double maxDistance = 0.0;
            if (!predictedContactPoints.isEmpty()) {
                for (int i = 0; i < predictedContactPoints.size(); ++i) {
                    maxDistance = Math.max(maxDistance, predictedContactPoints.get(i).distanceFromOrigin());
                }
            } else {
                List contactPoints = ((ContactablePlaneBody)this.contactableFeet.get((Enum)upcomingFootstepSide)).getContactPoints2d();
                for (int i = 0; i < contactPoints.size(); ++i) {
                    maxDistance = Math.max(maxDistance, ((FramePoint2D)contactPoints.get(i)).distanceFromOrigin());
                }
            }
            this.distanceToPlanarRegionEdgeForNoOverhang.set(maxDistance);
        }
    }

    public void updatePlanarRegionConstraintForDoubleSupport() {
        this.reset();
        if (this.allowUsePlanarRegionConstraints) {
            this.captureRegionCalculator.hideCaptureRegion();
            this.yoActivePlanarRegion.clear();
            this.yoActivePlanarRegionInControlPlane.clear();
            this.yoShrunkActivePlanarRegion.clear();
        }
    }

    public ConvexPolygon2D updatePlanarRegionConstraintForSingleSupport(RobotSide upcomingFootstepSide, FramePose3DReadOnly upcomingFootstep, List<Point2D> predictedContactPoints, double swingTimeRemaining, FramePoint2DReadOnly currentICP, double omega0) {
        if (this.allowUsePlanarRegionConstraints) {
            this.captureRegionCalculator.calculateCaptureRegion(upcomingFootstepSide, swingTimeRemaining, currentICP, omega0, this.bipedSupportPolygons.getFootPolygonInWorldFrame(upcomingFootstepSide.getOppositeSide()));
            this.hasConstraintChanged = false;
            if (this.usePlanarRegionConstraints.getValue()) {
                boolean planarRegionNeedsUpdating = true;
                if (this.activePlanarRegion == null) {
                    this.findPlanarRegionAttachedToFootstep(upcomingFootstep);
                }
                if (this.switchPlanarRegionConstraintsAutomatically.getBooleanValue()) {
                    if (this.activePlanarRegion != null) {
                        planarRegionNeedsUpdating = this.checkCurrentPlanarRegion();
                    }
                    if (planarRegionNeedsUpdating) {
                        this.activePlanarRegion = this.findPlanarRegionWithLargestIntersectionArea();
                        this.hasConstraintChanged = true;
                    }
                }
                if (this.activePlanarRegion != null) {
                    ConvexPolygon2D projectedAndShrunkPlanarRegion = this.computeShrunkAndProjectedConvexHull(this.activePlanarRegion, upcomingFootstepSide, predictedContactPoints);
                    return projectedAndShrunkPlanarRegion;
                }
            }
        }
        return null;
    }

    public boolean hasConstraintChanged() {
        return this.hasConstraintChanged;
    }

    private ConvexPolygon2D computeShrunkAndProjectedConvexHull(PlanarRegion planarRegion, RobotSide upcomingFootstepSide, List<Point2D> predictedContactPoints) {
        if (!predictedContactPoints.isEmpty()) {
            this.footstepPolygon.clear();
            for (int i = 0; i < predictedContactPoints.size(); ++i) {
                this.footstepPolygon.addVertex((Point2DReadOnly)predictedContactPoints.get(i));
            }
            this.footstepPolygon.update();
        } else {
            this.footstepPolygon.clear();
            List contactPoints = ((ContactablePlaneBody)this.contactableFeet.get((Enum)upcomingFootstepSide)).getContactPoints2d();
            for (int i = 0; i < contactPoints.size(); ++i) {
                FramePoint2D contactPoint = (FramePoint2D)contactPoints.get(i);
                this.footstepPolygon.addVertex((Point2DReadOnly)contactPoint);
            }
            this.footstepPolygon.update();
        }
        this.scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)this.activePlanarRegion.getConvexHull(), (ConvexPolygon2DReadOnly)this.footstepPolygon, 0.03, (ConvexPolygon2DBasics)this.tempShrunkProjectedPolygon);
        this.icpControlPlane.projectVerticesOntoControlPlane((Vertex2DSupplier)this.tempShrunkProjectedPolygon, this.activePlanarRegion.getTransformToWorld(), (ConvexPolygon2DBasics)this.projectedAndShrunkConvexHull);
        this.yoShrunkActivePlanarRegion.set((Vertex2DSupplier)this.projectedAndShrunkConvexHull);
        return this.projectedAndShrunkConvexHull;
    }

    private void findPlanarRegionAttachedToFootstep(FramePose3DReadOnly upcomingFootstep) {
        for (int regionIndex = 0; regionIndex < this.planarRegionsList.size(); ++regionIndex) {
            PlanarRegion planarRegion = (PlanarRegion)this.planarRegionsList.get(regionIndex);
            planarRegion.getTransformToWorld(this.planeTransformToWorld);
            this.planeReferenceFrame.update();
            this.tempPoint2D.setIncludingFrame((FrameTuple3DReadOnly)upcomingFootstep.getPosition());
            this.tempPoint2D.changeFrameAndProjectToXYPlane(this.planeReferenceFrame);
            if (!planarRegion.isPointInside((Point2DReadOnly)this.tempPoint2D)) continue;
            this.activePlanarRegion = planarRegion;
            this.icpControlPlane.projectPlanarRegionConvexHullOntoControlPlane(planarRegion, (ConvexPolygon2DBasics)this.tempProjectedPolygon);
            this.activePlanarRegionConvexHullInControlFrame.set(this.tempProjectedPolygon);
            break;
        }
    }

    private boolean checkCurrentPlanarRegion() {
        FrameConvexPolygon2D captureRegion = this.captureRegionCalculator.getCaptureRegion();
        captureRegion.changeFrameAndProjectToXYPlane(worldFrame);
        this.scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)this.activePlanarRegion.getConvexHull(), 0.03, (ConvexPolygon2DBasics)this.tempShrunkProjectedPolygon);
        this.icpControlPlane.projectVerticesOntoControlPlane((Vertex2DSupplier)this.tempShrunkProjectedPolygon, this.activePlanarRegion.getTransformToWorld(), (ConvexPolygon2DBasics)this.tempProjectedPolygon);
        double intersectionArea = this.convexPolygonTools.computeIntersectionAreaOfPolygons((ConvexPolygon2DReadOnly)captureRegion, (ConvexPolygon2DReadOnly)this.tempProjectedPolygon);
        if (intersectionArea > 0.01) {
            this.activePlanarRegionConvexHull.setIncludingFrame(this.planeReferenceFrame, (Vertex2DSupplier)this.activePlanarRegion.getConvexHull());
            this.activePlanarRegionConvexHull.changeFrameAndProjectToXYPlane(worldFrame);
            this.yoActivePlanarRegion.set((FrameVertex2DSupplier)this.activePlanarRegionConvexHull);
            this.icpControlPlane.projectPlanarRegionConvexHullOntoControlPlane(this.activePlanarRegion, (ConvexPolygon2DBasics)this.activePlanarRegionConvexHullInControlFrame);
            this.yoActivePlanarRegionInControlPlane.set((Vertex2DSupplier)this.activePlanarRegionConvexHullInControlFrame);
            return false;
        }
        return true;
    }

    private PlanarRegion findPlanarRegionWithLargestIntersectionArea() {
        FrameConvexPolygon2D captureRegion = this.captureRegionCalculator.getCaptureRegion();
        captureRegion.changeFrameAndProjectToXYPlane(worldFrame);
        double maxArea = 0.0;
        PlanarRegion activePlanarRegion = null;
        this.activePlanarRegionConvexHullInControlFrame.clear();
        for (int regionIndex = 0; regionIndex < this.planarRegionsList.size(); ++regionIndex) {
            PlanarRegion planarRegion = (PlanarRegion)this.planarRegionsList.get(regionIndex);
            this.scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)activePlanarRegion.getConvexHull(), 0.03, (ConvexPolygon2DBasics)this.tempShrunkProjectedPolygon);
            this.icpControlPlane.projectVerticesOntoControlPlane((Vertex2DSupplier)this.tempShrunkProjectedPolygon, activePlanarRegion.getTransformToWorld(), (ConvexPolygon2DBasics)this.tempProjectedPolygon);
            double intersectionArea = this.convexPolygonTools.computeIntersectionAreaOfPolygons((ConvexPolygon2DReadOnly)captureRegion, (ConvexPolygon2DReadOnly)this.tempProjectedPolygon);
            if (!(intersectionArea > maxArea)) continue;
            maxArea = intersectionArea;
            activePlanarRegion = planarRegion;
            this.icpControlPlane.projectPlanarRegionConvexHullOntoControlPlane(activePlanarRegion, (ConvexPolygon2DBasics)this.tempProjectedPolygon);
            this.activePlanarRegionConvexHullInControlFrame.set(this.tempProjectedPolygon);
        }
        if (activePlanarRegion == null) {
            activePlanarRegion = this.activePlanarRegion;
        }
        if (activePlanarRegion != null) {
            activePlanarRegion.getTransformToWorld(this.planeTransformToWorld);
            this.planeReferenceFrame.update();
            this.activePlanarRegionConvexHull.setIncludingFrame(this.planeReferenceFrame, (Vertex2DSupplier)activePlanarRegion.getConvexHull());
            this.activePlanarRegionConvexHull.changeFrameAndProjectToXYPlane(worldFrame);
            this.yoActivePlanarRegion.set((FrameVertex2DSupplier)this.activePlanarRegionConvexHull);
            this.yoActivePlanarRegionInControlPlane.set((Vertex2DSupplier)this.activePlanarRegionConvexHullInControlFrame);
        } else {
            this.yoActivePlanarRegion.clear();
            this.yoShrunkActivePlanarRegion.clear();
            this.yoActivePlanarRegionInControlPlane.clear();
        }
        return activePlanarRegion;
    }

    public PlanarRegion getActivePlanarRegion() {
        return this.activePlanarRegion;
    }

    public void reset() {
        this.activePlanarRegion = null;
        this.activePlanarRegionConvexHullInControlFrame.clear();
        if (this.allowUsePlanarRegionConstraints) {
            this.yoActivePlanarRegion.clear();
            this.yoShrunkActivePlanarRegion.clear();
            this.yoActivePlanarRegionInControlPlane.clear();
        }
    }

    public boolean snapFootPoseToActivePlanarRegion(FixedFramePose3DBasics footPoseToPack) {
        if (this.activePlanarRegion == null || !this.allowUsePlanarRegionConstraints) {
            return false;
        }
        this.footstepPose.set((FramePose3DReadOnly)footPoseToPack);
        this.footstepXYPosition.set((FrameTuple3DReadOnly)this.footstepPose.getPosition());
        this.footstepPose.changeFrame(worldFrame);
        this.footstepNormal.set(0.0, 0.0, 1.0);
        this.footstepPose.getOrientation().transform((FixedFrameTuple3DBasics)this.footstepNormal);
        this.activePlanarRegion.getNormal((Vector3DBasics)this.planarRegionNormal);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)this.footstepNormal, (Vector3DReadOnly)this.planarRegionNormal, (Orientation3DBasics)this.rotation);
        this.footstepXYPosition.changeFrameAndProjectToXYPlane(worldFrame);
        double zPosition = this.activePlanarRegion.getPlaneZGivenXY(this.footstepXYPosition.getX(), this.footstepXYPosition.getY());
        this.footstepPose.prependRotation((Orientation3DReadOnly)this.rotation);
        this.footstepPose.getPosition().set((FrameTuple2DReadOnly)this.footstepXYPosition);
        this.footstepPose.setZ(zPosition);
        boolean wasAdjusted = false;
        if (this.footstepPose.getZ() != footPoseToPack.getZ()) {
            wasAdjusted = true;
        }
        footPoseToPack.set((FramePose3DReadOnly)this.footstepPose);
        return wasAdjusted;
    }
}

