/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.algorithms.FrameConvexPolygonWithLineIntersector2d;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class ICPOptimizationReachabilityConstraintHandler {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final int numberOfVertices = 5;
    private static final double SUFFICIENTLY_LARGE = 5.0;
    private final SideDependentList<List<YoFramePoint2D>> reachabilityVertices = new SideDependentList();
    private final SideDependentList<YoFrameConvexPolygon2D> reachabilityPolygons = new SideDependentList();
    private final SideDependentList<List<YoFramePoint2D>> adjustmentVertices = new SideDependentList();
    private final SideDependentList<PoseReferenceFrame> stepFrames = new SideDependentList();
    private final SideDependentList<YoFrameConvexPolygon2D> adjustmentPolygons = new SideDependentList();
    private final FixedFrameConvexPolygon2DBasics adjustmentPolygon = new FrameConvexPolygon2D(worldFrame);
    private final FixedFrameConvexPolygon2DBasics reachabilityPolygon = new FrameConvexPolygon2D(worldFrame);
    private final YoFrameConvexPolygon2D contractedReachabilityPolygon;
    private final YoFrameLineSegment2D motionLimitLine;
    private final YoFrameLineSegment2D adjustmentLineSegment;
    private final DoubleProvider lengthLimit;
    private final DoubleProvider lengthBackLimit;
    private final DoubleProvider innerLimit;
    private final DoubleProvider outerLimit;
    private final DoubleProvider forwardAdjustmentLimit;
    private final DoubleProvider backwardAdjustmentLimit;
    private final DoubleProvider inwardAdjustmentLimit;
    private final DoubleProvider outwardAdjustmentLimit;
    private final ConvexPolygonTools polygonTools = new ConvexPolygonTools();
    private final FramePoint2D adjustedLocation = new FramePoint2D();
    private final FramePoint2D referenceLocation = new FramePoint2D();
    private final FrameVector2D adjustmentDirection = new FrameVector2D();
    private final FrameLine2D motionLine = new FrameLine2D();
    private final FrameConvexPolygonWithLineIntersector2d lineIntersector2d = new FrameConvexPolygonWithLineIntersector2d();

    public ICPOptimizationReachabilityConstraintHandler(SideDependentList<ReferenceFrame> soleZUpFrames, ICPOptimizationParameters icpOptimizationParameters, SteppingParameters steppingParameters, String yoNamePrefix, boolean visualize, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.lengthLimit = new DoubleParameter(yoNamePrefix + "MaxReachabilityLength", registry, steppingParameters.getMaxStepLength());
        this.lengthBackLimit = new DoubleParameter(yoNamePrefix + "MaxReachabilityBackwardLength", registry, steppingParameters.getMaxBackwardStepLength());
        this.innerLimit = new DoubleParameter(yoNamePrefix + "MaxReachabilityWidth", registry, steppingParameters.getMinStepWidth());
        this.outerLimit = new DoubleParameter(yoNamePrefix + "MinReachabilityWidth", registry, steppingParameters.getMaxStepWidth());
        this.forwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "ForwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentForward()));
        this.backwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "BackwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentBackward()));
        this.inwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "InwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentInward()));
        this.outwardAdjustmentLimit = new DoubleParameter(yoNamePrefix + "OutwardAdjustmentLimit", registry, Math.min(5.0, icpOptimizationParameters.getMaximumStepAdjustmentOutward()));
        for (RobotSide robotSide : RobotSide.values) {
            ReferenceFrame supportSoleFrame = (ReferenceFrame)soleZUpFrames.get((Enum)robotSide);
            YoInteger yoNumberOfReachabilityVertices = new YoInteger(robotSide.getLowerCaseName() + "NumberOfReachabilityVertices", registry);
            yoNumberOfReachabilityVertices.set(5);
            String prefix = yoNamePrefix + robotSide.getSideNameFirstLetter();
            ArrayList<YoFramePoint2D> reachabilityVertices = new ArrayList<YoFramePoint2D>();
            for (int i = 0; i < yoNumberOfReachabilityVertices.getValue(); ++i) {
                YoFramePoint2D vertex = new YoFramePoint2D(prefix + "ReachabilityVertex" + i, supportSoleFrame, registry);
                reachabilityVertices.add(vertex);
            }
            YoFrameConvexPolygon2D reachabilityPolygon = new YoFrameConvexPolygon2D(reachabilityVertices, yoNumberOfReachabilityVertices, supportSoleFrame);
            this.reachabilityVertices.put((Enum)robotSide, reachabilityVertices);
            this.reachabilityPolygons.put((Enum)robotSide, (Object)reachabilityPolygon);
            PoseReferenceFrame adjustmentFrame = new PoseReferenceFrame(prefix + "AdjustmentFrame", worldFrame);
            YoInteger yoNumberOfAdjustmentVertices = new YoInteger(robotSide.getLowerCaseName() + "NumberOfAdjustmentVertices", registry);
            yoNumberOfAdjustmentVertices.set(4);
            ArrayList<YoFramePoint2D> adjustmentVertices = new ArrayList<YoFramePoint2D>();
            for (int i = 0; i < 4; ++i) {
                YoFramePoint2D adjustmentVertex = new YoFramePoint2D(prefix + "AdjustmentVertex" + i, (ReferenceFrame)adjustmentFrame, registry);
                adjustmentVertices.add(adjustmentVertex);
            }
            YoFrameConvexPolygon2D adjustmentPolygon = new YoFrameConvexPolygon2D(adjustmentVertices, yoNumberOfAdjustmentVertices, (ReferenceFrame)adjustmentFrame);
            this.stepFrames.put((Enum)robotSide, (Object)adjustmentFrame);
            this.adjustmentVertices.put((Enum)robotSide, adjustmentVertices);
            this.adjustmentPolygons.put((Enum)robotSide, (Object)adjustmentPolygon);
        }
        this.contractedReachabilityPolygon = new YoFrameConvexPolygon2D(yoNamePrefix + "ReachabilityRegion", "", worldFrame, 12, registry);
        this.motionLimitLine = new YoFrameLineSegment2D(yoNamePrefix + "AdjustmentThresholdSegment", "", worldFrame, registry);
        this.adjustmentLineSegment = new YoFrameLineSegment2D(yoNamePrefix + "AdjustmentLineSegment", "", worldFrame, registry);
        if (yoGraphicsListRegistry != null) {
            YoArtifactPolygon reachabilityGraphic = new YoArtifactPolygon("ReachabilityRegionViz", this.contractedReachabilityPolygon, Color.BLUE, false);
            YoArtifactLineSegment2d adjustmentGraphic = new YoArtifactLineSegment2d("AdjustmentViz", this.adjustmentLineSegment, Color.GREEN);
            YoArtifactLineSegment2d adjustmentClippingGraphic = new YoArtifactLineSegment2d("AdjustmentClippingViz", this.motionLimitLine, Color.RED);
            reachabilityGraphic.setVisible(visualize);
            adjustmentGraphic.setVisible(visualize);
            adjustmentClippingGraphic.setVisible(visualize);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)reachabilityGraphic);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)adjustmentGraphic);
            yoGraphicsListRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)adjustmentClippingGraphic);
        }
    }

    public FrameConvexPolygon2DReadOnly initializeReachabilityConstraintForDoubleSupport() {
        this.contractedReachabilityPolygon.clear();
        this.motionLimitLine.setToNaN();
        this.adjustmentLineSegment.setToNaN();
        return null;
    }

    public FrameConvexPolygon2DReadOnly initializeReachabilityConstraintForSingleSupport(RobotSide supportSide, FramePose3DReadOnly footstepPose) {
        FrameConvexPolygon2DReadOnly reachabilityPolygon = this.getReachabilityPolygon(supportSide);
        FrameConvexPolygon2DReadOnly adjustmentPolygon = this.getAdjustmentPolygon(supportSide.getOppositeSide(), footstepPose);
        this.contractedReachabilityPolygon.checkReferenceFrameMatch((ReferenceFrameHolder)reachabilityPolygon);
        this.contractedReachabilityPolygon.checkReferenceFrameMatch((ReferenceFrameHolder)adjustmentPolygon);
        if (this.polygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)reachabilityPolygon, (ConvexPolygon2DReadOnly)adjustmentPolygon, (ConvexPolygon2DBasics)this.contractedReachabilityPolygon)) {
            return this.contractedReachabilityPolygon;
        }
        this.contractedReachabilityPolygon.clear();
        this.contractedReachabilityPolygon.addVertex(footstepPose.getPosition());
        this.contractedReachabilityPolygon.update();
        return this.contractedReachabilityPolygon;
    }

    private FrameConvexPolygon2DReadOnly getReachabilityPolygon(RobotSide supportSide) {
        List vertices = (List)this.reachabilityVertices.get((Enum)supportSide);
        YoFrameConvexPolygon2D polygon = (YoFrameConvexPolygon2D)this.reachabilityPolygons.get((Enum)supportSide);
        double xRadius = 0.5 * (this.lengthLimit.getValue() + this.lengthBackLimit.getValue());
        double yRadius = this.outerLimit.getValue() - this.innerLimit.getValue();
        double centerX = this.lengthLimit.getValue() - xRadius;
        double centerY = this.innerLimit.getValue();
        for (int vertexIdx = 0; vertexIdx < vertices.size(); ++vertexIdx) {
            double angle = Math.PI * (double)vertexIdx / (double)(vertices.size() - 1);
            double x = centerX + xRadius * Math.cos(angle);
            double y = centerY + yRadius * Math.sin(angle);
            ((YoFramePoint2D)vertices.get(vertexIdx)).set(x, supportSide.negateIfLeftSide(y));
        }
        polygon.notifyVerticesChanged();
        polygon.update();
        this.reachabilityPolygon.setMatchingFrame((FrameVertex2DSupplier)polygon, false);
        return this.reachabilityPolygon;
    }

    private FrameConvexPolygon2DReadOnly getAdjustmentPolygon(RobotSide swingSide, FramePose3DReadOnly footstepPose) {
        ((PoseReferenceFrame)this.stepFrames.get((Enum)swingSide)).setPoseAndUpdate(footstepPose);
        List vertices = (List)this.adjustmentVertices.get((Enum)swingSide);
        YoFrameConvexPolygon2D polygon = (YoFrameConvexPolygon2D)this.adjustmentPolygons.get((Enum)swingSide);
        ((YoFramePoint2D)vertices.get(0)).set(this.forwardAdjustmentLimit.getValue(), swingSide.negateIfRightSide(this.outwardAdjustmentLimit.getValue()));
        ((YoFramePoint2D)vertices.get(1)).set(this.forwardAdjustmentLimit.getValue(), swingSide.negateIfLeftSide(this.inwardAdjustmentLimit.getValue()));
        ((YoFramePoint2D)vertices.get(2)).set(-this.backwardAdjustmentLimit.getValue(), swingSide.negateIfRightSide(this.outwardAdjustmentLimit.getValue()));
        ((YoFramePoint2D)vertices.get(3)).set(-this.backwardAdjustmentLimit.getValue(), swingSide.negateIfLeftSide(this.inwardAdjustmentLimit.getValue()));
        polygon.notifyVerticesChanged();
        polygon.update();
        this.adjustmentPolygon.setMatchingFrame((FrameVertex2DSupplier)polygon, false);
        return this.adjustmentPolygon;
    }

    public void updateReachabilityBasedOnAdjustment(FramePose3DReadOnly upcomingFootstep, FixedFramePoint2DBasics footstepSolution, boolean wasAdjusted) {
        if (!wasAdjusted) {
            return;
        }
        this.referenceLocation.setIncludingFrame((FrameTuple3DReadOnly)upcomingFootstep.getPosition());
        this.adjustedLocation.setIncludingFrame((FrameTuple2DReadOnly)footstepSolution);
        this.referenceLocation.changeFrame(worldFrame);
        this.adjustedLocation.changeFrame(worldFrame);
        this.adjustmentDirection.sub((FrameTuple2DReadOnly)this.adjustedLocation, (FrameTuple2DReadOnly)this.referenceLocation);
        EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)this.adjustmentDirection, (Vector2DBasics)this.adjustmentDirection);
        this.motionLine.getPoint().set((FrameTuple2DReadOnly)this.adjustedLocation);
        this.motionLine.getDirection().set((FrameTuple2DReadOnly)this.adjustmentDirection);
        this.contractedReachabilityPolygon.update();
        ConvexPolygonTools.cutPolygonWithLine((FrameLine2DReadOnly)this.motionLine, (FixedFrameConvexPolygon2DBasics)this.contractedReachabilityPolygon, (FrameConvexPolygonWithLineIntersector2d)this.lineIntersector2d, (RobotSide)RobotSide.LEFT);
        this.adjustmentLineSegment.set((FramePoint2DReadOnly)this.referenceLocation, (FramePoint2DReadOnly)this.adjustedLocation);
        this.motionLimitLine.set((FramePoint2DReadOnly)this.lineIntersector2d.getIntersectionPointOne(), (FramePoint2DReadOnly)this.lineIntersector2d.getIntersectionPointTwo());
    }

    public FrameConvexPolygon2DReadOnly updateReachabilityConstraint() {
        this.contractedReachabilityPolygon.update();
        return this.contractedReachabilityPolygon;
    }
}

