/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ConstraintToConvexRegion;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPInequalityInput;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPConstraintCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPIndexHandler;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPInput;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPInputCalculator;
import us.ihmc.convexOptimization.quadraticProgram.AbstractSimpleActiveSetQPSolver;
import us.ihmc.convexOptimization.quadraticProgram.JavaQuadProgSolver;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class ICPOptimizationQPSolver {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean useWarmStart = true;
    private static final int maxNumberOfIterations = 100;
    private boolean resetActiveSet;
    private boolean previousTickFailed = false;
    private final ICPQPIndexHandler indexHandler;
    private final ICPQPInputCalculator inputCalculator;
    private final ICPQPConstraintCalculator constraintCalculator;
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_h;
    private final DMatrixRMaj solverInputResidualCost;
    private final DMatrixRMaj solverInput_Aineq;
    private final DMatrixRMaj solverInput_bineq;
    private final ICPQPInput copFeedbackTaskInput;
    private final ICPQPInput footstepTaskInput;
    private final ICPQPInput cmpFeedbackTaskInput;
    private final ICPQPInput feedbackRateTaskInput;
    private final ICPQPInput dynamicsTaskInput;
    private final List<ICPQPInput> inputList = new ArrayList<ICPQPInput>();
    private final ICPInequalityInput feedbackRateLimitConstraint;
    private final ICPInequalityInput feedbackLimitConstraint;
    private final List<ICPInequalityInput> constraintList = new ArrayList<ICPInequalityInput>();
    private final ConstraintToConvexRegion copLocationConstraint;
    private final ConstraintToConvexRegion cmpLocationConstraint;
    private final ConstraintToConvexRegion reachabilityConstraint;
    private final ConstraintToConvexRegion planarRegionConstraint;
    private double footstepRecursionMultiplier;
    private double footstepAdjustmentSafetyFactor;
    private final DMatrixRMaj referenceFootstepLocation = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj desiredCoP = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj desiredCMP = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj desiredCMPOffset = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj currentICPError = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj footstepWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj footstepRateWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj copFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj feedbackRateWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj copCMPFeedbackRateWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj cmpFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj dynamicsWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj feedbackGain = new DMatrixRMaj(2, 2);
    private final AbstractSimpleActiveSetQPSolver solver = new JavaQuadProgSolver();
    private final DMatrixRMaj solution;
    private final DMatrixRMaj footstepLocationSolution;
    private final DMatrixRMaj copDeltaSolution;
    private final DMatrixRMaj cmpDeltaSolution;
    private final DMatrixRMaj dynamicsError;
    private final DMatrixRMaj previousFeedbackDeltaSolution;
    private final DMatrixRMaj previousCMPFeedbackDeltaSolution;
    private final DMatrixRMaj previousCoPFeedbackDeltaSolution;
    private final DMatrixRMaj previousFootstepLocation = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj costToGo;
    private final DMatrixRMaj footstepCostToGo;
    private final DMatrixRMaj copFeedbackCostToGo;
    private final DMatrixRMaj cmpFeedbackCostToGo;
    private final DMatrixRMaj dynamicsCostToGo;
    private static final int maximumNumberOfReachabilityVertices = 4;
    private int numberOfIterations;
    private int currentInequalityConstraintIndex;
    private final boolean computeCostToGo;
    private final boolean autoSetPreviousSolution;
    private final YoBoolean hasFootstepRateTerm;
    private final YoBoolean hasFeedbackRateTerm;
    private double maxFeedbackXMagnitude = Double.POSITIVE_INFINITY;
    private double maxFeedbackYMagnitude = Double.POSITIVE_INFINITY;
    private double maximumFeedbackRate = Double.POSITIVE_INFINITY;
    private double controlDT = Double.POSITIVE_INFINITY;
    private final DMatrixRMaj tmpCost;
    private final DMatrixRMaj tmpFootstepCost;
    private final DMatrixRMaj tmpFeedbackCost;
    private double copSafeDistanceToEdge = 1.0E-4;
    private double cmpSafeDistanceFromEdge = Double.POSITIVE_INFINITY;
    private boolean hasPlanarRegionConstraint = false;
    private final DMatrixRMaj tempFootstepWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj tempCoPFeedbackWeight = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj tempFeedbackGains = new DMatrixRMaj(2, 2);
    private final FrameVector2D cmpOffsetToThrowAway = new FrameVector2D();

    public ICPOptimizationQPSolver(int maximumNumberOfCMPVertices, boolean computeCostToGo) {
        this(maximumNumberOfCMPVertices, computeCostToGo, true, null);
    }

    public ICPOptimizationQPSolver(int maximumNumberOfCMPVertices, boolean computeCostToGo, boolean autoSetPreviousSolution, YoRegistry registry) {
        this.computeCostToGo = computeCostToGo;
        this.autoSetPreviousSolution = autoSetPreviousSolution;
        this.hasFootstepRateTerm = new YoBoolean("icpQPHasFootstepRateTerm", registry);
        this.hasFeedbackRateTerm = new YoBoolean("icpQPHasFeedbackRateTerm", registry);
        this.hasFootstepRateTerm.set(false);
        this.hasFeedbackRateTerm.set(false);
        this.indexHandler = new ICPQPIndexHandler(registry);
        this.inputCalculator = new ICPQPInputCalculator(this.indexHandler);
        this.constraintCalculator = new ICPQPConstraintCalculator(this.indexHandler);
        int maximumNumberOfFreeVariables = 6;
        int maximumNumberOfLagrangeMultipliers = 8;
        this.solverInput_H = new DMatrixRMaj(maximumNumberOfFreeVariables, maximumNumberOfFreeVariables);
        this.solverInput_h = new DMatrixRMaj(maximumNumberOfFreeVariables, 1);
        this.solverInputResidualCost = new DMatrixRMaj(1, 1);
        this.copFeedbackTaskInput = new ICPQPInput(2);
        this.cmpFeedbackTaskInput = new ICPQPInput(2);
        this.footstepTaskInput = new ICPQPInput(2);
        this.dynamicsTaskInput = new ICPQPInput(6);
        this.feedbackRateTaskInput = new ICPQPInput(4);
        this.inputList.add(this.copFeedbackTaskInput);
        this.inputList.add(this.cmpFeedbackTaskInput);
        this.inputList.add(this.footstepTaskInput);
        this.inputList.add(this.dynamicsTaskInput);
        this.inputList.add(this.feedbackRateTaskInput);
        this.feedbackLimitConstraint = new ICPInequalityInput(0, 6);
        this.feedbackRateLimitConstraint = new ICPInequalityInput(0, 6);
        this.constraintList.add(this.feedbackLimitConstraint);
        this.constraintList.add(this.feedbackRateLimitConstraint);
        this.copLocationConstraint = new ConstraintToConvexRegion(maximumNumberOfCMPVertices);
        this.cmpLocationConstraint = new ConstraintToConvexRegion(maximumNumberOfCMPVertices);
        this.reachabilityConstraint = new ConstraintToConvexRegion(4);
        this.planarRegionConstraint = new ConstraintToConvexRegion(20);
        this.solverInput_Aineq = new DMatrixRMaj(maximumNumberOfCMPVertices + 4, maximumNumberOfCMPVertices + 4);
        this.solverInput_bineq = new DMatrixRMaj(maximumNumberOfCMPVertices + 4, 1);
        this.solution = new DMatrixRMaj(maximumNumberOfFreeVariables + maximumNumberOfLagrangeMultipliers, 1);
        this.footstepLocationSolution = new DMatrixRMaj(2, 1);
        this.copDeltaSolution = new DMatrixRMaj(2, 1);
        this.cmpDeltaSolution = new DMatrixRMaj(2, 1);
        this.dynamicsError = new DMatrixRMaj(2, 1);
        this.previousFeedbackDeltaSolution = new DMatrixRMaj(2, 1);
        this.previousCoPFeedbackDeltaSolution = new DMatrixRMaj(2, 1);
        this.previousCMPFeedbackDeltaSolution = new DMatrixRMaj(2, 1);
        this.tmpCost = new DMatrixRMaj(maximumNumberOfFreeVariables + maximumNumberOfLagrangeMultipliers, 1);
        this.tmpFootstepCost = new DMatrixRMaj(2, 1);
        this.tmpFeedbackCost = new DMatrixRMaj(2, 1);
        this.costToGo = new DMatrixRMaj(1, 1);
        this.footstepCostToGo = new DMatrixRMaj(1, 1);
        this.copFeedbackCostToGo = new DMatrixRMaj(1, 1);
        this.cmpFeedbackCostToGo = new DMatrixRMaj(1, 1);
        this.dynamicsCostToGo = new DMatrixRMaj(1, 1);
        this.solver.setMaxNumberOfIterations(100);
        this.solver.setUseWarmStart(true);
    }

    public void notifyResetActiveSet() {
        this.resetActiveSet = true;
    }

    private boolean pollResetActiveSet() {
        boolean ret = this.resetActiveSet;
        this.resetActiveSet = false;
        return ret;
    }

    public void setConsiderAngularMomentumInAdjustment(boolean considerAngularMomentumInAdjustment) {
        this.inputCalculator.setConsiderAngularMomentumInAdjustment(considerAngularMomentumInAdjustment);
    }

    public void setConsiderFeedbackInAdjustment(boolean considerFeedbackInAdjustment) {
        this.inputCalculator.setConsiderFeedbackInAdjustment(considerFeedbackInAdjustment);
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.solver.setMaxNumberOfIterations(maxNumberOfIterations);
    }

    public void resetCoPLocationConstraint() {
        this.copLocationConstraint.reset();
        this.cmpLocationConstraint.reset();
    }

    public void setCopSafeDistanceToEdge(double copSafeDistanceToEdge) {
        this.copSafeDistanceToEdge = copSafeDistanceToEdge;
    }

    public void setMaxCMPDistanceFromEdge(double maxCMPDistance) {
        this.cmpSafeDistanceFromEdge = maxCMPDistance;
    }

    public void addSupportPolygon(FrameConvexPolygon2DReadOnly polygon) {
        if (polygon == null) {
            return;
        }
        polygon.checkReferenceFrameMatch(worldFrame);
        this.copLocationConstraint.addPolygon((ConvexPolygon2DReadOnly)polygon);
        this.cmpLocationConstraint.addPolygon((ConvexPolygon2DReadOnly)polygon);
    }

    public void resetReachabilityConstraint() {
        this.reachabilityConstraint.reset();
    }

    public void addReachabilityPolygon(FrameConvexPolygon2DReadOnly polygon) {
        if (polygon == null) {
            return;
        }
        polygon.checkReferenceFrameMatch(worldFrame);
        polygon.checkIfUpToDate();
        this.reachabilityConstraint.addPolygon((ConvexPolygon2DReadOnly)polygon);
    }

    public void setMaximumFeedbackMagnitude(FrameVector2DReadOnly maximumFeedbackMagnitude) {
        maximumFeedbackMagnitude.checkReferenceFrameMatch(worldFrame);
        this.maxFeedbackXMagnitude = Math.abs(maximumFeedbackMagnitude.getX());
        this.maxFeedbackYMagnitude = Math.abs(maximumFeedbackMagnitude.getY());
    }

    public void setMaximumFeedbackRate(double maximumFeedbackRate, double controlDT) {
        this.maximumFeedbackRate = maximumFeedbackRate;
        this.controlDT = controlDT;
    }

    public void resetPlanarRegionConstraint() {
        this.planarRegionConstraint.reset();
        this.hasPlanarRegionConstraint = false;
    }

    public void setPlanarRegionConstraint(ConvexPolygon2D convexPolygon, double planarRegionDistanceFromEdge) {
        this.hasPlanarRegionConstraint = this.planarRegionConstraint.addPlanarRegion((ConvexPolygon2DReadOnly)convexPolygon, planarRegionDistanceFromEdge);
    }

    public void setPlanarRegionConstraint(ConvexPolygon2D convexPolygon) {
        if (convexPolygon == null) {
            return;
        }
        this.hasPlanarRegionConstraint = this.planarRegionConstraint.addPlanarRegion((ConvexPolygon2DReadOnly)convexPolygon);
    }

    private void reset() {
        int i;
        this.solverInput_H.zero();
        this.solverInput_h.zero();
        this.solverInputResidualCost.zero();
        this.solverInput_Aineq.zero();
        this.solverInput_bineq.zero();
        for (i = 0; i < this.inputList.size(); ++i) {
            this.inputList.get(i).reset();
        }
        for (i = 0; i < this.constraintList.size(); ++i) {
            this.constraintList.get(i).reset();
        }
        this.solution.zero();
        this.footstepLocationSolution.zero();
        this.copDeltaSolution.zero();
        this.cmpDeltaSolution.zero();
        this.dynamicsError.zero();
        this.currentInequalityConstraintIndex = 0;
    }

    private void reshape() {
        int problemSize = this.indexHandler.getNumberOfFreeVariables();
        int numberOfFootstepsToConsider = this.indexHandler.getNumberOfFootstepsToConsider();
        this.copLocationConstraint.setPolygon();
        this.cmpLocationConstraint.setPolygon();
        this.reachabilityConstraint.setPolygon();
        if (this.hasPlanarRegionConstraint) {
            this.planarRegionConstraint.setPolygon();
        }
        int numberOfInequalityConstraints = this.copLocationConstraint.getInequalityConstraintSize();
        if (this.indexHandler.useStepAdjustment()) {
            numberOfInequalityConstraints += this.reachabilityConstraint.getInequalityConstraintSize();
            if (this.hasPlanarRegionConstraint) {
                numberOfInequalityConstraints += this.planarRegionConstraint.getInequalityConstraintSize();
            }
        }
        if (this.indexHandler.hasCMPFeedbackTask() && (!this.indexHandler.useAngularMomentum() || Double.isFinite(this.cmpSafeDistanceFromEdge))) {
            numberOfInequalityConstraints += this.cmpLocationConstraint.getInequalityConstraintSize();
        }
        this.solverInput_H.reshape(problemSize, problemSize);
        this.solverInput_h.reshape(problemSize, 1);
        this.copFeedbackTaskInput.reshape(2);
        this.dynamicsTaskInput.reshape(problemSize);
        this.cmpFeedbackTaskInput.reshape(2);
        this.footstepTaskInput.reshape(2 * numberOfFootstepsToConsider);
        numberOfInequalityConstraints += Double.isFinite(this.maximumFeedbackRate) && Double.isFinite(this.controlDT) ? 4 : 0;
        numberOfInequalityConstraints += Double.isFinite(this.maxFeedbackXMagnitude) ? 2 : 0;
        this.solverInput_Aineq.reshape(numberOfInequalityConstraints += Double.isFinite(this.maxFeedbackYMagnitude) ? 2 : 0, problemSize);
        this.solverInput_bineq.reshape(numberOfInequalityConstraints, 1);
        this.solution.reshape(problemSize, 1);
        this.footstepLocationSolution.reshape(2 * numberOfFootstepsToConsider, 1);
    }

    public void resetCoPFeedbackConditions() {
        this.copFeedbackWeight.zero();
        this.feedbackGain.zero();
        this.dynamicsWeight.zero();
        this.hasFeedbackRateTerm.set(false);
    }

    public void resetCMPFeedbackConditions() {
        this.cmpFeedbackWeight.zero();
        this.indexHandler.setHasCMPFeedbackTask(false);
    }

    public void resetFootstepConditions() {
        this.indexHandler.resetFootsteps();
        this.footstepRateWeight.zero();
        this.referenceFootstepLocation.zero();
        this.footstepRecursionMultiplier = 0.0;
        this.footstepWeight.zero();
        this.hasFootstepRateTerm.set(false);
    }

    public void setFootstepAdjustmentConditions(double recursionMultiplier, double weight, FramePoint2D referenceFootstepLocation) {
        this.setFootstepAdjustmentConditions(recursionMultiplier, weight, weight, 1.0, referenceFootstepLocation);
    }

    public void setFootstepAdjustmentConditions(double recursionMultiplier, double xWeight, double yWeight, double safetyFactor, FramePoint2D referenceFootstepLocation) {
        this.tempFootstepWeight.set(0, 0, xWeight);
        this.tempFootstepWeight.set(1, 1, yWeight);
        this.setFootstepAdjustmentConditions(recursionMultiplier, this.tempFootstepWeight, safetyFactor, referenceFootstepLocation);
    }

    public void setFootstepAdjustmentConditions(double recursionMultiplier, DMatrixRMaj footstepWeights, double safetyFactor, FramePoint3D referenceFootstepLocation) {
        referenceFootstepLocation.changeFrame(worldFrame);
        this.setFootstepAdjustmentConditions(recursionMultiplier, footstepWeights, safetyFactor, referenceFootstepLocation.getX(), referenceFootstepLocation.getY());
    }

    public void setFootstepAdjustmentConditions(double recursionMultiplier, DMatrixRMaj footstepWeights, double safetyFactor, FramePoint2D referenceFootstepLocation) {
        referenceFootstepLocation.changeFrame(worldFrame);
        this.setFootstepAdjustmentConditions(recursionMultiplier, footstepWeights, safetyFactor, referenceFootstepLocation.getX(), referenceFootstepLocation.getY());
    }

    private void setFootstepAdjustmentConditions(double recursionMultiplier, DMatrixRMaj footstepWeights, double safetyFactor, double referenceXPositionInWorld, double referenceYPositionInWorld) {
        this.footstepRecursionMultiplier = recursionMultiplier;
        this.footstepAdjustmentSafetyFactor = safetyFactor;
        this.footstepWeight.set((DMatrixD1)footstepWeights);
        this.referenceFootstepLocation.set(0, 0, referenceXPositionInWorld);
        this.referenceFootstepLocation.set(1, 0, referenceYPositionInWorld);
        this.indexHandler.registerFootstep();
    }

    public void setCMPFeedbackConditions(double cmpFeedbackWeight, boolean useAngularMomentum) {
        MatrixTools.setDiagonal((DMatrix1Row)this.cmpFeedbackWeight, (double)cmpFeedbackWeight);
        this.indexHandler.setHasCMPFeedbackTask(true);
        this.indexHandler.setUseAngularMomentum(useAngularMomentum);
    }

    public void setFootstepRateWeight(double rateWeight) {
        MatrixTools.setDiagonal((DMatrix1Row)this.footstepRateWeight, (double)rateWeight);
        this.hasFootstepRateTerm.set(true);
    }

    public void resetFootstepRate(FramePoint2D previousFootstepLocation) {
        previousFootstepLocation.changeFrame(worldFrame);
        this.previousFootstepLocation.set(0, 0, previousFootstepLocation.getX());
        this.previousFootstepLocation.set(1, 0, previousFootstepLocation.getY());
    }

    public void resetFootstepRate(FramePoint3D previousFootstepLocation) {
        previousFootstepLocation.changeFrame(worldFrame);
        this.previousFootstepLocation.set(0, 0, previousFootstepLocation.getX());
        this.previousFootstepLocation.set(1, 0, previousFootstepLocation.getY());
    }

    public void resetFeedbackRate(FramePoint2D previousFeedbackDeltaSolution) {
        previousFeedbackDeltaSolution.changeFrame(worldFrame);
        this.previousFeedbackDeltaSolution.set(0, 0, previousFeedbackDeltaSolution.getX());
        this.previousFeedbackDeltaSolution.set(1, 0, previousFeedbackDeltaSolution.getY());
    }

    public void setFeedbackConditions(double copFeedbackWeight, double feedbackGain, double dynamicsWeight) {
        this.setFeedbackConditions(copFeedbackWeight, copFeedbackWeight, feedbackGain, feedbackGain, dynamicsWeight);
    }

    public void setFeedbackConditions(double copFeedbackXWeight, double copFeedbackYWeight, double feedbackXGain, double feedbackYGain, double dynamicsWeight) {
        this.tempCoPFeedbackWeight.set(0, 0, copFeedbackXWeight);
        this.tempCoPFeedbackWeight.set(1, 1, copFeedbackYWeight);
        this.tempFeedbackGains.set(0, 0, feedbackXGain);
        this.tempFeedbackGains.set(1, 1, feedbackYGain);
        this.setFeedbackConditions(this.tempCoPFeedbackWeight, this.tempFeedbackGains, dynamicsWeight);
    }

    public void setFeedbackConditions(DMatrixRMaj copFeedbackWeights, DMatrixRMaj feedbackGains, double dynamicsWeight) {
        this.copFeedbackWeight.set((DMatrixD1)copFeedbackWeights);
        this.feedbackGain.set((DMatrixD1)feedbackGains);
        MatrixTools.setDiagonal((DMatrix1Row)this.dynamicsWeight, (double)dynamicsWeight);
    }

    public void setFeedbackRateWeight(double copCMPFeedbackRateWeight, double feedbackRateWeight) {
        MatrixTools.setDiagonal((DMatrix1Row)this.feedbackRateWeight, (double)feedbackRateWeight);
        MatrixTools.setDiagonal((DMatrix1Row)this.copCMPFeedbackRateWeight, (double)copCMPFeedbackRateWeight);
        this.hasFeedbackRateTerm.set(true);
    }

    public boolean compute(FrameVector2DReadOnly currentICPError, FramePoint2DReadOnly desiredCoP) {
        this.cmpOffsetToThrowAway.setToZero(worldFrame);
        return this.compute(currentICPError, desiredCoP, (FrameVector2DReadOnly)this.cmpOffsetToThrowAway);
    }

    public boolean compute(FrameVector2DReadOnly currentICPError, FramePoint2DReadOnly desiredCoP, FrameVector2DReadOnly desiredCMPOffset) {
        boolean foundSolution;
        this.indexHandler.computeProblemSize();
        this.reset();
        this.reshape();
        currentICPError.checkReferenceFrameMatch(worldFrame);
        desiredCoP.checkReferenceFrameMatch(worldFrame);
        desiredCMPOffset.checkReferenceFrameMatch(worldFrame);
        currentICPError.get((DMatrix)this.currentICPError);
        desiredCoP.get((DMatrix)this.desiredCoP);
        desiredCMPOffset.get((DMatrix)this.desiredCMPOffset);
        CommonOps_DDRM.add((DMatrixD1)this.desiredCoP, (DMatrixD1)this.desiredCMPOffset, (DMatrixD1)this.desiredCMP);
        this.addCoPFeedbackTask();
        if (this.indexHandler.useStepAdjustment()) {
            this.addStepAdjustmentTask();
        }
        if (this.indexHandler.hasCMPFeedbackTask()) {
            this.addCMPFeedbackTask();
        }
        if (this.hasFeedbackRateTerm.getBooleanValue()) {
            this.addFeedbackRateTask();
        }
        this.addDynamicConstraintTask();
        if (this.copLocationConstraint.getInequalityConstraintSize() > 0) {
            this.addCoPLocationConstraint();
        }
        if (this.indexHandler.hasCMPFeedbackTask() && this.cmpLocationConstraint.getInequalityConstraintSize() > 0) {
            this.addCMPLocationConstraint();
        }
        if (this.indexHandler.useStepAdjustment()) {
            if (this.reachabilityConstraint.getInequalityConstraintSize() > 0) {
                this.addReachabilityConstraint();
            }
            if (this.planarRegionConstraint.getInequalityConstraintSize() > 0) {
                this.addPlanarRegionConstraint();
            }
        }
        if (!this.previousTickFailed) {
            this.addMaximumFeedbackMagnitudeConstraint();
            this.addMaximumFeedbackRateConstraint();
        }
        boolean bl = this.previousTickFailed = !(foundSolution = this.solve(this.solution));
        if (foundSolution) {
            if (this.indexHandler.useStepAdjustment()) {
                this.extractFootstepSolutions(this.footstepLocationSolution);
                if (this.autoSetPreviousSolution) {
                    this.setPreviousFootstepSolution(this.footstepLocationSolution);
                }
            }
            this.extractCoPFeedbackDeltaSolution(this.copDeltaSolution);
            this.extractCMPFeedbackDeltaSolution(this.cmpDeltaSolution);
            this.inputCalculator.computeDynamicConstraintError(this.solution, this.dynamicsError);
            if (this.autoSetPreviousSolution) {
                this.setPreviousFeedbackDeltaSolution(this.copDeltaSolution, this.cmpDeltaSolution);
            }
            this.computeWholeCostToGo();
            if (this.computeCostToGo) {
                this.computeCostToGo();
            }
        }
        return foundSolution;
    }

    public boolean previousTickFailed() {
        return this.previousTickFailed;
    }

    private void addStepAdjustmentTask() {
        int stepIndex = 0;
        this.inputCalculator.computeFootstepTask(stepIndex, this.footstepTaskInput, this.footstepWeight, this.referenceFootstepLocation);
        if (this.hasFootstepRateTerm.getBooleanValue()) {
            this.inputCalculator.computeFootstepRateTask(stepIndex, this.footstepTaskInput, this.footstepRateWeight, this.previousFootstepLocation);
        }
        this.inputCalculator.submitFootstepTask(this.footstepTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addCoPFeedbackTask() {
        ICPQPInputCalculator.computeCoPFeedbackTask(this.copFeedbackTaskInput, this.copFeedbackWeight);
        this.inputCalculator.submitCoPFeedbackTask(this.copFeedbackTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addCMPFeedbackTask() {
        this.inputCalculator.computeCMPFeedbackTask(this.cmpFeedbackTaskInput, this.cmpFeedbackWeight);
        this.inputCalculator.submitCMPFeedbackTask(this.cmpFeedbackTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addFeedbackRateTask() {
        this.inputCalculator.computeCoPFeedbackRateTask(this.feedbackRateTaskInput, this.copCMPFeedbackRateWeight, this.previousCoPFeedbackDeltaSolution);
        this.inputCalculator.computeCMPFeedbackRateTask(this.feedbackRateTaskInput, this.copCMPFeedbackRateWeight, this.previousCMPFeedbackDeltaSolution);
        this.inputCalculator.computeFeedbackRateTask(this.feedbackRateTaskInput, this.feedbackRateWeight, this.previousFeedbackDeltaSolution);
        this.inputCalculator.submitFeedbackRateTask(this.feedbackRateTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addCoPLocationConstraint() {
        this.copLocationConstraint.setPositionOffset(this.desiredCoP);
        this.copLocationConstraint.setDeltaInside(this.copSafeDistanceToEdge);
        this.copLocationConstraint.formulateConstraint();
        int constraintSize = this.copLocationConstraint.getInequalityConstraintSize();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.copLocationConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.copLocationConstraint.bineq, (int)0, (int)0, (int)constraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += constraintSize;
    }

    private void addCMPLocationConstraint() {
        double cmpConstraintBound = this.indexHandler.useAngularMomentum() ? -this.cmpSafeDistanceFromEdge : this.copSafeDistanceToEdge;
        if (!Double.isFinite(cmpConstraintBound)) {
            return;
        }
        this.cmpLocationConstraint.setPositionOffset(this.desiredCMP);
        this.cmpLocationConstraint.setDeltaInside(cmpConstraintBound);
        this.cmpLocationConstraint.formulateConstraint();
        int constraintSize = this.cmpLocationConstraint.getInequalityConstraintSize();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)this.indexHandler.getCoPFeedbackIndex(), (DMatrix)this.cmpLocationConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)this.indexHandler.getCMPFeedbackIndex(), (DMatrix)this.cmpLocationConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.cmpLocationConstraint.bineq, (int)0, (int)0, (int)constraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += constraintSize;
    }

    private void addReachabilityConstraint() {
        this.reachabilityConstraint.setDeltaInside(0.0);
        this.reachabilityConstraint.formulateConstraint();
        int constraintSize = this.reachabilityConstraint.getInequalityConstraintSize();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.reachabilityConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.reachabilityConstraint.bineq, (int)0, (int)0, (int)constraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += constraintSize;
    }

    private void addPlanarRegionConstraint() {
        this.planarRegionConstraint.formulateConstraint();
        int constraintSize = this.planarRegionConstraint.getInequalityConstraintSize();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)this.indexHandler.getFootstepStartIndex(), (DMatrix)this.planarRegionConstraint.Aineq, (int)0, (int)0, (int)constraintSize, (int)2, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.planarRegionConstraint.bineq, (int)0, (int)0, (int)constraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += constraintSize;
    }

    private void addDynamicConstraintTask() {
        this.inputCalculator.computeDynamicsTask(this.dynamicsTaskInput, this.currentICPError, this.referenceFootstepLocation, this.feedbackGain, this.dynamicsWeight, this.footstepRecursionMultiplier, this.footstepAdjustmentSafetyFactor);
        this.inputCalculator.submitDynamicsTask(this.dynamicsTaskInput, this.solverInput_H, this.solverInput_h, this.solverInputResidualCost);
    }

    private void addMaximumFeedbackMagnitudeConstraint() {
        this.constraintCalculator.calculateMaxFeedbackMagnitudeConstraint(this.feedbackLimitConstraint, this.maxFeedbackXMagnitude, this.maxFeedbackYMagnitude);
        int feedbackMagnitudeConstraintSize = this.feedbackLimitConstraint.getNumberOfConstraints();
        int numberOfVariables = this.feedbackLimitConstraint.getNumberOfVariables();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackLimitConstraint.Aineq, (int)0, (int)0, (int)feedbackMagnitudeConstraintSize, (int)numberOfVariables, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackLimitConstraint.bineq, (int)0, (int)0, (int)feedbackMagnitudeConstraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += feedbackMagnitudeConstraintSize;
    }

    private void addMaximumFeedbackRateConstraint() {
        this.constraintCalculator.calculateMaxFeedbackRateConstraint(this.feedbackRateLimitConstraint, this.maximumFeedbackRate, this.previousFeedbackDeltaSolution, this.controlDT);
        int feedbackRateConstraintSize = this.feedbackRateLimitConstraint.getNumberOfConstraints();
        int numberOfVariables = this.feedbackLimitConstraint.getNumberOfVariables();
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Aineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackRateLimitConstraint.Aineq, (int)0, (int)0, (int)feedbackRateConstraintSize, (int)numberOfVariables, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bineq, (int)this.currentInequalityConstraintIndex, (int)0, (DMatrix)this.feedbackRateLimitConstraint.bineq, (int)0, (int)0, (int)feedbackRateConstraintSize, (int)1, (double)1.0);
        this.currentInequalityConstraintIndex += feedbackRateConstraintSize;
    }

    private boolean solve(DMatrixRMaj solutionToPack) {
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.solverInput_h);
        for (int i = 0; i < this.solverInput_H.numCols; ++i) {
            if (!(this.solverInput_H.get(i, i) < 0.0)) continue;
            throw new RuntimeException("Hey this is bad.");
        }
        this.solver.clear();
        if (this.pollResetActiveSet() || this.previousTickFailed) {
            this.solver.resetActiveSet();
        }
        this.solver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_h, this.solverInputResidualCost.get(0, 0));
        this.solver.setLinearInequalityConstraints((DMatrix)this.solverInput_Aineq, (DMatrix)this.solverInput_bineq);
        try {
            this.numberOfIterations = this.solver.solve((DMatrix)solutionToPack);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogTools.warn((String)"ICP optimization crashed with exception.");
            return false;
        }
        return !MatrixTools.containsNaN((DMatrix1Row)solutionToPack);
    }

    private void extractFootstepSolutions(DMatrixRMaj footstepLocationSolutionToPack) {
        MatrixTools.setMatrixBlock((DMatrix)footstepLocationSolutionToPack, (int)0, (int)0, (DMatrix)this.solution, (int)this.indexHandler.getFootstepStartIndex(), (int)0, (int)this.indexHandler.getNumberOfFootstepVariables(), (int)1, (double)1.0);
    }

    private void extractCoPFeedbackDeltaSolution(DMatrixRMaj copFeedbackSolutionToPack) {
        MatrixTools.setMatrixBlock((DMatrix)copFeedbackSolutionToPack, (int)0, (int)0, (DMatrix)this.solution, (int)this.indexHandler.getCoPFeedbackIndex(), (int)0, (int)2, (int)1, (double)1.0);
    }

    private void extractCMPFeedbackDeltaSolution(DMatrixRMaj cmpDeltaSolutionToPack) {
        if (this.indexHandler.hasCMPFeedbackTask()) {
            MatrixTools.setMatrixBlock((DMatrix)cmpDeltaSolutionToPack, (int)0, (int)0, (DMatrix)this.solution, (int)this.indexHandler.getCMPFeedbackIndex(), (int)0, (int)2, (int)1, (double)1.0);
        } else {
            cmpDeltaSolutionToPack.zero();
        }
    }

    private void setPreviousFootstepSolution(DMatrixRMaj footstepLocationSolution) {
        int stepIndex = 0;
        MatrixTools.setMatrixBlock((DMatrix)this.previousFootstepLocation, (int)0, (int)0, (DMatrix)footstepLocationSolution, (int)(2 * stepIndex), (int)0, (int)2, (int)1, (double)1.0);
    }

    private void setPreviousFeedbackDeltaSolution(DMatrixRMaj copFeedbackSolution, DMatrixRMaj cmpFeedbackSolution) {
        this.previousCoPFeedbackDeltaSolution.set((DMatrixD1)copFeedbackSolution);
        this.previousCMPFeedbackDeltaSolution.set((DMatrixD1)cmpFeedbackSolution);
        CommonOps_DDRM.add((DMatrixD1)cmpFeedbackSolution, (DMatrixD1)copFeedbackSolution, (DMatrixD1)this.previousFeedbackDeltaSolution);
    }

    private void computeWholeCostToGo() {
        this.tmpCost.zero();
        this.tmpCost.reshape(this.indexHandler.getNumberOfFreeVariables(), 1);
        this.costToGo.zero();
        CommonOps_DDRM.mult((DMatrix1Row)this.solverInput_H, (DMatrix1Row)this.solution, (DMatrix1Row)this.tmpCost);
        CommonOps_DDRM.multTransA((double)0.5, (DMatrix1Row)this.solution, (DMatrix1Row)this.tmpCost, (DMatrix1Row)this.costToGo);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.solverInput_h, (DMatrix1Row)this.solution, (DMatrix1Row)this.costToGo);
        CommonOps_DDRM.addEquals((DMatrixD1)this.costToGo, (DMatrixD1)this.solverInputResidualCost);
    }

    private void computeCostToGo() {
        this.tmpFootstepCost.zero();
        this.tmpFeedbackCost.zero();
        this.tmpCost.zero();
        this.tmpFootstepCost.reshape(this.indexHandler.getNumberOfFootstepVariables(), 1);
        this.tmpFeedbackCost.reshape(2, 1);
        this.footstepCostToGo.zero();
        this.copFeedbackCostToGo.zero();
        this.cmpFeedbackCostToGo.zero();
        this.dynamicsCostToGo.zero();
        CommonOps_DDRM.mult((DMatrix1Row)this.copFeedbackTaskInput.quadraticTerm, (DMatrix1Row)this.copDeltaSolution, (DMatrix1Row)this.tmpFeedbackCost);
        CommonOps_DDRM.multTransA((double)0.5, (DMatrix1Row)this.copDeltaSolution, (DMatrix1Row)this.tmpFeedbackCost, (DMatrix1Row)this.copFeedbackCostToGo);
        CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)this.copFeedbackTaskInput.linearTerm, (DMatrix1Row)this.copDeltaSolution, (DMatrix1Row)this.copFeedbackCostToGo);
        CommonOps_DDRM.addEquals((DMatrixD1)this.copFeedbackCostToGo, (DMatrixD1)this.copFeedbackTaskInput.residualCost);
        CommonOps_DDRM.mult((DMatrix1Row)this.dynamicsTaskInput.quadraticTerm, (DMatrix1Row)this.solution, (DMatrix1Row)this.tmpCost);
        CommonOps_DDRM.multTransA((double)0.5, (DMatrix1Row)this.solution, (DMatrix1Row)this.tmpCost, (DMatrix1Row)this.dynamicsCostToGo);
        CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)this.dynamicsTaskInput.linearTerm, (DMatrix1Row)this.solution, (DMatrix1Row)this.dynamicsCostToGo);
        CommonOps_DDRM.addEquals((DMatrixD1)this.dynamicsCostToGo, (DMatrixD1)this.dynamicsTaskInput.residualCost);
        if (this.indexHandler.useStepAdjustment()) {
            CommonOps_DDRM.mult((DMatrix1Row)this.footstepTaskInput.quadraticTerm, (DMatrix1Row)this.footstepLocationSolution, (DMatrix1Row)this.tmpFootstepCost);
            CommonOps_DDRM.multTransA((double)0.5, (DMatrix1Row)this.footstepLocationSolution, (DMatrix1Row)this.tmpFootstepCost, (DMatrix1Row)this.footstepCostToGo);
            CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)this.footstepTaskInput.linearTerm, (DMatrix1Row)this.footstepLocationSolution, (DMatrix1Row)this.footstepCostToGo);
            CommonOps_DDRM.addEquals((DMatrixD1)this.footstepCostToGo, (DMatrixD1)this.footstepTaskInput.residualCost);
        }
        if (this.indexHandler.hasCMPFeedbackTask()) {
            CommonOps_DDRM.mult((DMatrix1Row)this.cmpFeedbackTaskInput.quadraticTerm, (DMatrix1Row)this.cmpDeltaSolution, (DMatrix1Row)this.tmpFeedbackCost);
            CommonOps_DDRM.multTransA((double)0.5, (DMatrix1Row)this.cmpDeltaSolution, (DMatrix1Row)this.tmpFeedbackCost, (DMatrix1Row)this.cmpFeedbackCostToGo);
            CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)this.cmpFeedbackTaskInput.linearTerm, (DMatrix1Row)this.cmpDeltaSolution, (DMatrix1Row)this.cmpFeedbackCostToGo);
            CommonOps_DDRM.addEquals((DMatrixD1)this.cmpFeedbackCostToGo, (DMatrixD1)this.cmpFeedbackTaskInput.residualCost);
        }
    }

    public void getFootstepSolutionLocation(int footstepIndex, FixedFramePoint2DBasics footstepLocationToPack) {
        footstepLocationToPack.checkReferenceFrameMatch(worldFrame);
        footstepLocationToPack.setX(this.footstepLocationSolution.get(2 * footstepIndex, 0));
        footstepLocationToPack.setY(this.footstepLocationSolution.get(2 * footstepIndex + 1, 0));
    }

    public void getCoPFeedbackDifference(FixedFrameVector2DBasics cmpFeedbackDifferenceToPack) {
        cmpFeedbackDifferenceToPack.checkReferenceFrameMatch(worldFrame);
        cmpFeedbackDifferenceToPack.setX(this.copDeltaSolution.get(0, 0));
        cmpFeedbackDifferenceToPack.setY(this.copDeltaSolution.get(1, 0));
    }

    public void getCMPFeedbackDifference(FixedFrameVector2DBasics differenceToPack) {
        differenceToPack.checkReferenceFrameMatch(worldFrame);
        differenceToPack.setX(this.cmpDeltaSolution.get(0, 0));
        differenceToPack.setY(this.cmpDeltaSolution.get(1, 0));
    }

    public double getCostToGo() {
        return this.costToGo.get(0);
    }

    public double getFootstepCostToGo() {
        return this.footstepCostToGo.get(0);
    }

    public double getCoPFeedbackCostToGo() {
        return this.copFeedbackCostToGo.get(0);
    }

    public double getCMPFeedbackCostToGo() {
        return this.cmpFeedbackCostToGo.get(0);
    }

    public double getDynamicsCostToGo() {
        return this.dynamicsCostToGo.get(0);
    }

    public void getDynamicsError(FixedFrameVector2DBasics errorToPack) {
        errorToPack.checkReferenceFrameMatch(worldFrame);
        errorToPack.setX(this.dynamicsError.get(0));
        errorToPack.setY(this.dynamicsError.get(1));
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    ConstraintToConvexRegion getCoPLocationConstraint() {
        return this.copLocationConstraint;
    }

    ConstraintToConvexRegion getCMPLocationConstraint() {
        return this.cmpLocationConstraint;
    }

    public double getFootstepRecursionMultiplier() {
        return this.footstepRecursionMultiplier;
    }

    public double getFootstepAdjustmentSafetyFactor() {
        return this.footstepAdjustmentSafetyFactor;
    }
}

