/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import org.ejml.data.DMatrix1Row;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.FrameMatrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class ICPOptimizationControllerHelper {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final Vector2dZUpFrame icpVelocityDirectionFrame = new Vector2dZUpFrame("icpVelocityDirectionFrame", worldFrame);
    private final FrameMatrix3D frameMatrix3D = new FrameMatrix3D();
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final FrameVector2D tempVector = new FrameVector2D();

    public double transformGainsFromDynamicsFrame(DMatrix1Row feedbackGainsToPack, FrameVector2DReadOnly desiredICPVelocity, double parallelGain, double orthogonalGain) {
        return this.transformFromDynamicsFrame(feedbackGainsToPack, desiredICPVelocity, parallelGain + 1.0, orthogonalGain + 1.0);
    }

    public double transformFromDynamicsFrame(DMatrix1Row valuesToPack, FrameVector2DReadOnly desiredICPVelocity, double parallelValue, double orthogonalValue) {
        double epsilonZeroICPVelocity = 1.0E-5;
        if (desiredICPVelocity.lengthSquared() > MathTools.square((double)epsilonZeroICPVelocity)) {
            this.icpVelocityDirectionFrame.setXAxis((FrameTuple2DReadOnly)desiredICPVelocity);
            this.transformValues(valuesToPack, parallelValue, orthogonalValue, this.icpVelocityDirectionFrame, worldFrame);
            return Math.sqrt(parallelValue * parallelValue + orthogonalValue * orthogonalValue);
        }
        valuesToPack.set(0, 0, orthogonalValue);
        valuesToPack.set(0, 1, 0.0);
        valuesToPack.set(1, 0, 0.0);
        valuesToPack.set(1, 1, orthogonalValue);
        return Math.sqrt(2.0 * orthogonalValue * orthogonalValue);
    }

    public void transformFromDynamicsFrame(FixedFrameVector2DBasics valuesToPack, FrameVector2DReadOnly desiredICPVelocity, double parallelValue, double orthogonalValue) {
        double epsilonZeroICPVelocity = 1.0E-5;
        if (desiredICPVelocity.lengthSquared() > MathTools.square((double)epsilonZeroICPVelocity)) {
            this.icpVelocityDirectionFrame.setXAxis((FrameTuple2DReadOnly)desiredICPVelocity);
            this.icpVelocityDirectionFrame.getTransformToDesiredFrame(this.tempTransform, worldFrame);
            this.tempVector.setIncludingFrame((ReferenceFrame)this.icpVelocityDirectionFrame, parallelValue, orthogonalValue);
            this.tempVector.changeFrameAndProjectToXYPlane(valuesToPack.getReferenceFrame());
            valuesToPack.set((FrameTuple2DReadOnly)this.tempVector);
        } else {
            valuesToPack.setX(orthogonalValue);
            valuesToPack.setY(orthogonalValue);
        }
    }

    public void transformToWorldFrame(DMatrix1Row weightsToPack, double xValue, double yValue, ReferenceFrame frame) {
        this.transformValues(weightsToPack, xValue, yValue, frame, worldFrame);
    }

    private void transformValues(DMatrix1Row valuesToPack, double xValue, double yValue, ReferenceFrame currentFrame, ReferenceFrame desiredFrame) {
        this.frameMatrix3D.setToZero(currentFrame);
        this.frameMatrix3D.setM00(xValue);
        this.frameMatrix3D.setM11(yValue);
        this.frameMatrix3D.changeFrame(desiredFrame);
        valuesToPack.set(0, 0, this.frameMatrix3D.getElement(0, 0));
        valuesToPack.set(0, 1, this.frameMatrix3D.getElement(0, 1));
        valuesToPack.set(1, 0, this.frameMatrix3D.getElement(1, 0));
        valuesToPack.set(1, 1, this.frameMatrix3D.getElement(1, 1));
    }

    private class Vector2dZUpFrame
    extends ReferenceFrame {
        private final FrameVector2D xAxis;
        private final Vector3D x;
        private final Vector3D y;
        private final Vector3D z;
        private final RotationMatrix rotation;

        public Vector2dZUpFrame(String string, ReferenceFrame parentFrame) {
            super(string, parentFrame);
            this.x = new Vector3D();
            this.y = new Vector3D();
            this.z = new Vector3D();
            this.rotation = new RotationMatrix();
            this.xAxis = new FrameVector2D(parentFrame);
        }

        public void setXAxis(FrameTuple2DReadOnly xAxis) {
            this.xAxis.setIncludingFrame(xAxis);
            this.xAxis.changeFrame(this.getParent());
            this.xAxis.normalize();
            this.update();
        }

        protected void updateTransformToParent(RigidBodyTransform transformToParent) {
            this.x.set(this.xAxis.getX(), this.xAxis.getY(), 0.0);
            this.z.set(0.0, 0.0, 1.0);
            this.y.cross((Tuple3DReadOnly)this.z, (Tuple3DReadOnly)this.x);
            this.rotation.setColumns((Tuple3DReadOnly)this.x, (Tuple3DReadOnly)this.y, (Tuple3DReadOnly)this.z);
            transformToParent.setRotationAndZeroTranslation((RotationMatrixReadOnly)this.rotation);
        }
    }
}

