/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.optimization;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPolygons;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class ICPOptimizationCoPConstraintHandler {
    private final BipedSupportPolygons bipedSupportPolygons;
    private final ICPControlPolygons icpControlPolygons;
    private final boolean hasICPControlPolygons;
    private final BooleanProvider useICPControlPolygons;
    private final YoBoolean keepCoPInsideSupportPolygon;
    private int numberOfVertices = 0;
    private boolean hasSupportPolygonChanged;

    public ICPOptimizationCoPConstraintHandler(BipedSupportPolygons bipedSupportPolygons, ICPControlPolygons icpControlPolygons, BooleanProvider useICPControlPolygons, boolean hasICPControlPolygons, YoRegistry parentRegistry) {
        this.bipedSupportPolygons = bipedSupportPolygons;
        this.icpControlPolygons = icpControlPolygons;
        this.useICPControlPolygons = useICPControlPolygons;
        this.hasICPControlPolygons = hasICPControlPolygons;
        this.keepCoPInsideSupportPolygon = new YoBoolean("keepCoPInsideSupportPolygon", parentRegistry);
        this.keepCoPInsideSupportPolygon.set(true);
    }

    public FrameConvexPolygon2DReadOnly updateCoPConstraint() {
        if (this.keepCoPInsideSupportPolygon.getBooleanValue()) {
            FrameConvexPolygon2DReadOnly supportPolygon = this.useICPControlPolygons.getValue() && this.icpControlPolygons != null && this.hasICPControlPolygons ? this.icpControlPolygons.getControlPolygonInWorldFrame() : this.bipedSupportPolygons.getSupportPolygonInWorld();
            if (supportPolygon.getNumberOfVertices() != this.numberOfVertices) {
                this.hasSupportPolygonChanged = true;
                this.numberOfVertices = supportPolygon.getNumberOfVertices();
            } else {
                this.hasSupportPolygonChanged = false;
            }
            return supportPolygon;
        }
        return null;
    }

    public boolean hasSupportPolygonChanged() {
        return this.hasSupportPolygonChanged;
    }

    public void setKeepCoPInsideSupportPolygon(boolean keepCoPInsideSupportPolygon) {
        this.keepCoPInsideSupportPolygon.set(keepCoPInsideSupportPolygon);
    }
}

