/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.lqrControl;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.LQRCommonValues;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.S1Function;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.S2Segment;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;

public class DifferentialS2Segment
implements S2Segment {
    private final double dt;
    private final DMatrixRMaj Nb = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj s2Dot = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj q2 = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj r2 = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj rs = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj S1 = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj referenceVRP = new DMatrixRMaj(3, 1);
    private final RecyclingArrayList<DMatrixRMaj> s2ReverseTrajectory = new RecyclingArrayList(() -> new DMatrixRMaj(6, 1));
    private final List<DMatrixRMaj> s2Trajectory = new ArrayList<DMatrixRMaj>();
    private final DMatrixRMaj CTransposeQ = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj DTransposeQ = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj NBTransposeRInverse = new DMatrixRMaj(3, 3);

    public DifferentialS2Segment(double dt) {
        this.dt = dt;
    }

    public void set(S1Function s1Segment, Polynomial3D vrpTrajectory, LQRCommonValues lqrCommonValues, DMatrixRMaj s2AtEnd) {
        this.set(s1Segment, vrpTrajectory, lqrCommonValues.getQ(), lqrCommonValues.getR1Inverse(), lqrCommonValues.getNTranspose(), lqrCommonValues.getA(), lqrCommonValues.getB(), lqrCommonValues.getC(), lqrCommonValues.getD(), s2AtEnd);
    }

    public void set(S1Function s1Segment, Polynomial3D vrpTrajectory, DMatrixRMaj Q, DMatrixRMaj R1Inverse, DMatrixRMaj NTranspose, DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C, DMatrixRMaj D, DMatrixRMaj s2AtEnd) {
        this.s2ReverseTrajectory.clear();
        this.s2Trajectory.clear();
        ((DMatrixRMaj)this.s2ReverseTrajectory.add()).set((DMatrixD1)s2AtEnd);
        double duration = vrpTrajectory.getTimeInterval().getDuration();
        for (double t = duration - this.dt; t >= 0.0; t -= this.dt) {
            DMatrixRMaj previousS2 = (DMatrixRMaj)this.s2ReverseTrajectory.getLast();
            DMatrixRMaj newS2 = (DMatrixRMaj)this.s2ReverseTrajectory.add();
            s1Segment.compute(t, this.S1);
            vrpTrajectory.compute(t);
            vrpTrajectory.getPosition().get((DMatrix)this.referenceVRP);
            this.computeNb(B, NTranspose, this.S1);
            this.computeQ2(C, Q, this.referenceVRP);
            this.computeR2(D, Q, this.referenceVRP);
            this.computeRs(B, previousS2);
            this.computeS2Dot(this.q2, this.Nb, R1Inverse, previousS2, A);
            CommonOps_DDRM.add((DMatrixD1)previousS2, (double)(-this.dt), (DMatrixD1)this.s2Dot, (DMatrixD1)newS2);
        }
        for (int i = this.s2ReverseTrajectory.size() - 1; i >= 0; --i) {
            this.s2Trajectory.add((DMatrixRMaj)this.s2ReverseTrajectory.get(i));
        }
    }

    @Override
    public void compute(double timeInState, DMatrixRMaj s2ToPack) {
        int startIndex = this.getStartIndex(timeInState);
        if (startIndex >= this.s2Trajectory.size() - 1) {
            s2ToPack.set((DMatrixD1)this.s2Trajectory.get(this.s2Trajectory.size() - 1));
            return;
        }
        DMatrixRMaj start = this.s2Trajectory.get(startIndex);
        DMatrixRMaj end = this.s2Trajectory.get(startIndex + 1);
        DifferentialS2Segment.interpolate(start, end, this.getAlphaBetweenSegments(timeInState), s2ToPack);
    }

    private int getStartIndex(double timeInState) {
        return (int)Math.floor(timeInState / this.dt + this.dt / 10.0);
    }

    private double getAlphaBetweenSegments(double timeInState) {
        return timeInState % this.dt / this.dt;
    }

    private static void interpolate(DMatrixRMaj start, DMatrixRMaj end, double alpha, DMatrixRMaj ret) {
        CommonOps_DDRM.scale((double)(1.0 - alpha), (DMatrixD1)start, (DMatrixD1)ret);
        CommonOps_DDRM.addEquals((DMatrixD1)ret, (double)alpha, (DMatrixD1)end);
    }

    private void computeNb(DMatrixRMaj B, DMatrixRMaj NTranspose, DMatrixRMaj S1) {
        CommonOps_DDRM.multTransA((DMatrix1Row)B, (DMatrix1Row)S1, (DMatrix1Row)this.Nb);
        CommonOps_DDRM.addEquals((DMatrixD1)this.Nb, (DMatrixD1)NTranspose);
    }

    private void computeQ2(DMatrixRMaj C, DMatrixRMaj Q, DMatrixRMaj referenceVRP) {
        CommonOps_DDRM.multTransA((double)-2.0, (DMatrix1Row)C, (DMatrix1Row)Q, (DMatrix1Row)this.CTransposeQ);
        CommonOps_DDRM.mult((DMatrix1Row)this.CTransposeQ, (DMatrix1Row)referenceVRP, (DMatrix1Row)this.q2);
    }

    private void computeR2(DMatrixRMaj D, DMatrixRMaj Q, DMatrixRMaj referenceVRP) {
        CommonOps_DDRM.multTransA((DMatrix1Row)D, (DMatrix1Row)Q, (DMatrix1Row)this.DTransposeQ);
        CommonOps_DDRM.mult((double)-2.0, (DMatrix1Row)this.DTransposeQ, (DMatrix1Row)referenceVRP, (DMatrix1Row)this.r2);
    }

    private void computeRs(DMatrixRMaj B, DMatrixRMaj s2) {
        CommonOps_DDRM.multTransA((double)0.5, (DMatrix1Row)B, (DMatrix1Row)s2, (DMatrix1Row)this.rs);
        CommonOps_DDRM.addEquals((DMatrixD1)this.rs, (double)0.5, (DMatrixD1)this.r2);
    }

    private void computeS2Dot(DMatrixRMaj q2, DMatrixRMaj NB, DMatrixRMaj R1Inverse, DMatrixRMaj s2, DMatrixRMaj A) {
        CommonOps_DDRM.multTransA((DMatrix1Row)NB, (DMatrix1Row)R1Inverse, (DMatrix1Row)this.NBTransposeRInverse);
        CommonOps_DDRM.mult((double)2.0, (DMatrix1Row)this.NBTransposeRInverse, (DMatrix1Row)this.rs, (DMatrix1Row)this.s2Dot);
        CommonOps_DDRM.addEquals((DMatrixD1)this.s2Dot, (double)-1.0, (DMatrixD1)q2);
        CommonOps_DDRM.multAddTransA((double)-1.0, (DMatrix1Row)A, (DMatrix1Row)s2, (DMatrix1Row)this.s2Dot);
    }
}

