/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.controller;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.qpInput.ICPQPInput;
import us.ihmc.matrixlib.MatrixTools;

public class ICPControllerQPInputCalculator {
    private final DMatrixRMaj feedbackJacobian = new DMatrixRMaj(2, 6);
    private final DMatrixRMaj feedbackObjective = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj feedbackJtW = new DMatrixRMaj(6, 2);
    final DMatrixRMaj directionJacobian = new DMatrixRMaj(1, 6);
    private final DMatrixRMaj invertedFeedbackGain = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj aTb = new DMatrixRMaj(6, 6);

    public static void computeCoPFeedbackMinimizationTask(ICPQPInput icpQPInputToPack, DMatrixRMaj feedbackWeight) {
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)0, (int)0, (DMatrix1Row)feedbackWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
    }

    public static void computeCMPFeedbackMinimizationTask(ICPQPInput icpQPInputToPack, DMatrixRMaj cmpFeedbackWeight) {
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)0, (int)0, (DMatrix1Row)cmpFeedbackWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
    }

    public void computeCoPFeedbackRateMinimizationTask(ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        this.computeQuadraticTask(0, icpQPInputToPack, rateWeight, objective);
    }

    public void computeCMPFeedbackRateMinimizationTask(ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        this.computeQuadraticTask(2, icpQPInputToPack, rateWeight, objective);
    }

    public void computeTotalFeedbackRateMinimizationTask(ICPQPInput icpQPInputToPack, DMatrixRMaj rateWeight, DMatrixRMaj objective) {
        this.computeQuadraticTask(0, icpQPInputToPack, rateWeight, objective);
        this.computeQuadraticTask(2, icpQPInputToPack, rateWeight, objective, false);
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)0, (int)2, (DMatrix1Row)rateWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)2, (int)0, (DMatrix1Row)rateWeight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
    }

    public void computeDynamicsTask(ICPQPInput icpQPInput, DMatrixRMaj currentICPError, DMatrixRMaj feedbackGain, DMatrixRMaj weight, boolean useAngularMomentum) {
        UnrolledInverseFromMinor_DDRM.inv((DMatrixRMaj)feedbackGain, (DMatrixRMaj)this.invertedFeedbackGain);
        int size = 2;
        if (useAngularMomentum) {
            size += 2;
        }
        this.feedbackJacobian.reshape(2, size);
        this.feedbackJtW.reshape(size, 2);
        this.feedbackJacobian.zero();
        this.feedbackJtW.zero();
        this.feedbackObjective.zero();
        MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)0, (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        if (useAngularMomentum) {
            MatrixTools.setMatrixBlock((DMatrix)this.feedbackJacobian, (int)0, (int)2, (DMatrix)this.invertedFeedbackGain, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        }
        MatrixTools.setMatrixBlock((DMatrix)this.feedbackObjective, (int)0, (int)0, (DMatrix)currentICPError, (int)0, (int)0, (int)2, (int)1, (double)1.0);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.feedbackJacobian, (DMatrix1Row)weight, (DMatrix1Row)this.feedbackJtW);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.feedbackJtW, (DMatrix1Row)this.feedbackJacobian, (DMatrix1Row)icpQPInput.quadraticTerm);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.feedbackJtW, (DMatrix1Row)this.feedbackObjective, (DMatrix1Row)icpQPInput.linearTerm);
        this.multAddInner(0.5, this.feedbackObjective, weight, icpQPInput.residualCost);
    }

    public void computeFeedbackDirectionTask(ICPQPInput icpQPInput, DMatrixRMaj desiredFeedbackDirection, double weight, boolean useAngularMomentum) {
        int size = 2;
        if (useAngularMomentum) {
            size += 2;
        }
        this.directionJacobian.reshape(1, size);
        this.directionJacobian.zero();
        this.directionJacobian.set(0, 0, desiredFeedbackDirection.get(1));
        this.directionJacobian.set(0, 1, -desiredFeedbackDirection.get(0));
        if (useAngularMomentum) {
            this.directionJacobian.set(0, 2, desiredFeedbackDirection.get(1));
            this.directionJacobian.set(0, 3, -desiredFeedbackDirection.get(0));
        }
        MatrixTools.multAddInner((double)weight, (DMatrix1Row)this.directionJacobian, (DMatrix1Row)icpQPInput.quadraticTerm);
    }

    public void computeResidualDynamicsError(DMatrixRMaj solution, DMatrixRMaj errorToPack) {
        errorToPack.reshape(2, 1);
        CommonOps_DDRM.mult((DMatrix1Row)this.feedbackJacobian, (DMatrix1Row)solution, (DMatrix1Row)errorToPack);
        CommonOps_DDRM.addEquals((DMatrixD1)errorToPack, (double)-1.0, (DMatrixD1)this.feedbackObjective);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)errorToPack);
    }

    private void computeQuadraticTask(int startIndex, ICPQPInput icpQPInputToPack, DMatrixRMaj weight, DMatrixRMaj objective) {
        this.computeQuadraticTask(startIndex, icpQPInputToPack, weight, objective, true);
    }

    private void computeQuadraticTask(int startIndex, ICPQPInput icpQPInputToPack, DMatrixRMaj weight, DMatrixRMaj objective, boolean includeResidual) {
        MatrixTools.addMatrixBlock((DMatrix)icpQPInputToPack.quadraticTerm, (int)startIndex, (int)startIndex, (DMatrix1Row)weight, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.multAddBlock((DMatrix1Row)weight, (DMatrix1Row)objective, (DMatrix1Row)icpQPInputToPack.linearTerm, (int)startIndex, (int)0);
        if (includeResidual) {
            this.multAddInner(0.5, objective, weight, icpQPInputToPack.residualCost);
        }
    }

    private void multAddInner(double scalar, DMatrixRMaj jac, DMatrixRMaj weight, DMatrixRMaj resultToPack) {
        this.quadraticMultAddTransA(scalar, jac, weight, jac, resultToPack);
    }

    private void quadraticMultAddTransA(double scalar, DMatrixRMaj a, DMatrixRMaj b, DMatrixRMaj c, DMatrixRMaj resultToPack) {
        this.aTb.reshape(a.getNumCols(), b.getNumCols());
        CommonOps_DDRM.multTransA((double)scalar, (DMatrix1Row)a, (DMatrix1Row)b, (DMatrix1Row)this.aTb);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.aTb, (DMatrix1Row)c, (DMatrix1Row)resultToPack);
    }

    public static void submitCoPFeedbackMinimizationTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)2, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public static void submitCMPFeedbackMinimizationTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)2, (int)2, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)2, (int)2, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)2, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)2, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public static void submitFeedbackRateMinimizationTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int size = icpQPInput.linearTerm.getNumRows();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)size, (int)size, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)size, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }

    public static void submitDynamicsTask(ICPQPInput icpQPInput, DMatrixRMaj solverInput_H_ToPack, DMatrixRMaj solverInput_h_ToPack, DMatrixRMaj solverInputResidualCostToPack) {
        int size = icpQPInput.linearTerm.getNumRows();
        MatrixTools.addMatrixBlock((DMatrix)solverInput_H_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.quadraticTerm, (int)0, (int)0, (int)size, (int)size, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInput_h_ToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.linearTerm, (int)0, (int)0, (int)size, (int)1, (double)1.0);
        MatrixTools.addMatrixBlock((DMatrix)solverInputResidualCostToPack, (int)0, (int)0, (DMatrix1Row)icpQPInput.residualCost, (int)0, (int)0, (int)1, (int)1, (double)1.0);
    }
}

