/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint.controller;

import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AngularMomentumIntegrator {
    private final BooleanProvider useSmartICPIntegrator;
    private final YoFrameVector2D feedbackCMPIntegral;
    private final YoDouble currentCoMVelocityMagnitude;
    private final YoDouble desiredICPVelocityMagnitude;
    private final ICPControlGainsReadOnly feedbackGains;
    private final FrameVector2D tempVector2d = new FrameVector2D();
    private final GlitchFilteredYoBoolean isICPStuck;
    private final DoubleProvider thresholdForStuck;
    private final double controlDT;

    public AngularMomentumIntegrator(String prefix, ICPOptimizationParameters icpOptimizationParameters, ICPControlGainsReadOnly feedbackGains, double controlDT, YoRegistry registry) {
        this.controlDT = controlDT;
        this.feedbackGains = feedbackGains;
        this.isICPStuck = new GlitchFilteredYoBoolean(prefix + "IsICPStuck", registry, (int)(0.03 / controlDT));
        this.currentCoMVelocityMagnitude = new YoDouble(prefix + "CurrentCoMVelocityMagnitude", registry);
        this.desiredICPVelocityMagnitude = new YoDouble(prefix + "DesiredICPVelocityMagnitude", registry);
        this.useSmartICPIntegrator = new BooleanParameter(prefix + "UseSmartICPIntegrator", registry, icpOptimizationParameters.useSmartICPIntegrator());
        this.thresholdForStuck = new DoubleParameter(prefix + "ThresholdForStuck", registry, icpOptimizationParameters.getICPVelocityThresholdForStuck());
        this.feedbackCMPIntegral = new YoFrameVector2D(prefix + "FeedbackCMPIntegral", ReferenceFrame.getWorldFrame(), registry);
    }

    public void reset() {
        this.isICPStuck.set(false);
    }

    public void update(FrameVector2DReadOnly desiredICPVelocity, FrameVector2DReadOnly currentCoMVelocity, FrameVector2DReadOnly icpError) {
        this.desiredICPVelocityMagnitude.set(desiredICPVelocity.length());
        if (this.desiredICPVelocityMagnitude.getDoubleValue() > this.thresholdForStuck.getValue()) {
            this.isICPStuck.set(false);
            this.feedbackCMPIntegral.setToZero();
            return;
        }
        this.currentCoMVelocityMagnitude.set(currentCoMVelocity.length());
        if (this.currentCoMVelocityMagnitude.getDoubleValue() < this.thresholdForStuck.getValue()) {
            this.isICPStuck.set(true);
        }
        if (this.useSmartICPIntegrator.getValue() && this.isICPStuck.getBooleanValue()) {
            this.tempVector2d.set((FrameTuple2DReadOnly)icpError);
            this.tempVector2d.scale(this.controlDT * this.feedbackGains.getKi());
            this.feedbackCMPIntegral.scale(Math.pow(this.feedbackGains.getIntegralLeakRatio(), this.controlDT));
            this.feedbackCMPIntegral.add((FrameTuple2DReadOnly)this.tempVector2d);
            double length = this.feedbackCMPIntegral.length();
            double maxLength = this.feedbackGains.getMaxIntegralError();
            if (length > maxLength) {
                this.feedbackCMPIntegral.scale(maxLength / length);
            }
            if (Math.abs(this.feedbackGains.getKi()) < 1.0E-10) {
                this.feedbackCMPIntegral.setToZero();
            }
        } else {
            this.feedbackCMPIntegral.setToZero();
        }
    }

    public FrameVector2DReadOnly getFeedbackCMPIntegral() {
        return this.feedbackCMPIntegral;
    }
}

