/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsProvider;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoICPControlGains
implements ICPControlGainsProvider {
    private final YoDouble kpParallelToMotion;
    private final YoDouble kpOrthogonalToMotion;
    private final YoDouble ki;
    private final YoDouble integralLeakRatio;
    private final YoDouble maxIntegralError;
    private final YoDouble feedbackPartMaxRate;
    private final YoDouble feedbackPartMaxValueParallelToMotion;
    private final YoDouble feedbackPartMaxValueOrthogonalToMotion;

    public YoICPControlGains(String suffix, YoRegistry registry) {
        this.kpParallelToMotion = new YoDouble("captureKpParallel" + suffix, registry);
        this.kpOrthogonalToMotion = new YoDouble("captureKpOrthogonal" + suffix, registry);
        this.ki = new YoDouble("captureKi" + suffix, registry);
        this.integralLeakRatio = new YoDouble("captureIntegralLeakRatio" + suffix, registry);
        this.maxIntegralError = new YoDouble("captureMaxIntegralError" + suffix, registry);
        this.feedbackPartMaxRate = new YoDouble("feedbackPartMaxRate" + suffix, registry);
        this.feedbackPartMaxValueParallelToMotion = new YoDouble("feedbackPartMaxValueParallelToMotion" + suffix, registry);
        this.feedbackPartMaxValueOrthogonalToMotion = new YoDouble("feedbackPartMaxValueOrthogonalToMotion" + suffix, registry);
        this.integralLeakRatio.set(1.0);
        this.maxIntegralError.set(Double.POSITIVE_INFINITY);
        this.feedbackPartMaxRate.set(Double.POSITIVE_INFINITY);
        this.feedbackPartMaxValueParallelToMotion.set(Double.POSITIVE_INFINITY);
        this.feedbackPartMaxValueOrthogonalToMotion.set(Double.POSITIVE_INFINITY);
    }

    public void setKpParallelToMotion(double kpParallelToMotion) {
        this.kpParallelToMotion.set(kpParallelToMotion);
    }

    public void setKpOrthogonalToMotion(double kpOrthogonalToMotion) {
        this.kpOrthogonalToMotion.set(kpOrthogonalToMotion);
    }

    public void setKi(double ki) {
        this.ki.set(ki);
    }

    public void setIntegralLeakRatio(double integralLeakRatio) {
        this.integralLeakRatio.set(integralLeakRatio);
    }

    public void setMaxIntegralError(double maxIntegralError) {
        this.maxIntegralError.set(maxIntegralError);
    }

    public void setFeedbackPartMaxRate(double maxRate) {
        this.feedbackPartMaxRate.set(maxRate);
    }

    public void setFeedbackPartMaxValueParallelToMotion(double maxValue) {
        this.feedbackPartMaxValueParallelToMotion.set(maxValue);
    }

    public void setFeedbackPartMaxValueOrthogonalToMotion(double maxValue) {
        this.feedbackPartMaxValueOrthogonalToMotion.set(maxValue);
    }

    public YoDouble getYoKpParallelToMotion() {
        return this.kpParallelToMotion;
    }

    public YoDouble getYoKpOrthogonalToMotion() {
        return this.kpOrthogonalToMotion;
    }

    public YoDouble getYoKi() {
        return this.ki;
    }

    public YoDouble getYoIntegralLeakRatio() {
        return this.integralLeakRatio;
    }

    public YoDouble getYoMaxIntegralError() {
        return this.maxIntegralError;
    }

    public YoDouble getYoFeedbackPartMaxRate() {
        return this.feedbackPartMaxRate;
    }

    public YoDouble getYoFeedbackPartMaxValueParallelToMotion() {
        return this.feedbackPartMaxValueParallelToMotion;
    }

    public YoDouble getYoFeedbackPartMaxValueOrthogonalToMotion() {
        return this.feedbackPartMaxValueOrthogonalToMotion;
    }

    public void set(ICPControlGainsReadOnly icpControlGains) {
        this.setKpParallelToMotion(icpControlGains.getKpParallelToMotion());
        this.setKpOrthogonalToMotion(icpControlGains.getKpOrthogonalToMotion());
        this.setKi(icpControlGains.getKi());
        this.setIntegralLeakRatio(icpControlGains.getIntegralLeakRatio());
        this.setMaxIntegralError(icpControlGains.getMaxIntegralError());
        this.setFeedbackPartMaxRate(icpControlGains.getFeedbackPartMaxRate());
        this.setFeedbackPartMaxValueParallelToMotion(icpControlGains.getFeedbackPartMaxValueParallelToMotion());
        this.setFeedbackPartMaxValueOrthogonalToMotion(icpControlGains.getFeedbackPartMaxValueOrthogonalToMotion());
    }
}

