/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.messageHandlers.CenterOfMassTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.MomentumTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchDistributorTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.robotics.math.filters.AlphaFilteredTuple2D;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class PrecomputedICPPlanner {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoFramePoint3D yoDesiredCoPPosition = new YoFramePoint3D(this.name + "DesiredCoPPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D yoDesiredCMPPosition = new YoFramePoint3D(this.name + "DesiredCMPPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D yoDesiredCoMPosition = new YoFramePoint3D(this.name + "DesiredCoMPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D yoDesiredICPPosition = new YoFramePoint3D(this.name + "DesiredICPPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D yoDesiredICPVelocity = new YoFrameVector3D(this.name + "DesiredICPVelocity", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoBoolean currentlyBlendingICPTrajectories = new YoBoolean("currentlyBlendingICPTrajectories", this.registry);
    private final YoBoolean isBlending = new YoBoolean("isBlending", this.registry);
    private final YoDouble blendingStartTime = new YoDouble("blendingStartTime", this.registry);
    private final YoDouble blendingDuration = new YoDouble("blendingDuration", this.registry);
    private final YoDouble omega0 = new YoDouble(this.name + "Omega0", this.registry);
    private final FramePoint3D desiredCoPPosition = new FramePoint3D();
    private final FramePoint3D desiredCMPPosition = new FramePoint3D();
    private final FramePoint3D desiredCoMPosition = new FramePoint3D();
    private final FrameVector3D desiredCoMVelocity = new FrameVector3D();
    private final FrameVector3D desiredCoMAcceleration = new FrameVector3D();
    private final FramePoint3D desiredICPPosition = new FramePoint3D();
    private final FrameVector3D desiredICPVelocity = new FrameVector3D();
    private final FrameVector3D filteredDesiredICPVelocity = new FrameVector3D();
    private final FrameVector3D desiredAngularMomentum = new FrameVector3D();
    private final FrameVector3D desiredAngularMomentumRate = new FrameVector3D();
    private final CenterOfMassTrajectoryHandler centerOfMassTrajectoryHandler;
    private final MomentumTrajectoryHandler momentumTrajectoryHandler;
    private double mass;
    private double gravity;
    private final DoubleParameter filterBreakFrequency = new DoubleParameter("PrecomputedICPVelocityFilterBreakFrequency", this.registry, 5.0);
    private final DoubleProvider alphaProvider;
    private final Tuple2DBasics filteredPrecomputedIcpVelocity;
    private final FramePoint2D tempICPPosition = new FramePoint2D();
    private final FramePoint2D tempCoPPosition = new FramePoint2D();

    public PrecomputedICPPlanner(CenterOfMassTrajectoryHandler centerOfMassTrajectoryHandler, MomentumTrajectoryHandler momentumTrajectoryHandler, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(Double.NaN, centerOfMassTrajectoryHandler, momentumTrajectoryHandler, parentRegistry, yoGraphicsListRegistry);
    }

    public PrecomputedICPPlanner(final double dt, CenterOfMassTrajectoryHandler centerOfMassTrajectoryHandler, MomentumTrajectoryHandler momentumTrajectoryHandler, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.centerOfMassTrajectoryHandler = centerOfMassTrajectoryHandler;
        this.momentumTrajectoryHandler = momentumTrajectoryHandler;
        this.blendingDuration.set(0.5);
        if (!Double.isNaN(dt)) {
            this.alphaProvider = new DoubleProvider(){

                public double getValue() {
                    return AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)PrecomputedICPPlanner.this.filterBreakFrequency.getValue(), (double)dt);
                }
            };
            this.filteredPrecomputedIcpVelocity = new AlphaFilteredTuple2D(this.alphaProvider);
        } else {
            this.alphaProvider = null;
            this.filteredPrecomputedIcpVelocity = new Vector2D();
        }
        parentRegistry.addChild(this.registry);
        if (yoGraphicsListRegistry != null) {
            YoGraphicsList yoGraphicsList = new YoGraphicsList(this.getClass().getSimpleName());
            ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
            YoGraphicPosition desiredICPPositionGraphic = new YoGraphicPosition("Desired ICP Precomputed", this.yoDesiredICPPosition, 0.005, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            yoGraphicsList.add((YoGraphic)desiredICPPositionGraphic);
            artifactList.add((Artifact)desiredICPPositionGraphic.createArtifact());
            YoGraphicPosition desiredCenterOfMassPositionViz = new YoGraphicPosition("Desired CoM Precomputed", this.yoDesiredCoMPosition, 0.003, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            yoGraphicsList.add((YoGraphic)desiredCenterOfMassPositionViz);
            artifactList.add((Artifact)desiredCenterOfMassPositionViz.createArtifact());
            YoGraphicPosition desiredCoPPositionViz = new YoGraphicPosition("Perfect CoP Precomputed", this.yoDesiredCoPPosition, 0.005, YoAppearance.BlueViolet(), YoGraphicPosition.GraphicType.DIAMOND);
            YoGraphicPosition desiredCMPPositionViz = new YoGraphicPosition("Perfect CMP Precomputed", this.yoDesiredCMPPosition, 0.005, YoAppearance.BlueViolet());
            artifactList.add((Artifact)desiredCoPPositionViz.createArtifact());
            yoGraphicsList.add((YoGraphic)desiredCMPPositionViz);
            artifactList.add((Artifact)desiredCMPPositionViz.createArtifact());
            yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
            yoGraphicsListRegistry.registerArtifactList(artifactList);
        }
        this.hideViz();
    }

    private void compute(double time) {
        double omega0 = this.omega0.getDoubleValue();
        this.centerOfMassTrajectoryHandler.packDesiredICPAtTime(time, omega0, this.desiredICPPosition, this.desiredICPVelocity, this.desiredCoMPosition);
        this.filteredPrecomputedIcpVelocity.set((Tuple3DReadOnly)this.desiredICPVelocity);
        this.filteredDesiredICPVelocity.set((Tuple2DReadOnly)this.filteredPrecomputedIcpVelocity);
        CapturePointTools.computeCentroidalMomentumPivot((FramePoint3DReadOnly)this.desiredICPPosition, (FrameVector3DReadOnly)this.filteredDesiredICPVelocity, omega0, (FixedFramePoint3DBasics)this.desiredCMPPosition);
        CapturePointTools.computeCenterOfMassVelocity((FramePoint3DReadOnly)this.desiredCoMPosition, (FramePoint3DReadOnly)this.desiredICPPosition, omega0, (FixedFrameVector3DBasics)this.desiredCoMVelocity);
        CapturePointTools.computeCenterOfMassAcceleration((FrameVector3DReadOnly)this.desiredCoMVelocity, (FrameVector3DReadOnly)this.filteredDesiredICPVelocity, omega0, (FixedFrameVector3DBasics)this.desiredCoMAcceleration);
        double comZAcceleration = this.desiredCoMAcceleration.getZ();
        this.desiredCoPPosition.set(this.desiredCMPPosition);
        if (this.momentumTrajectoryHandler != null && this.momentumTrajectoryHandler.packDesiredAngularMomentumAtTime(time, (FrameVector3DBasics)this.desiredAngularMomentum, (FrameVector3DBasics)this.desiredAngularMomentumRate)) {
            double fZ = WrenchDistributorTools.computeFz(this.mass, this.gravity, comZAcceleration);
            this.desiredCoPPosition.addX(-this.desiredAngularMomentumRate.getY() / fZ);
            this.desiredCoPPosition.addY(this.desiredAngularMomentumRate.getX() / fZ);
        }
        this.yoDesiredICPPosition.set((FrameTuple3DReadOnly)this.desiredICPPosition);
        this.yoDesiredICPVelocity.set((FrameTuple3DReadOnly)this.desiredICPVelocity);
        this.yoDesiredCoMPosition.set((FrameTuple3DReadOnly)this.desiredCoMPosition);
        this.yoDesiredCoPPosition.set((FrameTuple3DReadOnly)this.desiredCoPPosition);
        this.yoDesiredCMPPosition.set((FrameTuple3DReadOnly)this.desiredCMPPosition);
    }

    public void compute(double time, FramePoint2DBasics desiredCapturePoint2dToPack, FrameVector2DBasics desiredCapturePointVelocity2dToPack, FramePoint2DBasics desiredCoP2DToPack) {
        if (this.isWithinInterval(time)) {
            this.compute(time);
            desiredCapturePoint2dToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.desiredICPPosition);
            desiredCapturePointVelocity2dToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)this.filteredPrecomputedIcpVelocity);
            desiredCoP2DToPack.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.desiredCoPPosition);
        } else {
            this.hideViz();
        }
        this.currentlyBlendingICPTrajectories.set(false);
        this.centerOfMassTrajectoryHandler.clearPointsInPast();
        this.momentumTrajectoryHandler.clearPointsInPast();
    }

    public void computeAndBlend(double time, FixedFramePoint2DBasics desiredCapturePoint2dToPack, FixedFrameVector2DBasics desiredCapturePointVelocity2dToPack, FixedFramePoint2DBasics desiredCenterOfPressure2dToPack) {
        desiredCapturePoint2dToPack.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        desiredCapturePointVelocity2dToPack.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        desiredCenterOfPressure2dToPack.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        if (this.isWithinInterval(time)) {
            double alpha;
            this.compute(time);
            if (!this.currentlyBlendingICPTrajectories.getBooleanValue()) {
                this.blendingStartTime.set(time);
                this.currentlyBlendingICPTrajectories.set(true);
            }
            this.isBlending.set((alpha = (time - this.blendingStartTime.getDoubleValue()) / this.blendingDuration.getDoubleValue()) < 1.0);
            alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
            this.tempICPPosition.set((FrameTuple3DReadOnly)this.desiredICPPosition);
            this.tempCoPPosition.set((FrameTuple3DReadOnly)this.desiredCoPPosition);
            desiredCapturePoint2dToPack.interpolate((FrameTuple2DReadOnly)desiredCapturePoint2dToPack, (FrameTuple2DReadOnly)this.tempICPPosition, alpha);
            desiredCapturePointVelocity2dToPack.interpolate((FrameTuple2DReadOnly)desiredCapturePointVelocity2dToPack, (Tuple2DReadOnly)this.filteredPrecomputedIcpVelocity, alpha);
            desiredCenterOfPressure2dToPack.interpolate((FrameTuple2DReadOnly)desiredCenterOfPressure2dToPack, (FrameTuple2DReadOnly)this.tempCoPPosition, alpha);
        } else {
            this.isBlending.set(false);
            this.currentlyBlendingICPTrajectories.set(false);
            this.hideViz();
        }
        this.centerOfMassTrajectoryHandler.clearPointsInPast();
        this.momentumTrajectoryHandler.clearPointsInPast();
    }

    public boolean isWithinInterval(double time) {
        return this.centerOfMassTrajectoryHandler.isWithinInterval(time);
    }

    public void setOmega0(double omega0) {
        this.omega0.set(omega0);
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    private void hideViz() {
        this.yoDesiredICPPosition.setToNaN();
        this.yoDesiredICPVelocity.setToNaN();
        this.yoDesiredCoMPosition.setToNaN();
        this.yoDesiredCMPPosition.setToNaN();
    }
}

