/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleOutput;
import us.ihmc.commonWalkingControlModules.capturePoint.controller.ICPController;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.CapturePointCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumControlCore.CoMHeightController;
import us.ihmc.commonWalkingControlModules.momentumControlCore.HeightController;
import us.ihmc.commonWalkingControlModules.momentumControlCore.PelvisHeightController;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchDistributorTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.FilteredVelocityYoFrameVector2d;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameVector;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class LinearMomentumRateControlModule {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Vector3DReadOnly linearMomentumRateWeight;
    private final Vector3DReadOnly recoveryLinearMomentumRateWeight;
    private final Vector3DReadOnly angularMomentumRateWeight;
    private final BooleanProvider allowMomentumRecoveryWeight;
    private final YoBoolean useRecoveryMomentumWeight;
    private final DoubleParameter maxMomentumRateWeightChangeRate;
    private final RateLimitedYoFrameVector desiredLinearMomentumRateWeight;
    private final YoBoolean minimizingAngularMomentumRateZ = new YoBoolean("MinimizingAngularMomentumRateZ", this.registry);
    private final YoFrameVector3D controlledCoMAcceleration;
    private final MomentumRateCommand momentumRateCommand = new MomentumRateCommand();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private final PelvisHeightController pelvisHeightController;
    private final CoMHeightController comHeightController;
    private FeedbackControlCommand<?> heightControlCommand;
    private double omega0;
    private double totalMass;
    private double gravityZ;
    private final ReferenceFrame centerOfMassFrame;
    private final FramePoint3D centerOfMass;
    private final FramePoint2D centerOfMass2d = new FramePoint2D();
    private final FramePoint2D capturePoint = new FramePoint2D();
    private final CapturePointCalculator capturePointCalculator;
    private final FixedFramePoint2DBasics desiredCapturePoint = new FramePoint2D();
    private final FixedFrameVector2DBasics desiredCapturePointVelocity = new FrameVector2D();
    private final FixedFramePoint2DBasics perfectCMP = new FramePoint2D();
    private final FixedFramePoint2DBasics perfectCoP = new FramePoint2D();
    private final FixedFramePoint2DBasics desiredCMP = new FramePoint2D();
    private final FixedFramePoint2DBasics desiredCoP = new FramePoint2D();
    private final FixedFramePoint2DBasics achievedCMP = new FramePoint2D();
    private final FixedFramePoint2DBasics desiredCoPInMidFeet;
    private boolean controlHeightWithMomentum;
    private final FrameVector3D achievedLinearMomentumRate = new FrameVector3D();
    private final FrameVector2D achievedCoMAcceleration2d = new FrameVector2D();
    private double desiredCoMHeightAcceleration = 0.0;
    private final FramePoint3D cmp3d = new FramePoint3D();
    private final FrameVector3D linearMomentumRateOfChange = new FrameVector3D();
    private boolean desiredCMPcontainedNaN = false;
    private boolean desiredCoPcontainedNaN = false;
    private final ICPController icpController;
    private final ICPControlPlane icpControlPlane;
    private final BipedSupportPolygons bipedSupportPolygons;
    private final ICPControlPolygons icpControlPolygons;
    private final FixedFrameVector2DBasics perfectCMPDelta = new FrameVector2D();
    private final YoFramePoint2D yoDesiredCMP = new YoFramePoint2D("desiredCMP", worldFrame, this.registry);
    private final YoFramePoint2D yoAchievedCMP = new YoFramePoint2D("achievedCMP", worldFrame, this.registry);
    private final YoFramePoint3D yoCenterOfMass = new YoFramePoint3D("centerOfMass", worldFrame, this.registry);
    private final YoFramePoint2D yoCapturePoint = new YoFramePoint2D("capturePoint", worldFrame, this.registry);
    private final FilteredVelocityYoFrameVector2d capturePointVelocity;
    private final DoubleProvider capturePointVelocityBreakFrequency = new DoubleParameter("capturePointVelocityBreakFrequency", this.registry, 26.5);
    private final DoubleParameter centerOfPressureWeight = new DoubleParameter("CenterOfPressureObjectiveWeight", this.registry, 0.0);
    private final CenterOfPressureCommand centerOfPressureCommand = new CenterOfPressureCommand();
    private final ReferenceFrame midFootZUpFrame;
    private boolean initializeOnStateChange;
    private boolean keepCoPInsideSupportPolygon;
    private final SideDependentList<PlaneContactStateCommand> contactStateCommands = new SideDependentList((Object)new PlaneContactStateCommand(), (Object)new PlaneContactStateCommand());
    private final LinearMomentumRateControlModuleOutput output = new LinearMomentumRateControlModuleOutput();

    public LinearMomentumRateControlModule(CommonHumanoidReferenceFrames referenceFrames, SideDependentList<ContactableFoot> contactableFeet, RigidBodyBasics elevator, WalkingControllerParameters walkingControllerParameters, double gravityZ, double controlDT, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)elevator);
        this.gravityZ = gravityZ;
        MomentumOptimizationSettings momentumOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        this.linearMomentumRateWeight = new ParameterVector3D("LinearMomentumRateWeight", (Tuple3DReadOnly)momentumOptimizationSettings.getLinearMomentumWeight(), this.registry);
        this.recoveryLinearMomentumRateWeight = new ParameterVector3D("RecoveryLinearMomentumRateWeight", (Tuple3DReadOnly)momentumOptimizationSettings.getRecoveryLinearMomentumWeight(), this.registry);
        this.angularMomentumRateWeight = new ParameterVector3D("AngularMomentumRateWeight", (Tuple3DReadOnly)momentumOptimizationSettings.getAngularMomentumWeight(), this.registry);
        this.allowMomentumRecoveryWeight = new BooleanParameter("allowMomentumRecoveryWeight", this.registry, false);
        this.maxMomentumRateWeightChangeRate = new DoubleParameter("maxMomentumRateWeightChangeRate", this.registry, 10.0);
        this.useRecoveryMomentumWeight = new YoBoolean("useRecoveryMomentumWeight", this.registry);
        this.useRecoveryMomentumWeight.set(false);
        this.desiredLinearMomentumRateWeight = new RateLimitedYoFrameVector("desiredLinearMomentumRateWeight", "", this.registry, (DoubleProvider)this.maxMomentumRateWeightChangeRate, controlDT, worldFrame);
        this.centerOfMassFrame = referenceFrames.getCenterOfMassFrame();
        this.midFootZUpFrame = referenceFrames.getMidFootZUpGroundFrame();
        this.centerOfMass = new FramePoint3D(this.centerOfMassFrame);
        this.controlledCoMAcceleration = new YoFrameVector3D("ControlledCoMAcceleration", "", this.centerOfMassFrame, this.registry);
        this.desiredCoPInMidFeet = new FramePoint2D(this.midFootZUpFrame);
        this.capturePointCalculator = new CapturePointCalculator(this.centerOfMassFrame, elevator);
        this.pelvisHeightController = new PelvisHeightController(referenceFrames.getPelvisFrame(), (ReferenceFrame)elevator.getBodyFixedFrame(), this.registry);
        this.comHeightController = new CoMHeightController(this.capturePointCalculator.getCenterOfMassJacobian(), this.registry);
        DoubleProvider capturePointVelocityAlpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)this.capturePointVelocityBreakFrequency.getValue(), (double)controlDT);
        this.capturePointVelocity = new FilteredVelocityYoFrameVector2d("capturePointVelocity", "", capturePointVelocityAlpha, controlDT, this.registry, worldFrame);
        if (yoGraphicsListRegistry != null) {
            YoGraphicPosition desiredCMPViz = new YoGraphicPosition("Desired CMP", this.yoDesiredCMP, 0.012, YoAppearance.Purple(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition achievedCMPViz = new YoGraphicPosition("Achieved CMP", this.yoAchievedCMP, 0.005, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition centerOfMassViz = new YoGraphicPosition("Center Of Mass", this.yoCenterOfMass, 0.006, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition capturePointViz = new YoGraphicPosition("Capture Point", this.yoCapturePoint, 0.01, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)desiredCMPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)achievedCMPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)centerOfMassViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)capturePointViz.createArtifact());
        }
        this.yoDesiredCMP.setToNaN();
        this.yoAchievedCMP.setToNaN();
        this.yoCenterOfMass.setToNaN();
        this.yoCapturePoint.setToNaN();
        this.icpControlPlane = new ICPControlPlane(this.centerOfMassFrame, gravityZ, this.registry);
        this.icpControlPolygons = new ICPControlPolygons(this.icpControlPlane, this.registry, yoGraphicsListRegistry);
        this.bipedSupportPolygons = new BipedSupportPolygons(referenceFrames, this.registry, null);
        this.icpController = new ICPController(walkingControllerParameters, this.bipedSupportPolygons, this.icpControlPolygons, contactableFeet, controlDT, this.registry, yoGraphicsListRegistry);
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.desiredLinearMomentumRateWeight.set((Tuple3DReadOnly)this.linearMomentumRateWeight);
        this.capturePointVelocity.reset();
        this.yoDesiredCMP.setToNaN();
        this.yoAchievedCMP.setToNaN();
        this.yoCenterOfMass.setToNaN();
        this.yoCapturePoint.setToNaN();
    }

    public void setInputFromWalkingStateMachine(LinearMomentumRateControlModuleInput input) {
        this.omega0 = input.getOmega0();
        this.heightControlCommand = input.getUsePelvisHeightCommand() ? input.getPelvisHeightControlCommand() : input.getCenterOfMassHeightControlCommand();
        this.useRecoveryMomentumWeight.set(input.getUseMomentumRecoveryMode());
        this.desiredCapturePoint.setMatchingFrame((FrameTuple2DReadOnly)input.getDesiredCapturePoint());
        this.desiredCapturePointVelocity.setMatchingFrame((FrameTuple2DReadOnly)input.getDesiredCapturePointVelocity());
        this.minimizingAngularMomentumRateZ.set(input.getMinimizeAngularMomentumRateZ());
        this.perfectCMP.setMatchingFrame((FrameTuple2DReadOnly)input.getPerfectCMP());
        this.perfectCoP.setMatchingFrame((FrameTuple2DReadOnly)input.getPerfectCoP());
        this.controlHeightWithMomentum = input.getControlHeightWithMomentum();
        this.initializeOnStateChange = input.getInitializeOnStateChange();
        this.keepCoPInsideSupportPolygon = input.getKeepCoPInsideSupportPolygon();
        for (RobotSide robotSide : RobotSide.values) {
            ((PlaneContactStateCommand)this.contactStateCommands.get((Enum)robotSide)).set((PlaneContactStateCommand)input.getContactStateCommands().get((Enum)robotSide));
        }
    }

    public void setInputFromControllerCore(ControllerCoreOutput controllerCoreOutput) {
        controllerCoreOutput.getLinearMomentumRate((FrameVector3DBasics)this.achievedLinearMomentumRate);
    }

    public LinearMomentumRateControlModuleOutput getOutputForWalkingStateMachine() {
        return this.output;
    }

    public MomentumRateCommand getMomentumRateCommand() {
        return this.momentumRateCommand;
    }

    public CenterOfPressureCommand getCenterOfPressureCommand() {
        return this.centerOfPressureCommand;
    }

    public boolean computeControllerCoreCommands() {
        this.capturePointCalculator.compute((FramePoint2DBasics)this.capturePoint, this.omega0);
        this.capturePointVelocity.update((FrameTuple2DReadOnly)this.capturePoint);
        boolean success = LinearMomentumRateControlModule.checkInputs((FramePoint2DReadOnly)this.capturePoint, this.desiredCapturePoint, this.desiredCapturePointVelocity, this.perfectCoP, this.perfectCMP);
        this.updatePolygons();
        this.updateHeightController();
        this.updateICPControllerState();
        this.computeICPController();
        this.checkAndPackOutputs();
        if (this.allowMomentumRecoveryWeight.getValue() && this.useRecoveryMomentumWeight.getBooleanValue()) {
            this.desiredLinearMomentumRateWeight.update((Tuple3DReadOnly)this.recoveryLinearMomentumRateWeight);
        } else {
            this.desiredLinearMomentumRateWeight.update((Tuple3DReadOnly)this.linearMomentumRateWeight);
        }
        this.yoDesiredCMP.set((FrameTuple2DReadOnly)this.desiredCMP);
        this.yoCenterOfMass.setFromReferenceFrame(this.centerOfMassFrame);
        this.yoCapturePoint.set((FrameTuple2DReadOnly)this.capturePoint);
        success = success && this.computeDesiredLinearMomentumRateOfChange();
        this.selectionMatrix.setToLinearSelectionOnly();
        this.selectionMatrix.selectLinearZ(this.controlHeightWithMomentum);
        this.selectionMatrix.selectAngularZ(this.minimizingAngularMomentumRateZ.getValue());
        this.momentumRateCommand.setLinearMomentumRate(this.linearMomentumRateOfChange);
        this.momentumRateCommand.setSelectionMatrix(this.selectionMatrix);
        this.momentumRateCommand.setWeights((Tuple3DReadOnly)this.angularMomentumRateWeight, (Tuple3DReadOnly)this.desiredLinearMomentumRateWeight);
        this.desiredCoPInMidFeet.setMatchingFrame((FrameTuple2DReadOnly)this.desiredCoP);
        this.centerOfPressureCommand.setDesiredCoP((FramePoint2DReadOnly)this.desiredCoP);
        this.centerOfPressureCommand.setWeight(this.midFootZUpFrame, this.centerOfPressureWeight.getValue(), this.centerOfPressureWeight.getValue());
        return success;
    }

    public void computeAchievedCMP() {
        if (this.achievedLinearMomentumRate.containsNaN()) {
            this.yoAchievedCMP.setToNaN();
            return;
        }
        this.centerOfMass2d.setToZero(this.centerOfMassFrame);
        this.centerOfMass2d.changeFrame(worldFrame);
        this.achievedCoMAcceleration2d.setIncludingFrame((FrameTuple3DReadOnly)this.achievedLinearMomentumRate);
        this.achievedCoMAcceleration2d.scale(1.0 / this.totalMass);
        this.achievedCoMAcceleration2d.changeFrame(worldFrame);
        this.achievedCMP.set((FrameTuple2DReadOnly)this.achievedCoMAcceleration2d);
        this.achievedCMP.scale(-1.0 / (this.omega0 * this.omega0));
        this.achievedCMP.add((FrameTuple2DReadOnly)this.centerOfMass2d);
        this.yoAchievedCMP.set((FrameTuple2DReadOnly)this.achievedCMP);
    }

    private void updatePolygons() {
        this.icpControlPlane.setOmega0(this.omega0);
        this.icpControlPolygons.updateUsingContactStateCommand(this.contactStateCommands);
        this.bipedSupportPolygons.updateUsingContactStateCommand(this.contactStateCommands);
    }

    private void updateHeightController() {
        if (this.heightControlCommand == null) {
            return;
        }
        switch (this.heightControlCommand.getCommandType()) {
            case POINT: {
                this.desiredCoMHeightAcceleration = LinearMomentumRateControlModule.handleHeightControlCommand((PointFeedbackControlCommand)this.heightControlCommand, this.pelvisHeightController);
                break;
            }
            case MOMENTUM: {
                this.desiredCoMHeightAcceleration = LinearMomentumRateControlModule.handleHeightControlCommand((CenterOfMassFeedbackControlCommand)this.heightControlCommand, this.comHeightController);
                break;
            }
            default: {
                throw new IllegalArgumentException("This command type has not been set up for height control.");
            }
        }
    }

    private static <T extends FeedbackControlCommand<T>> double handleHeightControlCommand(T command, HeightController<T> controller) {
        controller.compute(command);
        return controller.getHeightAcceleration();
    }

    private void updateICPControllerState() {
        if (this.initializeOnStateChange) {
            this.icpController.initialize();
        }
        this.icpController.setKeepCoPInsideSupportPolygon(this.keepCoPInsideSupportPolygon);
    }

    private void computeICPController() {
        if (this.perfectCoP.containsNaN()) {
            this.perfectCMPDelta.setToZero();
            this.icpController.compute((FramePoint2DReadOnly)this.desiredCapturePoint, (FrameVector2DReadOnly)this.desiredCapturePointVelocity, (FramePoint2DReadOnly)this.perfectCMP, (FramePoint2DReadOnly)this.capturePoint, (FramePoint2DReadOnly)this.centerOfMass2d, this.omega0);
        } else {
            this.perfectCMPDelta.sub((FrameTuple2DReadOnly)this.perfectCMP, (FrameTuple2DReadOnly)this.perfectCoP);
            this.icpController.compute((FramePoint2DReadOnly)this.desiredCapturePoint, (FrameVector2DReadOnly)this.desiredCapturePointVelocity, (FramePoint2DReadOnly)this.perfectCoP, (FrameVector2DReadOnly)this.perfectCMPDelta, (FramePoint2DReadOnly)this.capturePoint, (FramePoint2DReadOnly)this.centerOfMass2d, this.omega0);
        }
        this.icpController.getDesiredCMP(this.desiredCMP);
        this.icpController.getDesiredCoP(this.desiredCoP);
    }

    private void checkAndPackOutputs() {
        if (this.desiredCMP.containsNaN()) {
            if (!this.desiredCMPcontainedNaN) {
                LogTools.error((String)"Desired CMP contains NaN, setting it to the ICP - only showing this error once");
            }
            this.desiredCMP.set((FrameTuple2DReadOnly)this.capturePoint);
            this.desiredCMPcontainedNaN = true;
        } else {
            this.desiredCMPcontainedNaN = false;
        }
        if (this.desiredCoP.containsNaN()) {
            if (!this.desiredCoPcontainedNaN) {
                LogTools.error((String)"Desired CoP contains NaN, setting it to the desiredCMP - only showing this error once");
            }
            this.desiredCoP.set((FrameTuple2DReadOnly)this.desiredCMP);
            this.desiredCoPcontainedNaN = true;
        } else {
            this.desiredCoPcontainedNaN = false;
        }
        this.output.setDesiredCMP((FramePoint2DReadOnly)this.desiredCMP);
        this.output.setResidualICPErrorForStepAdjustment(this.icpController.getResidualError());
    }

    private boolean computeDesiredLinearMomentumRateOfChange() {
        boolean success = true;
        double fZ = WrenchDistributorTools.computeFz(this.totalMass, this.gravityZ, this.desiredCoMHeightAcceleration);
        this.centerOfMass.setToZero(this.centerOfMassFrame);
        WrenchDistributorTools.computePseudoCMP3d((FramePoint3DBasics)this.cmp3d, (FramePoint3DReadOnly)this.centerOfMass, (FramePoint2DReadOnly)this.desiredCMP, fZ, this.totalMass, this.omega0);
        WrenchDistributorTools.computeForce(this.linearMomentumRateOfChange, (FramePoint3DReadOnly)this.centerOfMass, (FramePoint3DBasics)this.cmp3d, fZ);
        this.linearMomentumRateOfChange.checkReferenceFrameMatch(this.centerOfMassFrame);
        this.linearMomentumRateOfChange.setZ(this.linearMomentumRateOfChange.getZ() - this.totalMass * this.gravityZ);
        if (this.linearMomentumRateOfChange.containsNaN()) {
            LogTools.error((String)"Desired LinearMomentumRateOfChange contained NaN, setting it to zero and failing.");
            this.linearMomentumRateOfChange.setToZero();
            success = false;
        }
        this.controlledCoMAcceleration.set((FrameTuple3DReadOnly)this.linearMomentumRateOfChange);
        this.controlledCoMAcceleration.scale(1.0 / this.totalMass);
        this.linearMomentumRateOfChange.changeFrame(worldFrame);
        return success;
    }

    private static boolean checkInputs(FramePoint2DReadOnly capturePoint, FixedFramePoint2DBasics desiredCapturePoint, FixedFrameVector2DBasics desiredCapturePointVelocity, FixedFramePoint2DBasics perfectCoP, FixedFramePoint2DBasics perfectCMP) {
        boolean inputsAreOk = true;
        if (desiredCapturePoint.containsNaN()) {
            LogTools.error((String)"Desired ICP contains NaN, setting it to the current ICP and failing.");
            desiredCapturePoint.set((FrameTuple2DReadOnly)capturePoint);
            inputsAreOk = false;
        }
        if (desiredCapturePointVelocity.containsNaN()) {
            LogTools.error((String)"Desired ICP Velocity contains NaN, setting it to zero and failing.");
            desiredCapturePointVelocity.setToZero();
            inputsAreOk = false;
        }
        if (perfectCoP.containsNaN()) {
            LogTools.error((String)"Perfect CoP contains NaN, setting it to the current ICP and failing.");
            perfectCoP.set((FrameTuple2DReadOnly)capturePoint);
            inputsAreOk = false;
        }
        if (perfectCMP.containsNaN()) {
            LogTools.error((String)"Perfect CMP contains NaN, setting it to the current ICP and failing.");
            perfectCMP.set((FrameTuple2DReadOnly)capturePoint);
            inputsAreOk = false;
        }
        return inputsAreOk;
    }
}

