/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;

public class JumpingMomentumRateControlModuleInput {
    private double omega0;
    private double timeInState;
    private double timeAtStartOfSignal;
    private boolean minimizeAngularMomentumRate;
    private boolean inFlight;
    private final RecyclingArrayList<Polynomial3DBasics> vrpTrajectories = new RecyclingArrayList(() -> new Polynomial3D(6));
    private final RecyclingArrayList<SettableContactStateProvider> contactStateProviders = new RecyclingArrayList(SettableContactStateProvider::new);
    private final FrameVector3D desiredLinearMomentumRateOfChange = new FrameVector3D();
    private final FrameVector3D desiredAngularMomentumRateOfChange = new FrameVector3D();

    public void setOmega0(double omega0) {
        this.omega0 = omega0;
    }

    public double getOmega0() {
        return this.omega0;
    }

    public void setTimeInState(double timeInState) {
        this.timeInState = timeInState;
    }

    public double getTimeInState() {
        return this.timeInState;
    }

    public void setMinimizeAngularMomentumRate(boolean minimizeAngularMomentumRate) {
        this.minimizeAngularMomentumRate = minimizeAngularMomentumRate;
    }

    public boolean getMinimizeAngularMomentumRate() {
        return this.minimizeAngularMomentumRate;
    }

    public void setInFlight(boolean inFlight) {
        this.inFlight = inFlight;
    }

    public boolean getInFlight() {
        return this.inFlight;
    }

    public void setDesiredLinearMomentumRateOfChange(FrameVector3DReadOnly desiredLinearMomentumRateOfChange) {
        this.desiredLinearMomentumRateOfChange.set((FrameTuple3DReadOnly)desiredLinearMomentumRateOfChange);
    }

    public FrameVector3DReadOnly getDesiredLinearMomentumRateOfChange() {
        return this.desiredLinearMomentumRateOfChange;
    }

    public void setDesiredAngularMomentumRateOfChange(FrameVector3DReadOnly desiredAngularMomentumRateOfChange) {
        this.desiredAngularMomentumRateOfChange.set((FrameTuple3DReadOnly)desiredAngularMomentumRateOfChange);
    }

    public FrameVector3DReadOnly getDesiredAngularMomentumRateOfChange() {
        return this.desiredAngularMomentumRateOfChange;
    }

    public void setVrpTrajectories(List<? extends Polynomial3DReadOnly> vrpTrajectories) {
        this.vrpTrajectories.clear();
        for (int i = 0; i < vrpTrajectories.size(); ++i) {
            ((Polynomial3DBasics)this.vrpTrajectories.add()).set(vrpTrajectories.get(i));
        }
    }

    public List<? extends Polynomial3DReadOnly> getVrpTrajectories() {
        return this.vrpTrajectories;
    }

    public void setContactStateProviders(List<? extends ContactStateProvider> contactStateProviders) {
        this.contactStateProviders.clear();
        for (int i = 0; i < contactStateProviders.size(); ++i) {
            ((SettableContactStateProvider)this.contactStateProviders.add()).set(contactStateProviders.get(i));
        }
    }

    public List<? extends ContactStateProvider> getContactStateProviders() {
        return this.contactStateProviders;
    }

    public void set(JumpingMomentumRateControlModuleInput other) {
        this.omega0 = other.omega0;
        this.timeInState = other.timeInState;
        this.inFlight = other.inFlight;
        this.setVrpTrajectories((List<? extends Polynomial3DReadOnly>)other.vrpTrajectories);
        this.setContactStateProviders((List<? extends ContactStateProvider>)other.contactStateProviders);
        this.minimizeAngularMomentumRate = other.minimizeAngularMomentumRate;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JumpingMomentumRateControlModuleInput) {
            int i;
            JumpingMomentumRateControlModuleInput other = (JumpingMomentumRateControlModuleInput)obj;
            if (Double.compare(this.omega0, other.omega0) != 0) {
                return false;
            }
            if (Double.compare(this.timeInState, other.timeInState) != 0) {
                return false;
            }
            if (this.minimizeAngularMomentumRate != other.minimizeAngularMomentumRate) {
                return false;
            }
            if (this.inFlight != other.inFlight) {
                return false;
            }
            if (this.vrpTrajectories.size() != other.vrpTrajectories.size()) {
                return false;
            }
            for (i = 0; i < this.vrpTrajectories.size(); ++i) {
                if (((Polynomial3DBasics)this.vrpTrajectories.get(i)).equals(other.vrpTrajectories.get(i))) continue;
                return false;
            }
            if (this.contactStateProviders.size() != other.contactStateProviders.size()) {
                return false;
            }
            for (i = 0; i < this.contactStateProviders.size(); ++i) {
                if (((SettableContactStateProvider)this.contactStateProviders.get(i)).equals(other.contactStateProviders.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

