/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.capturePoint.JumpingMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.capturePoint.lqrControl.LQRJumpMomentumController;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.LinearMomentumRateCostCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalLQRController;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class JumpingMomentumRateControlModule {
    private static final boolean useLinearLQR = true;
    private static final boolean useAngularLQR = false;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final Vector3DReadOnly linearMomentumRateWeight;
    private final Vector3DReadOnly angularMomentumRateWeight;
    private final YoFrameVector3D controlledCoMAcceleration;
    private final InverseDynamicsCommandList inverseDynamicsCommandList = new InverseDynamicsCommandList();
    private final MomentumRateCommand momentumRateCommand = new MomentumRateCommand();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private boolean inFlight = false;
    private double omega0 = 3.0;
    private double totalMass;
    private double timeInContactPhase;
    private List<? extends Polynomial3DReadOnly> vrpTrajectories;
    private List<? extends ContactStateProvider> contactStateProviders;
    private FrameVector3DReadOnly mpcLinearMomentumRateOfChange;
    private FrameVector3DReadOnly mpcAngularMomentumRateOfChange;
    private final ReferenceFrame centerOfMassFrame;
    private final FramePoint2D centerOfMass2d = new FramePoint2D();
    private final FixedFramePoint2DBasics achievedCMP = new FramePoint2D();
    private final FrameVector3D achievedLinearMomentumRate = new FrameVector3D();
    private final FrameVector2D achievedCoMAcceleration2d = new FrameVector2D();
    private final FrameVector3D linearMomentumRateOfChange = new FrameVector3D();
    private final FrameVector3D angularMomentumRateOfChange = new FrameVector3D();
    private final LQRJumpMomentumController lqrMomentumController;
    private final VariationalLQRController orientationController;
    private final YoFramePoint2D yoAchievedCMP = new YoFramePoint2D("achievedCMP", worldFrame, this.registry);
    private final YoFramePoint3D yoDesiredVRP = new YoFramePoint3D("desiredVRP", worldFrame, this.registry);
    private final YoFramePoint3D yoCenterOfMass = new YoFramePoint3D("centerOfMass", worldFrame, this.registry);
    private final YoFrameVector3D yoCenterOfMassVelocity = new YoFrameVector3D("centerOfMassVelocity", worldFrame, this.registry);
    private final YoBoolean minimizeAngularMomentumRate = new YoBoolean("minimizeAngularMomentumRate", this.registry);
    private final JumpingControllerToolbox controllerToolbox;
    private final DMatrixRMaj currentState = new DMatrixRMaj(6, 1);
    private final FramePose3D centerOfMass = new FramePose3D();

    public JumpingMomentumRateControlModule(JumpingControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        this.totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)controllerToolbox.getFullRobotModel().getElevator());
        this.controllerToolbox = controllerToolbox;
        MomentumOptimizationSettings momentumOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        this.linearMomentumRateWeight = new ParameterVector3D("LinearMomentumRateWeight1", (Tuple3DReadOnly)new Vector3D(10.0, 10.0, 10.0), this.registry);
        this.angularMomentumRateWeight = new ParameterVector3D("AngularMomentumRateWeight1", (Tuple3DReadOnly)new Vector3D(0.001, 0.001, 0.0), this.registry);
        this.minimizeAngularMomentumRate.set(true);
        this.centerOfMassFrame = controllerToolbox.getCenterOfMassFrame();
        this.controlledCoMAcceleration = new YoFrameVector3D("ControlledCoMAcceleration", worldFrame, this.registry);
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        if (yoGraphicsListRegistry != null) {
            YoGraphicPosition achievedCMPViz = new YoGraphicPosition("Achieved CMP", this.yoAchievedCMP, 0.005, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition desiredVRPViz = new YoGraphicPosition("Desired VRP", this.yoDesiredVRP, 0.012, YoAppearance.Purple(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition centerOfMassViz = new YoGraphicPosition("Center Of Mass", this.yoCenterOfMass, 0.01, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition dcmViz = new YoGraphicPosition("DCM", controllerToolbox.getYoCapturePoint(), 0.01, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)desiredVRPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)achievedCMPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)centerOfMassViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact("LinearMomentum", (Artifact)dcmViz.createArtifact());
        }
        this.yoAchievedCMP.setToNaN();
        this.yoCenterOfMass.setToNaN();
        this.lqrMomentumController = new LQRJumpMomentumController((DoubleProvider)controllerToolbox.getOmega0Provider(), this.totalMass, this.registry);
        this.orientationController = new VariationalLQRController();
        this.orientationController.setInertia((SpatialInertiaReadOnly)controllerToolbox.getFullRobotModel().getChest().getInertia());
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.yoAchievedCMP.setToNaN();
        this.yoCenterOfMass.setToNaN();
    }

    public void setInputFromWalkingStateMachine(JumpingMomentumRateControlModuleInput input) {
        this.inFlight = input.getInFlight();
        this.omega0 = input.getOmega0();
        this.timeInContactPhase = input.getTimeInState();
        this.vrpTrajectories = input.getVrpTrajectories();
        this.contactStateProviders = input.getContactStateProviders();
        this.mpcLinearMomentumRateOfChange = input.getDesiredLinearMomentumRateOfChange();
        this.mpcAngularMomentumRateOfChange = input.getDesiredAngularMomentumRateOfChange();
    }

    public void setInputFromControllerCore(ControllerCoreOutput controllerCoreOutput) {
        controllerCoreOutput.getLinearMomentumRate((FrameVector3DBasics)this.achievedLinearMomentumRate);
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        this.inverseDynamicsCommandList.clear();
        this.inverseDynamicsCommandList.addCommand(this.momentumRateCommand);
        return this.inverseDynamicsCommandList;
    }

    public void computeControllerCoreCommands() {
        this.yoCenterOfMass.set((FrameTuple3DReadOnly)this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMass());
        this.yoCenterOfMassVelocity.set((FrameTuple3DReadOnly)this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMassVelocity());
        this.yoCenterOfMass.get((DMatrix)this.currentState);
        this.yoCenterOfMassVelocity.get(3, (DMatrix)this.currentState);
        this.computeDesiredLinearMomentumRateOfChange();
        this.computeDesiredAngularMomentumRateOfChange();
        this.selectionMatrix.resetSelection();
        if (!this.minimizeAngularMomentumRate.getBooleanValue()) {
            this.selectionMatrix.clearAngularSelection();
        }
        this.momentumRateCommand.setMomentumRate(this.angularMomentumRateOfChange, this.linearMomentumRateOfChange);
        this.momentumRateCommand.setSelectionMatrix(this.selectionMatrix);
        this.momentumRateCommand.setWeights((Tuple3DReadOnly)this.angularMomentumRateWeight, (Tuple3DReadOnly)this.linearMomentumRateWeight);
        LinearMomentumRateCostCommand momentumRateCostCommand = this.lqrMomentumController.getMomentumRateCostCommand();
        momentumRateCostCommand.setSelectionMatrixToIdentity();
        momentumRateCostCommand.setWeights((Tuple3DReadOnly)this.linearMomentumRateWeight);
    }

    public void computeAchievedCMP() {
        if (this.achievedLinearMomentumRate.containsNaN()) {
            this.yoAchievedCMP.setToNaN();
            return;
        }
        this.centerOfMass2d.setToZero(this.centerOfMassFrame);
        this.centerOfMass2d.changeFrame(worldFrame);
        this.achievedCoMAcceleration2d.setIncludingFrame((FrameTuple3DReadOnly)this.achievedLinearMomentumRate);
        this.achievedCoMAcceleration2d.scale(1.0 / this.totalMass);
        this.achievedCoMAcceleration2d.changeFrame(worldFrame);
        this.achievedCMP.set((FrameTuple2DReadOnly)this.achievedCoMAcceleration2d);
        this.achievedCMP.scale(-1.0 / (this.omega0 * this.omega0));
        this.achievedCMP.add((FrameTuple2DReadOnly)this.centerOfMass2d);
        this.yoAchievedCMP.set((FrameTuple2DReadOnly)this.achievedCMP);
    }

    private void computeDesiredLinearMomentumRateOfChange() {
        this.lqrMomentumController.setVRPTrajectory(this.vrpTrajectories, this.contactStateProviders);
        this.lqrMomentumController.computeControlInput(this.currentState, 0.0);
        if (this.inFlight) {
            this.linearMomentumRateOfChange.setIncludingFrame(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -this.controllerToolbox.getGravityZ());
        } else {
            this.linearMomentumRateOfChange.setIncludingFrame(ReferenceFrame.getWorldFrame(), (DMatrix)this.lqrMomentumController.getU());
        }
        this.controlledCoMAcceleration.setMatchingFrame((FrameTuple3DReadOnly)this.linearMomentumRateOfChange);
        this.linearMomentumRateOfChange.changeFrame(worldFrame);
        this.linearMomentumRateOfChange.scale(this.totalMass);
        this.yoDesiredVRP.set((FrameTuple3DReadOnly)this.lqrMomentumController.getFeedbackVRPPosition());
    }

    private void computeDesiredAngularMomentumRateOfChange() {
        this.angularMomentumRateOfChange.set((FrameTuple3DReadOnly)this.mpcAngularMomentumRateOfChange);
    }
}

