/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.capturePoint.JumpingMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.AngularMomentumHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.StandingCoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.MPCParameters;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.SE3ModelPredictiveController;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.customPolicies.CustomCoMPositionPolicy;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.MPCCornerPointViewer;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameWrench;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingBalanceManager {
    private static final double nominalHeight = 1.0;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final BipedSupportPolygons bipedSupportPolygons;
    private final JumpingMomentumRateControlModuleInput jumpingMomentumRateControlModuleInput = new JumpingMomentumRateControlModuleInput();
    private final JumpingControllerToolbox controllerToolbox;
    private final YoDouble desiredWeightForStateChangeHeights = new YoDouble("desiredWeightForStateChangeHeights", this.registry);
    private final YoFramePoint3D yoDesiredDCM = new YoFramePoint3D("desiredDCM", worldFrame, this.registry);
    private final YoFrameVector3D yoDesiredDCMVelocity = new YoFrameVector3D("desiredDCMVelocity", worldFrame, this.registry);
    private final YoFramePoint3D yoDesiredCoMPosition = new YoFramePoint3D("desiredCoMPosition", worldFrame, this.registry);
    private final YoFrameVector3D yoDesiredCoMVelocity = new YoFrameVector3D("desiredCoMVelocity", worldFrame, this.registry);
    private final YoFrameVector3D yoDesiredCoMAcceleration = new YoFrameVector3D("desiredCoMAcceleration", worldFrame, this.registry);
    private final YoFrameQuaternion yoDesiredBodyOrientation = new YoFrameQuaternion("desiredBodyOrientation", worldFrame, this.registry);
    private final YoFrameYawPitchRoll yoDesiredBodyYawPitchRoll = new YoFrameYawPitchRoll("desiredBodyOrientation", worldFrame, this.registry);
    private final YoFrameVector3D yoDesiredBodyAngularVelocity = new YoFrameVector3D("desiredBodyAngularVelocity", worldFrame, this.registry);
    private final YoFrameVector3D yoDesiredBodyAngularAcceleration = new YoFrameVector3D("desiredBodyAngularAcceleration", worldFrame, this.registry);
    private final YoFramePoint3D touchdownCoMPosition = new YoFramePoint3D("touchdownCoMPosition", worldFrame, this.registry);
    private final YoFramePoint3D touchdownDCMPosition = new YoFramePoint3D("touchdownDCMPosition", worldFrame, this.registry);
    private final YoFramePoint3D yoPerfectVRP = new YoFramePoint3D("perfectVRP", worldFrame, this.registry);
    private final YoFixedFrameWrench desiredWrench;
    private final YoFrameVector3D desiredTorque = new YoFrameVector3D("desiredCoMTorque", worldFrame, this.registry);
    private final FrameVector3D desiredLinearMomentumRate = new FrameVector3D();
    private final FrameVector3D desiredAngularMomentumRate = new FrameVector3D();
    private final YoBoolean comPlannerDone = new YoBoolean("ICPPlannerDone", this.registry);
    private final ExecutionTimer plannerTimer = new ExecutionTimer("icpPlannerTimer", this.registry);
    private final SideDependentList<? extends ReferenceFrame> soleFrames;
    private final MovingReferenceFrame chestFrame;
    private final YoBoolean minimizeAngularMomentumRate = new YoBoolean("minimizeAngularMomentumRate", this.registry);
    private final YoDouble yoTime;
    private final YoDouble currentStateDuration = new YoDouble("CurrentStateDuration", this.registry);
    private final YoDouble totalStateDuration = new YoDouble("totalStateDuration", this.registry);
    private final YoDouble startTimeForSupportSequence = new YoDouble("startTimeForSupportSequence", this.registry);
    private final YoDouble timeInSupportSequence = new YoDouble("TimeInSupportSequence", this.registry);
    private final JumpingCoPTrajectoryGeneratorState copTrajectoryState;
    private final StandingCoPTrajectoryGenerator copTrajectoryForStanding;
    private final JumpingCoPTrajectoryGenerator copTrajectoryForJumping;
    private final BooleanProvider useAngularMomentumOffset = new BooleanParameter("useAngularMomentumOffset", this.registry, true);
    private final BooleanProvider useAngularMomentumOffsetInStanding = new BooleanParameter("useAngularMomentumOffsetInStanding", this.registry, true);
    private final YoBoolean computeAngularMomentumOffset = new YoBoolean("computeAngularMomentumOffset", this.registry);
    private final AngularMomentumHandler<ContactPlaneProvider> angularMomentumHandler;
    private final SE3ModelPredictiveController comTrajectoryPlanner;
    private final CustomCoMPositionPolicy takeoffPolicy = new CustomCoMPositionPolicy();
    private final CustomCoMPositionPolicy touchdownPolicy = new CustomCoMPositionPolicy();
    private final FramePose3D chestPose = new FramePose3D();
    private final FramePoint3D tempPoint = new FramePoint3D();

    public JumpingBalanceManager(JumpingControllerToolbox controllerToolbox, CoPTrajectoryParameters copTrajectoryParameters, JumpingCoPTrajectoryParameters jumpingCoPTrajectoryParameters, JumpingParameters jumpingParameters, YoRegistry parentRegistry) {
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        this.desiredWeightForStateChangeHeights.set(0.01);
        this.yoTime = controllerToolbox.getYoTime();
        this.controllerToolbox = controllerToolbox;
        this.bipedSupportPolygons = controllerToolbox.getBipedSupportPolygons();
        RigidBodyBasics chest = controllerToolbox.getFullRobotModel().getChest();
        this.chestFrame = chest.getBodyFixedFrame();
        this.soleFrames = controllerToolbox.getReferenceFrames().getSoleFrames();
        this.registry.addChild(copTrajectoryParameters.getRegistry());
        double totalMass = controllerToolbox.getFullRobotModel().getTotalMass();
        double gravityZ = controllerToolbox.getGravityZ();
        this.angularMomentumHandler = new AngularMomentumHandler<ContactPlaneProvider>(totalMass, gravityZ, controllerToolbox.getCenterOfMassJacobian(), (SideDependentList<MovingReferenceFrame>)controllerToolbox.getReferenceFrames().getSoleFrames(), ContactPlaneProvider::new, this.registry, yoGraphicsListRegistry);
        MPCParameters mpcParameters = new MPCParameters(this.registry);
        this.comTrajectoryPlanner = new SE3ModelPredictiveController(chest.getInertia().getMomentOfInertia(), mpcParameters, gravityZ, 1.0, totalMass, controllerToolbox.getControlDT(), this.registry);
        this.copTrajectoryState = new JumpingCoPTrajectoryGeneratorState(this.registry);
        this.copTrajectoryState.registerStateToSave(copTrajectoryParameters);
        this.copTrajectoryState.registerStateToSave(jumpingCoPTrajectoryParameters);
        this.copTrajectoryForStanding = new StandingCoPTrajectoryGenerator(copTrajectoryParameters, this.registry);
        this.copTrajectoryForStanding.registerState(this.copTrajectoryState);
        this.copTrajectoryForJumping = new JumpingCoPTrajectoryGenerator(copTrajectoryParameters, controllerToolbox.getDefaultFootPolygon(), jumpingCoPTrajectoryParameters, jumpingParameters, this.registry);
        this.copTrajectoryForJumping.registerState(this.copTrajectoryState);
        this.minimizeAngularMomentumRate.set(true);
        MovingReferenceFrame comFrame = controllerToolbox.getCenterOfMassFrame();
        this.desiredWrench = new YoFixedFrameWrench("DesiredCoMWrench", worldFrame, (ReferenceFrame)comFrame, this.registry);
        this.takeoffPolicy.getSelectionMatrix().clearSelection();
        this.takeoffPolicy.getSelectionMatrix().selectZAxis(true);
        this.touchdownPolicy.getSelectionMatrix().clearSelection();
        this.touchdownPolicy.getSelectionMatrix().selectZAxis(true);
        String graphicListName = this.getClass().getSimpleName();
        if (yoGraphicsListRegistry != null) {
            this.comTrajectoryPlanner.setCornerPointViewer(new MPCCornerPointViewer(false, true, this.registry, yoGraphicsListRegistry));
            this.comTrajectoryPlanner.setupCoMTrajectoryViewer(yoGraphicsListRegistry);
            YoGraphicPosition desiredDCMViz = new YoGraphicPosition("Desired DCM", this.yoDesiredDCM, 0.01, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            YoGraphicPosition desiredCoMViz = new YoGraphicPosition("Desired CoM", this.yoDesiredCoMPosition, 0.01, YoAppearance.Red(), YoGraphicPosition.GraphicType.SOLID_BALL);
            YoGraphicPosition perfectVRPViz = new YoGraphicPosition("Perfect VRP", this.yoPerfectVRP, 0.0075, YoAppearance.BlueViolet(), YoGraphicPosition.GraphicType.SOLID_BALL);
            YoGraphicPosition desiredTouchdownCoMViz = new YoGraphicPosition("Touchdown CoM", this.touchdownCoMPosition, 0.01, YoAppearance.Black(), YoGraphicPosition.GraphicType.SOLID_BALL);
            YoGraphicPosition desiredTouchdownDCMViz = new YoGraphicPosition("Touchdown DCM", this.touchdownDCMPosition, 0.01, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.SOLID_BALL);
            yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)desiredDCMViz);
            yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)desiredCoMViz);
            yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)perfectVRPViz);
            yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)desiredTouchdownCoMViz);
            yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)desiredTouchdownDCMViz);
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)desiredDCMViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)desiredCoMViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)perfectVRPViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)desiredTouchdownCoMViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)desiredTouchdownDCMViz.createArtifact());
        }
        this.yoDesiredDCM.setToNaN();
        this.yoPerfectVRP.setToNaN();
        parentRegistry.addChild(this.registry);
    }

    public void clearICPPlan() {
        this.copTrajectoryState.clear();
    }

    public void setDesiredCoMHeight(double height) {
        this.comTrajectoryPlanner.setNominalCoMHeight(height);
    }

    public void compute() {
        this.yoDesiredDCM.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredDCMPosition());
        this.yoDesiredDCMVelocity.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredDCMVelocity());
        this.yoPerfectVRP.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredVRPPosition());
        this.yoDesiredCoMPosition.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMPosition());
        this.yoDesiredCoMVelocity.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMVelocity());
        this.yoDesiredCoMAcceleration.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMAcceleration());
        this.yoDesiredBodyOrientation.set(this.comTrajectoryPlanner.getDesiredBodyOrientationSolution());
        this.yoDesiredBodyYawPitchRoll.set(this.comTrajectoryPlanner.getDesiredBodyOrientationSolution());
        this.yoDesiredBodyAngularVelocity.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredBodyAngularVelocitySolution());
        this.yoDesiredBodyAngularAcceleration.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredBodyAngularAccelerationSolution());
        double omega0 = this.controllerToolbox.getOmega0();
        if (Double.isNaN(omega0)) {
            throw new RuntimeException("omega0 is NaN");
        }
        CapturePointTools.computeCentroidalMomentumPivot((FramePoint3DReadOnly)this.yoDesiredDCM, (FrameVector3DReadOnly)this.yoDesiredDCMVelocity, omega0, (FixedFramePoint3DBasics)this.yoPerfectVRP);
        this.jumpingMomentumRateControlModuleInput.setOmega0(omega0);
        this.jumpingMomentumRateControlModuleInput.setTimeInState(0.0);
        this.jumpingMomentumRateControlModuleInput.setMinimizeAngularMomentumRate(this.minimizeAngularMomentumRate.getBooleanValue());
    }

    public void computeCoMPlanForStanding() {
        this.plannerTimer.startMeasurement();
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffsetInStanding.getValue() && this.useAngularMomentumOffset.getValue());
        this.touchdownCoMPosition.setToNaN();
        this.touchdownDCMPosition.setToNaN();
        for (RobotSide robotSide : RobotSide.values) {
            if (!this.controllerToolbox.getFootContactState(robotSide).inContact()) continue;
            this.copTrajectoryState.initializeStance(robotSide, (FrameConvexPolygon2DReadOnly)this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame().get((Enum)robotSide), (ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        }
        this.copTrajectoryForStanding.compute(this.copTrajectoryState);
        this.chestPose.setToZero((ReferenceFrame)this.chestFrame);
        this.chestPose.changeFrame(worldFrame);
        this.comTrajectoryPlanner.setCurrentState(this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMass(), this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMassVelocity(), (FrameOrientation3DReadOnly)this.chestPose.getOrientation(), this.chestFrame.getTwistOfFrame().getAngularPart(), this.timeInSupportSequence.getDoubleValue());
        this.comTrajectoryPlanner.solveForTrajectory((List<ContactPlaneProvider>)this.copTrajectoryForStanding.getContactStateProviders());
        this.comTrajectoryPlanner.compute(this.timeInSupportSequence.getDoubleValue());
        this.timeInSupportSequence.set(this.yoTime.getValue() - this.startTimeForSupportSequence.getDoubleValue());
        this.comPlannerDone.set(this.timeInSupportSequence.getValue() >= this.currentStateDuration.getValue());
        if (this.comTrajectoryPlanner.getContactStateProviders().size() != this.comTrajectoryPlanner.getVRPTrajectories().size()) {
            throw new IllegalArgumentException("What?");
        }
        this.jumpingMomentumRateControlModuleInput.setVrpTrajectories(this.comTrajectoryPlanner.getVRPTrajectories());
        this.jumpingMomentumRateControlModuleInput.setContactStateProviders(this.comTrajectoryPlanner.getContactStateProviders());
        this.desiredWrench.setMatchingFrame(this.comTrajectoryPlanner.getDesiredWrench());
        this.comTrajectoryPlanner.computeTorque(this.timeInSupportSequence.getDoubleValue(), (FixedFrameVector3DBasics)this.desiredTorque);
        this.desiredLinearMomentumRate.setMatchingFrame((FrameTuple3DReadOnly)this.desiredWrench.getLinearPart());
        this.desiredLinearMomentumRate.addZ(this.controllerToolbox.getFullRobotModel().getTotalMass() * -Math.abs(this.controllerToolbox.getGravityZ()));
        this.desiredAngularMomentumRate.setMatchingFrame((FrameTuple3DReadOnly)this.desiredWrench.getAngularPart());
        this.jumpingMomentumRateControlModuleInput.setDesiredLinearMomentumRateOfChange((FrameVector3DReadOnly)this.desiredLinearMomentumRate);
        this.jumpingMomentumRateControlModuleInput.setDesiredAngularMomentumRateOfChange((FrameVector3DReadOnly)this.desiredAngularMomentumRate);
        this.plannerTimer.stopMeasurement();
    }

    public void computeCoMPlanForJumping(JumpingGoal jumpingGoal) {
        this.plannerTimer.startMeasurement();
        this.copTrajectoryState.setJumpingGoal(jumpingGoal);
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffset.getValue());
        for (RobotSide robotSide : RobotSide.values) {
            if (!this.controllerToolbox.getFootContactState(robotSide).inContact()) continue;
            this.copTrajectoryState.initializeStance(robotSide, (FrameConvexPolygon2DReadOnly)this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame().get((Enum)robotSide), (ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        }
        this.copTrajectoryForJumping.compute(this.copTrajectoryState);
        MovingReferenceFrame chestFrame = this.controllerToolbox.getFullRobotModel().getChest().getBodyFixedFrame();
        this.chestPose.setToZero((ReferenceFrame)chestFrame);
        this.chestPose.changeFrame(worldFrame);
        this.comTrajectoryPlanner.setCurrentState(this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMass(), this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMassVelocity(), (FrameOrientation3DReadOnly)this.chestPose.getOrientation(), chestFrame.getTwistOfFrame().getAngularPart(), this.timeInSupportSequence.getDoubleValue());
        Object contactStateProviders = this.copTrajectoryForJumping.getContactStateProviders();
        if (this.computeAngularMomentumOffset.getValue()) {
            if (this.comTrajectoryPlanner.hasTrajectories()) {
                this.angularMomentumHandler.solveForAngularMomentumTrajectory(this.copTrajectoryState, (List<TimeIntervalProvider>)contactStateProviders, (MultipleSegmentPositionTrajectoryGenerator<?>)this.comTrajectoryPlanner.getCoMTrajectory());
                contactStateProviders = this.angularMomentumHandler.computeECMPTrajectory((List<ContactPlaneProvider>)contactStateProviders);
            } else {
                this.angularMomentumHandler.resetAngularMomentum();
            }
            this.angularMomentumHandler.computeAngularMomentum(this.timeInSupportSequence.getDoubleValue());
            this.comTrajectoryPlanner.setInternalAngularMomentumTrajectory(this.angularMomentumHandler.getAngularMomentumTrajectories());
        } else {
            this.comTrajectoryPlanner.reset();
        }
        this.tempPoint.setToZero((ReferenceFrame)this.controllerToolbox.getReferenceFrames().getMidFeetZUpFrame());
        this.tempPoint.changeFrame(worldFrame);
        this.takeoffPolicy.getDesiredComPosition().setZ(this.tempPoint.getZ() + this.controllerToolbox.getStandingHeight());
        this.touchdownPolicy.getDesiredComPosition().setZ(jumpingGoal.getGoalHeight() + this.controllerToolbox.getStandingHeight());
        this.takeoffPolicy.setPolicyWeight(this.desiredWeightForStateChangeHeights.getDoubleValue());
        this.touchdownPolicy.setPolicyWeight(this.desiredWeightForStateChangeHeights.getDoubleValue());
        this.takeoffPolicy.setTimeOfPolicy(jumpingGoal.getSupportDuration());
        this.touchdownPolicy.setTimeOfPolicy(jumpingGoal.getSupportDuration() + jumpingGoal.getFlightDuration());
        this.comTrajectoryPlanner.solveForTrajectory((List<ContactPlaneProvider>)contactStateProviders);
        this.comTrajectoryPlanner.compute(Math.max(this.totalStateDuration.getDoubleValue() - this.timeInSupportSequence.getDoubleValue(), 0.0));
        this.touchdownCoMPosition.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMPosition());
        this.touchdownDCMPosition.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredDCMPosition());
        this.comTrajectoryPlanner.compute(this.timeInSupportSequence.getDoubleValue());
        this.timeInSupportSequence.set(this.yoTime.getValue() - this.startTimeForSupportSequence.getDoubleValue());
        this.comPlannerDone.set(this.timeInSupportSequence.getValue() >= this.currentStateDuration.getValue());
        if (this.comTrajectoryPlanner.getContactStateProviders().size() != this.comTrajectoryPlanner.getVRPTrajectories().size()) {
            throw new IllegalArgumentException("What?");
        }
        this.jumpingMomentumRateControlModuleInput.setVrpTrajectories(this.comTrajectoryPlanner.getVRPTrajectories());
        this.jumpingMomentumRateControlModuleInput.setContactStateProviders(this.comTrajectoryPlanner.getContactStateProviders());
        this.desiredWrench.setMatchingFrame(this.comTrajectoryPlanner.getDesiredWrench());
        this.comTrajectoryPlanner.computeTorque(this.timeInSupportSequence.getDoubleValue(), (FixedFrameVector3DBasics)this.desiredTorque);
        this.desiredLinearMomentumRate.setMatchingFrame((FrameTuple3DReadOnly)this.desiredWrench.getLinearPart());
        this.desiredLinearMomentumRate.addZ(this.controllerToolbox.getFullRobotModel().getTotalMass() * -Math.abs(this.controllerToolbox.getGravityZ()));
        this.desiredAngularMomentumRate.setMatchingFrame((FrameTuple3DReadOnly)this.desiredWrench.getAngularPart());
        this.jumpingMomentumRateControlModuleInput.setDesiredLinearMomentumRateOfChange((FrameVector3DReadOnly)this.desiredLinearMomentumRate);
        this.jumpingMomentumRateControlModuleInput.setDesiredAngularMomentumRateOfChange((FrameVector3DReadOnly)this.desiredAngularMomentumRate);
        this.plannerTimer.stopMeasurement();
    }

    public FramePoint3DReadOnly getDesiredDCM() {
        return this.yoDesiredDCM;
    }

    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.yoDesiredDCMVelocity;
    }

    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.yoDesiredCoMVelocity;
    }

    public FramePoint3DReadOnly getTouchdownCoMPosition() {
        return this.touchdownCoMPosition;
    }

    public void initialize() {
        this.yoDesiredDCM.set((FrameTuple3DReadOnly)this.controllerToolbox.getCapturePoint());
        this.yoDesiredCoMPosition.setFromReferenceFrame((ReferenceFrame)this.controllerToolbox.getCenterOfMassFrame());
        this.yoDesiredCoMPosition.setZ(this.comTrajectoryPlanner.getNominalCoMHeight());
        this.yoDesiredCoMVelocity.setToZero();
        MovingReferenceFrame chestFrame = this.controllerToolbox.getFullRobotModel().getChest().getBodyFixedFrame();
        this.yoDesiredBodyOrientation.setFromReferenceFrame((ReferenceFrame)chestFrame);
        this.yoDesiredBodyAngularVelocity.setToZero();
        this.yoPerfectVRP.set((FrameTuple2DReadOnly)this.bipedSupportPolygons.getSupportPolygonInWorld().getCentroid());
        this.yoPerfectVRP.setZ(this.yoDesiredDCM.getZ());
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectVRP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.startTimeForSupportSequence.set(this.yoTime.getValue());
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(Double.NaN);
        this.totalStateDuration.set(Double.NaN);
    }

    public void setSwingFootTrajectory(RobotSide swingSide, MultipleWaypointsPoseTrajectoryGenerator swingTrajectory) {
        this.angularMomentumHandler.setSwingFootTrajectory(swingSide, swingTrajectory);
    }

    public void clearSwingFootTrajectory() {
        this.angularMomentumHandler.clearSwingFootTrajectory();
    }

    public void initializeCoMPlanForStanding() {
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectVRP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.startTimeForSupportSequence.set(this.yoTime.getValue());
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(Double.POSITIVE_INFINITY);
        this.totalStateDuration.set(Double.POSITIVE_INFINITY);
        this.jumpingMomentumRateControlModuleInput.setInFlight(false);
        this.comPlannerDone.set(false);
    }

    public void initializeCoMPlanForTransferToStanding() {
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectVRP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.startTimeForSupportSequence.set(this.yoTime.getValue());
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(this.copTrajectoryState.getFinalTransferDuration());
        this.totalStateDuration.set(this.copTrajectoryState.getFinalTransferDuration());
        this.jumpingMomentumRateControlModuleInput.setInFlight(false);
        this.comPlannerDone.set(false);
    }

    public void initializeCoMPlanForSupport(JumpingGoal jumpingGoal) {
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectVRP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.startTimeForSupportSequence.set(this.yoTime.getValue());
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(jumpingGoal.getSupportDuration() + jumpingGoal.getFlightDuration());
        this.totalStateDuration.set(jumpingGoal.getSupportDuration() + jumpingGoal.getFlightDuration());
        this.jumpingMomentumRateControlModuleInput.setInFlight(false);
        this.comPlannerDone.set(false);
    }

    public void initializeCoMPlanForFlight(JumpingGoal jumpingGoal) {
        this.currentStateDuration.set(jumpingGoal.getSupportDuration() + jumpingGoal.getFlightDuration());
        this.totalStateDuration.set(jumpingGoal.getSupportDuration() + jumpingGoal.getFlightDuration());
        this.jumpingMomentumRateControlModuleInput.setInFlight(true);
        this.comPlannerDone.set(false);
    }

    public void setMinimizeAngularMomentumRate(boolean minimizeAngularMomentumRate) {
        this.minimizeAngularMomentumRate.set(minimizeAngularMomentumRate);
    }

    public boolean isCoMPlanDone() {
        return this.comPlannerDone.getValue();
    }

    public void setFinalTransferTime(double finalTransferDuration) {
        this.copTrajectoryState.setFinalTransferDuration(finalTransferDuration);
    }

    public FramePoint3DReadOnly getCapturePoint() {
        return this.controllerToolbox.getCapturePoint();
    }

    public JumpingMomentumRateControlModuleInput getJumpingMomentumRateControlModuleInput() {
        return this.jumpingMomentumRateControlModuleInput;
    }
}

