/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.capturePoint;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.TaskspaceTrajectoryStatusMessage;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPlane;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlPolygons;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleOutput;
import us.ihmc.commonWalkingControlModules.capturePoint.PrecomputedICPPlanner;
import us.ihmc.commonWalkingControlModules.capturePoint.SwingSpeedUpCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.stepAdjustment.StepAdjustmentController;
import us.ihmc.commonWalkingControlModules.captureRegion.PushRecoveryControlModule;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.PelvisICPBasedTranslationManager;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.AngularMomentumHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.FlamingoCoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.WalkingCoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMContinuousContinuityCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanner;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commonWalkingControlModules.messageHandlers.CenterOfMassTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.MomentumTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.StepConstraintRegionHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.humanoidRobotics.footstep.SimpleFootstep;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class BalanceManager {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean viewCoPHistory = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ICPControlPlane icpControlPlane;
    private final BipedSupportPolygons bipedSupportPolygons;
    private final ICPControlPolygons icpControlPolygons;
    private final MomentumTrajectoryHandler momentumTrajectoryHandler;
    private final PrecomputedICPPlanner precomputedICPPlanner;
    private final LinearMomentumRateControlModuleInput linearMomentumRateControlModuleInput = new LinearMomentumRateControlModuleInput();
    private final PelvisICPBasedTranslationManager pelvisICPBasedTranslationManager;
    private final PushRecoveryControlModule pushRecoveryControlModule;
    private final StepAdjustmentController stepAdjustmentController;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final YoFramePoint2D yoDesiredCapturePoint = new YoFramePoint2D("desiredICP", worldFrame, this.registry);
    private final YoFrameVector2D yoDesiredICPVelocity = new YoFrameVector2D("desiredICPVelocity", worldFrame, this.registry);
    private final YoFramePoint3D yoDesiredCoMPosition = new YoFramePoint3D("desiredCoMPosition", worldFrame, this.registry);
    private final YoFrameVector3D yoDesiredCoMVelocity = new YoFrameVector3D("desiredCoMVelocity", worldFrame, this.registry);
    private final YoFramePoint2D yoFinalDesiredICP = new YoFramePoint2D("finalDesiredICP", worldFrame, this.registry);
    private final YoFramePoint3D yoFinalDesiredCoM = new YoFramePoint3D("finalDesiredCoM", worldFrame, this.registry);
    private final YoFrameVector3D yoFinalDesiredCoMVelocity = new YoFrameVector3D("finalDesiredCoMVelocity", worldFrame, this.registry);
    private final YoFrameVector3D yoFinalDesiredCoMAcceleration = new YoFrameVector3D("finalDesiredCoMAcceleration", worldFrame, this.registry);
    private final SwingSpeedUpCalculator swingSpeedUpCalculator = new SwingSpeedUpCalculator();
    private final YoFramePoint3D yoPerfectCoP = new YoFramePoint3D("perfectCoP", worldFrame, this.registry);
    private final YoFrameVector2D yoPerfectCoPVelocity = new YoFrameVector2D("perfectCoPVelocity", worldFrame, this.registry);
    private final YoFramePoint3D yoPerfectCMP = new YoFramePoint3D("perfectCMP", worldFrame, this.registry);
    private final BagOfBalls perfectCoPTrajectory;
    private final BagOfBalls perfectCMPTrajectory;
    private final YoBoolean useMomentumRecoveryModeForBalance = new YoBoolean("useMomentumRecoveryModeForBalance", this.registry);
    private final YoDouble yoTime;
    private final ReferenceFrame centerOfMassFrame;
    private final FramePoint3D centerOfMassPosition = new FramePoint3D();
    private final FramePoint2D centerOfMassPosition2d = new FramePoint2D();
    private final FramePoint2D capturePoint2d = new FramePoint2D();
    private final FramePoint2D desiredCapturePoint2d = new FramePoint2D();
    private final FramePoint2D desiredCoM2d = new FramePoint2D();
    private final FrameVector2D desiredCapturePointVelocity2d = new FrameVector2D();
    private final FramePoint2D perfectCMP2d = new FramePoint2D();
    private final FramePoint2D perfectCoP2d = new FramePoint2D();
    private final YoBoolean blendICPTrajectories = new YoBoolean("blendICPTrajectories", this.registry);
    private final FramePoint2D adjustedDesiredCapturePoint2d = new FramePoint2D();
    private final YoFramePoint2D yoAdjustedDesiredCapturePoint = new YoFramePoint2D("adjustedDesiredICP", worldFrame, this.registry);
    private final FrameVector2D icpError2d = new FrameVector2D();
    private final ConvexPolygonScaler convexPolygonShrinker = new ConvexPolygonScaler();
    private final FrameConvexPolygon2D shrunkSupportPolygon = new FrameConvexPolygon2D();
    private StepConstraintRegionHandler stepConstraintRegionHandler;
    private final YoDouble safeDistanceFromSupportEdgesToStopCancelICPPlan = new YoDouble("safeDistanceFromSupportEdgesToStopCancelICPPlan", this.registry);
    private final YoDouble distanceToShrinkSupportPolygonWhenHoldingCurrent = new YoDouble("distanceToShrinkSupportPolygonWhenHoldingCurrent", this.registry);
    private final YoBoolean holdICPToCurrentCoMLocationInNextDoubleSupport = new YoBoolean("holdICPToCurrentCoMLocationInNextDoubleSupport", this.registry);
    private final YoDouble normalizedICPError = new YoDouble("normalizedICPError", this.registry);
    private final DoubleProvider maxICPErrorBeforeSingleSupportForwardX;
    private final DoubleProvider maxICPErrorBeforeSingleSupportBackwardX;
    private final DoubleProvider maxICPErrorBeforeSingleSupportInnerY;
    private final DoubleProvider maxICPErrorBeforeSingleSupportOuterY;
    private final DoubleProvider icpDistanceOutsideSupportForStep = new DoubleParameter("icpDistanceOutsideSupportForStep", this.registry, 0.03);
    private final DoubleProvider ellipticICPErrorForMomentumRecovery = new DoubleParameter("ellipticICPErrorForMomentumRecovery", this.registry, 2.0);
    private final BooleanProvider useAngularMomentumOffset = new BooleanParameter("useAngularMomentumOffset", this.registry, false);
    private final BooleanProvider useAngularMomentumOffsetInStanding = new BooleanParameter("useAngularMomentumOffsetInStanding", this.registry, true);
    private final YoBoolean computeAngularMomentumOffset = new YoBoolean("computeAngularMomentumOffset", this.registry);
    private final DoubleParameter icpVelocityDecayDurationWhenDone = new DoubleParameter("ICPVelocityDecayDurationWhenDone", this.registry, Double.NaN);
    private final YoDouble icpVelocityReductionFactor = new YoDouble("ICPVelocityReductionFactor", this.registry);
    private final CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
    private final YoBoolean icpPlannerDone = new YoBoolean("ICPPlannerDone", this.registry);
    private final ExecutionTimer plannerTimer = new ExecutionTimer("icpPlannerTimer", this.registry);
    private boolean initializeOnStateChange = false;
    private boolean minimizeAngularMomentumRateZ = false;
    private double timeRemainingInSwing = Double.NaN;
    private RobotSide supportSide;
    private final YoFrameVector2D residualICPErrorForStepAdjustment = new YoFrameVector2D("residualICPErrorForStepAdjustment", worldFrame, this.registry);
    private final FixedFramePoint2DBasics desiredCMP = new FramePoint2D();
    private final FixedFrameVector3DBasics effectiveICPAdjustment = new FrameVector3D();
    private final SimpleFootstep currentFootstep = new SimpleFootstep();
    private final SideDependentList<PlaneContactStateCommand> contactStateCommands = new SideDependentList((Object)new PlaneContactStateCommand(), (Object)new PlaneContactStateCommand());
    private final SideDependentList<? extends ReferenceFrame> soleFrames;
    private final List<Footstep> footsteps = new ArrayList<Footstep>();
    private final List<FootstepTiming> footstepTimings = new ArrayList<FootstepTiming>();
    private final YoBoolean inSingleSupport = new YoBoolean("InSingleSupport", this.registry);
    private final YoDouble currentStateDuration = new YoDouble("CurrentStateDuration", this.registry);
    private final YoDouble totalStateDuration = new YoDouble("totalStateDuration", this.registry);
    private final FootstepTiming currentTiming = new FootstepTiming();
    private final YoDouble timeInSupportSequence = new YoDouble("TimeInSupportSequence", this.registry);
    private final CoPTrajectoryGeneratorState copTrajectoryState;
    private final WalkingCoPTrajectoryGenerator copTrajectory;
    private final FlamingoCoPTrajectoryGenerator flamingoCopTrajectory;
    private final AngularMomentumHandler<SettableContactStateProvider> angularMomentumHandler;
    private final CoMTrajectoryPlanner comTrajectoryPlanner;
    private final int maxNumberOfStepsToConsider;
    private final BooleanProvider maintainInitialCoMVelocityContinuitySingleSupport;
    private final BooleanProvider maintainInitialCoMVelocityContinuityTransfer;

    public BalanceManager(HighLevelHumanoidControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, CoPTrajectoryParameters copTrajectoryParameters, SplitFractionCalculatorParametersReadOnly splitFractionParameters, YoRegistry parentRegistry) {
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        double gravityZ = controllerToolbox.getGravityZ();
        double totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)fullRobotModel.getElevator());
        this.controllerToolbox = controllerToolbox;
        this.yoTime = controllerToolbox.getYoTime();
        this.angularMomentumHandler = new AngularMomentumHandler<SettableContactStateProvider>(totalMass, gravityZ, controllerToolbox.getCenterOfMassJacobian(), (SideDependentList<MovingReferenceFrame>)controllerToolbox.getReferenceFrames().getSoleFrames(), SettableContactStateProvider::new, this.registry, yoGraphicsListRegistry);
        this.centerOfMassFrame = referenceFrames.getCenterOfMassFrame();
        this.bipedSupportPolygons = controllerToolbox.getBipedSupportPolygons();
        this.icpControlPlane = new ICPControlPlane(this.centerOfMassFrame, gravityZ, this.registry);
        this.icpControlPolygons = new ICPControlPolygons(this.icpControlPlane, this.registry, yoGraphicsListRegistry);
        WalkingMessageHandler walkingMessageHandler = controllerToolbox.getWalkingMessageHandler();
        MomentumTrajectoryHandler momentumTrajectoryHandler = this.momentumTrajectoryHandler = walkingMessageHandler == null ? null : walkingMessageHandler.getMomentumTrajectoryHandler();
        if (walkingMessageHandler != null) {
            CenterOfMassTrajectoryHandler comTrajectoryHandler = walkingMessageHandler.getComTrajectoryHandler();
            double dt = controllerToolbox.getControlDT();
            this.precomputedICPPlanner = new PrecomputedICPPlanner(dt, comTrajectoryHandler, this.momentumTrajectoryHandler, this.registry, yoGraphicsListRegistry);
            this.precomputedICPPlanner.setOmega0(controllerToolbox.getOmega0());
            this.precomputedICPPlanner.setMass(totalMass);
            this.precomputedICPPlanner.setGravity(gravityZ);
        } else {
            this.precomputedICPPlanner = null;
        }
        this.blendICPTrajectories.set(true);
        this.safeDistanceFromSupportEdgesToStopCancelICPPlan.set(0.05);
        this.distanceToShrinkSupportPolygonWhenHoldingCurrent.set(0.08);
        this.maxICPErrorBeforeSingleSupportForwardX = new DoubleParameter("maxICPErrorBeforeSingleSupportForwardX", this.registry, walkingControllerParameters.getMaxICPErrorBeforeSingleSupportForwardX());
        this.maxICPErrorBeforeSingleSupportBackwardX = new DoubleParameter("maxICPErrorBeforeSingleSupportBackwardX", this.registry, walkingControllerParameters.getMaxICPErrorBeforeSingleSupportBackwardX());
        this.maxICPErrorBeforeSingleSupportInnerY = new DoubleParameter("maxICPErrorBeforeSingleSupportInnerY", this.registry, walkingControllerParameters.getMaxICPErrorBeforeSingleSupportInnerY());
        this.maxICPErrorBeforeSingleSupportOuterY = new DoubleParameter("maxICPErrorBeforeSingleSupportOuterY", this.registry, walkingControllerParameters.getMaxICPErrorBeforeSingleSupportOuterY());
        double pelvisTranslationICPSupportPolygonSafeMargin = walkingControllerParameters.getPelvisTranslationICPSupportPolygonSafeMargin();
        this.pelvisICPBasedTranslationManager = new PelvisICPBasedTranslationManager(controllerToolbox, pelvisTranslationICPSupportPolygonSafeMargin, this.bipedSupportPolygons, this.registry);
        FrameConvexPolygon2D defaultSupportPolygon = (FrameConvexPolygon2D)controllerToolbox.getDefaultFootPolygons().get((Enum)RobotSide.LEFT);
        this.soleFrames = controllerToolbox.getReferenceFrames().getSoleFrames();
        this.registry.addChild(copTrajectoryParameters.getRegistry());
        this.maxNumberOfStepsToConsider = copTrajectoryParameters.getMaxNumberOfStepsToConsider();
        this.maintainInitialCoMVelocityContinuitySingleSupport = new BooleanParameter("maintainInitialCoMVelocityContinuitySingleSupport", this.registry, true);
        this.maintainInitialCoMVelocityContinuityTransfer = new BooleanParameter("maintainInitialCoMVelocityContinuityTransfer", this.registry, true);
        this.comTrajectoryPlanner = new CoMTrajectoryPlanner(controllerToolbox.getGravityZ(), controllerToolbox.getOmega0Provider(), this.registry);
        this.comTrajectoryPlanner.setComContinuityCalculator(new CoMContinuousContinuityCalculator(controllerToolbox.getGravityZ(), controllerToolbox.getOmega0Provider(), this.registry));
        this.copTrajectoryState = new CoPTrajectoryGeneratorState(this.registry, this.maxNumberOfStepsToConsider);
        this.copTrajectoryState.registerStateToSave(copTrajectoryParameters);
        this.copTrajectory = new WalkingCoPTrajectoryGenerator(copTrajectoryParameters, splitFractionParameters, (ConvexPolygon2DReadOnly)defaultSupportPolygon, this.registry);
        this.copTrajectory.registerState(this.copTrajectoryState);
        this.flamingoCopTrajectory = new FlamingoCoPTrajectoryGenerator(copTrajectoryParameters, this.registry);
        this.flamingoCopTrajectory.registerState(this.copTrajectoryState);
        this.pushRecoveryControlModule = new PushRecoveryControlModule(this.bipedSupportPolygons, controllerToolbox, walkingControllerParameters, this.registry);
        this.stepAdjustmentController = new StepAdjustmentController(walkingControllerParameters, (SideDependentList<? extends ReferenceFrame>)controllerToolbox.getReferenceFrames().getSoleZUpFrames(), this.bipedSupportPolygons, this.icpControlPolygons, controllerToolbox.getContactableFeet(), controllerToolbox.getControlDT(), this.registry, yoGraphicsListRegistry);
        String graphicListName = this.getClass().getSimpleName();
        if (yoGraphicsListRegistry != null) {
            this.perfectCoPTrajectory = null;
            this.perfectCMPTrajectory = null;
            YoGraphicPosition desiredCapturePointViz = new YoGraphicPosition("Desired Capture Point", this.yoDesiredCapturePoint, 0.01, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            YoGraphicPosition finalDesiredCapturePointViz = new YoGraphicPosition("Final Desired Capture Point", this.yoFinalDesiredICP, 0.01, YoAppearance.Beige(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            YoGraphicPosition finalDesiredCoMViz = new YoGraphicPosition("Final Desired CoM", this.yoFinalDesiredCoM, 0.01, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL_WITH_ROTATED_CROSS);
            YoGraphicPosition perfectCMPViz = new YoGraphicPosition("Perfect CMP", this.yoPerfectCMP, 0.002, YoAppearance.BlueViolet());
            YoGraphicPosition perfectCoPViz = new YoGraphicPosition("Perfect CoP", this.yoPerfectCoP, 0.002, YoAppearance.DarkViolet(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition adjustedDesiredCapturePointViz = new YoGraphicPosition("Adjusted Desired Capture Point", this.yoAdjustedDesiredCapturePoint, 0.005, YoAppearance.Yellow(), YoGraphicPosition.GraphicType.DIAMOND);
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)adjustedDesiredCapturePointViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)desiredCapturePointViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)finalDesiredCapturePointViz.createArtifact());
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)finalDesiredCoMViz.createArtifact());
            YoArtifactPosition perfectCMPArtifact = perfectCMPViz.createArtifact();
            perfectCMPArtifact.setVisible(false);
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)perfectCMPArtifact);
            YoArtifactPosition perfectCoPArtifact = perfectCoPViz.createArtifact();
            perfectCoPArtifact.setVisible(false);
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)perfectCoPArtifact);
        } else {
            this.perfectCoPTrajectory = null;
            this.perfectCMPTrajectory = null;
        }
        this.yoDesiredCapturePoint.setToNaN();
        this.yoFinalDesiredICP.setToNaN();
        this.yoPerfectCMP.setToNaN();
        this.yoPerfectCoP.setToNaN();
        this.yoPerfectCoPVelocity.setToNaN();
        parentRegistry.addChild(this.registry);
    }

    public void setUseMomentumRecoveryModeForBalance(boolean useMomentumRecoveryModeForBalance) {
        this.useMomentumRecoveryModeForBalance.set(useMomentumRecoveryModeForBalance);
    }

    public void addFootstepToPlan(Footstep footstep, FootstepTiming timing) {
        this.copTrajectoryState.addFootstep(footstep);
        this.copTrajectoryState.addFootstepTiming(timing);
        this.footsteps.add(footstep);
        this.footstepTimings.add(timing);
    }

    public void setPlanarRegionStepConstraintHandler(StepConstraintRegionHandler planarRegionStepConstraint) {
        this.stepConstraintRegionHandler = planarRegionStepConstraint;
    }

    public boolean checkAndUpdateFootstep(Footstep footstep) {
        return this.pushRecoveryControlModule.checkAndUpdateFootstep(this.getTimeRemainingInCurrentState(), footstep);
    }

    public boolean checkAndUpdateStepAdjustment(Footstep footstep) {
        boolean usingStepAdjustment = this.stepAdjustmentController.useStepAdjustment();
        if (!usingStepAdjustment || this.initializeOnStateChange) {
            return false;
        }
        double omega0 = this.linearMomentumRateControlModuleInput.getOmega0();
        FramePoint2D desiredCapturePoint = this.linearMomentumRateControlModuleInput.getDesiredCapturePoint();
        this.controllerToolbox.getCapturePoint((FixedFramePoint2DBasics)this.capturePoint2d);
        this.icpControlPlane.setOmega0(omega0);
        this.icpControlPolygons.updateUsingContactStateCommand(this.contactStateCommands);
        if (!Double.isNaN(this.timeRemainingInSwing) && this.timeRemainingInSwing > 0.0) {
            this.stepAdjustmentController.submitRemainingTimeInSwingUnderDisturbance(this.timeRemainingInSwing);
        }
        if (this.stepConstraintRegionHandler != null && this.stepConstraintRegionHandler.hasNewStepConstraintRegion()) {
            this.stepAdjustmentController.setStepConstraintRegion(this.stepConstraintRegionHandler.pollHasNewStepConstraintRegion());
        }
        this.stepAdjustmentController.compute(this.yoTime.getDoubleValue(), (FramePoint2DReadOnly)desiredCapturePoint, (FramePoint2DReadOnly)this.capturePoint2d, (FrameVector2DReadOnly)this.residualICPErrorForStepAdjustment, omega0);
        boolean footstepWasAdjusted = this.stepAdjustmentController.wasFootstepAdjusted();
        footstep.setPose(this.stepAdjustmentController.getFootstepSolution());
        return footstepWasAdjusted;
    }

    public void clearICPPlan() {
        this.copTrajectoryState.clear();
        this.footsteps.clear();
        this.footstepTimings.clear();
    }

    public void setSwingFootTrajectory(RobotSide swingSide, MultipleWaypointsPoseTrajectoryGenerator swingTrajectory) {
        this.angularMomentumHandler.setSwingFootTrajectory(swingSide, swingTrajectory);
    }

    public void clearSwingFootTrajectory() {
        this.angularMomentumHandler.clearSwingFootTrajectory();
    }

    public void setICPPlanSupportSide(RobotSide supportSide) {
        this.supportSide = supportSide;
    }

    public void compute(RobotSide supportLeg, FeedbackControlCommand<?> heightControlCommand, boolean keepCoPInsideSupportPolygon, boolean controlHeightWithMomentum) {
        this.desiredCapturePoint2d.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredDCMPosition());
        this.desiredCapturePointVelocity2d.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredDCMVelocity());
        if (!this.icpVelocityReductionFactor.isNaN()) {
            this.desiredCapturePointVelocity2d.scale(this.icpVelocityReductionFactor.getValue());
        }
        this.perfectCMP2d.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredECMPPosition());
        this.desiredCoM2d.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMPosition());
        this.yoDesiredCoMVelocity.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMVelocity());
        this.capturePoint2d.setIncludingFrame((FrameTuple3DReadOnly)this.controllerToolbox.getCapturePoint());
        this.pelvisICPBasedTranslationManager.compute(supportLeg);
        this.pelvisICPBasedTranslationManager.addICPOffset(this.desiredCapturePoint2d, this.desiredCoM2d, this.perfectCMP2d);
        double omega0 = this.controllerToolbox.getOmega0();
        if (Double.isNaN(omega0)) {
            throw new RuntimeException("omega0 is NaN");
        }
        if (supportLeg == null) {
            this.pushRecoveryControlModule.updateForDoubleSupport((FramePoint2DReadOnly)this.desiredCapturePoint2d, (FramePoint2DReadOnly)this.capturePoint2d, omega0);
        } else {
            this.pushRecoveryControlModule.updateForSingleSupport((FramePoint2DReadOnly)this.desiredCapturePoint2d, (FramePoint2DReadOnly)this.capturePoint2d, omega0);
        }
        this.controllerToolbox.getAdjustedDesiredCapturePoint((FramePoint2DReadOnly)this.desiredCapturePoint2d, (FramePoint2DBasics)this.adjustedDesiredCapturePoint2d);
        this.yoAdjustedDesiredCapturePoint.set((FrameTuple2DReadOnly)this.adjustedDesiredCapturePoint2d);
        this.desiredCapturePoint2d.setIncludingFrame((FrameTuple2DReadOnly)this.adjustedDesiredCapturePoint2d);
        if (this.precomputedICPPlanner != null) {
            if (this.blendICPTrajectories.getBooleanValue()) {
                this.precomputedICPPlanner.computeAndBlend(this.yoTime.getDoubleValue(), (FixedFramePoint2DBasics)this.desiredCapturePoint2d, (FixedFrameVector2DBasics)this.desiredCapturePointVelocity2d, (FixedFramePoint2DBasics)this.perfectCMP2d);
            } else {
                this.precomputedICPPlanner.compute(this.yoTime.getDoubleValue(), (FramePoint2DBasics)this.desiredCapturePoint2d, (FrameVector2DBasics)this.desiredCapturePointVelocity2d, (FramePoint2DBasics)this.perfectCMP2d);
            }
        }
        this.yoDesiredCapturePoint.set((FrameTuple2DReadOnly)this.desiredCapturePoint2d);
        this.yoDesiredICPVelocity.set((FrameTuple2DReadOnly)this.desiredCapturePointVelocity2d);
        this.yoDesiredCoMPosition.set((FrameTuple2DReadOnly)this.desiredCoM2d, this.comTrajectoryPlanner.getDesiredCoMPosition().getZ());
        this.yoPerfectCoPVelocity.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredVRPVelocity());
        CapturePointTools.computeCentroidalMomentumPivot((FramePoint2DReadOnly)this.yoDesiredCapturePoint, (FrameVector2DReadOnly)this.yoDesiredICPVelocity, omega0, (FixedFramePoint2DBasics)this.perfectCMP2d);
        this.yoPerfectCMP.set((FrameTuple2DReadOnly)this.perfectCMP2d, this.comTrajectoryPlanner.getDesiredECMPPosition().getZ());
        if (this.computeAngularMomentumOffset.getValue()) {
            this.angularMomentumHandler.computeCoPPosition((FramePoint3DReadOnly)this.yoPerfectCMP, (FixedFramePoint3DBasics)this.yoPerfectCoP);
        } else {
            this.yoPerfectCoP.set((FrameTuple3DReadOnly)this.yoPerfectCMP);
        }
        for (RobotSide robotSide : RobotSide.values) {
            YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(robotSide);
            contactState.getPlaneContactStateCommand((PlaneContactStateCommand)this.contactStateCommands.get((Enum)robotSide));
        }
        if (heightControlCommand.getCommandType() == ControllerCoreCommandType.POINT) {
            this.linearMomentumRateControlModuleInput.setUsePelvisHeightCommand(true);
            this.linearMomentumRateControlModuleInput.setPelvisHeightControlCommand((PointFeedbackControlCommand)heightControlCommand);
        } else if (heightControlCommand.getCommandType() == ControllerCoreCommandType.MOMENTUM) {
            this.linearMomentumRateControlModuleInput.setUsePelvisHeightCommand(false);
            this.linearMomentumRateControlModuleInput.setCenterOfMassHeightControlCommand((CenterOfMassFeedbackControlCommand)heightControlCommand);
        } else {
            throw new IllegalArgumentException("Invalid height control type.");
        }
        if (this.perfectCMPTrajectory != null) {
            this.perfectCMPTrajectory.setBallLoop((FramePoint3DReadOnly)this.yoPerfectCMP);
            this.perfectCoPTrajectory.setBallLoop((FramePoint3DReadOnly)this.yoPerfectCoP);
        }
        this.perfectCMP2d.setIncludingFrame((FrameTuple3DReadOnly)this.yoPerfectCMP);
        this.perfectCoP2d.setIncludingFrame((FrameTuple3DReadOnly)this.yoPerfectCoP);
        this.linearMomentumRateControlModuleInput.setInitializeOnStateChange(this.initializeOnStateChange);
        this.linearMomentumRateControlModuleInput.setKeepCoPInsideSupportPolygon(keepCoPInsideSupportPolygon);
        this.linearMomentumRateControlModuleInput.setControlHeightWithMomentum(controlHeightWithMomentum);
        this.linearMomentumRateControlModuleInput.setOmega0(omega0);
        this.linearMomentumRateControlModuleInput.setUseMomentumRecoveryMode(this.useMomentumRecoveryModeForBalance.getBooleanValue());
        this.linearMomentumRateControlModuleInput.setDesiredCapturePoint((FramePoint2DReadOnly)this.desiredCapturePoint2d);
        this.linearMomentumRateControlModuleInput.setDesiredCapturePointVelocity((FrameVector2DReadOnly)this.desiredCapturePointVelocity2d);
        this.linearMomentumRateControlModuleInput.setPerfectCMP((FramePoint2DReadOnly)this.perfectCMP2d);
        this.linearMomentumRateControlModuleInput.setPerfectCoP((FramePoint2DReadOnly)this.perfectCoP2d);
        this.linearMomentumRateControlModuleInput.setMinimizeAngularMomentumRateZ(this.minimizeAngularMomentumRateZ);
        this.linearMomentumRateControlModuleInput.setContactStateCommand(this.contactStateCommands);
        this.initializeOnStateChange = false;
        this.supportSide = null;
        if (this.momentumTrajectoryHandler != null) {
            this.momentumTrajectoryHandler.packDesiredAngularMomentumAtTime(this.yoTime.getValue(), null, null);
        }
    }

    public void adjustFootstep(Footstep footstep) {
        this.copTrajectoryState.getFootstep(0).set(footstep);
    }

    public void setHoldSplitFractions(boolean hold) {
        this.copTrajectory.setHoldSplitFractions(hold);
    }

    public void computeICPPlan() {
        this.computeICPPlanInternal(this.copTrajectory);
    }

    public void computeFlamingoStateICPPlan() {
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffset.getValue() && this.useAngularMomentumOffsetInStanding.getValue());
        this.computeICPPlanInternal(this.flamingoCopTrajectory);
    }

    private void computeICPPlanInternal(CoPTrajectoryGenerator copTrajectory) {
        this.plannerTimer.startMeasurement();
        for (RobotSide robotSide : RobotSide.values) {
            if (!this.controllerToolbox.getFootContactState(robotSide).inContact()) continue;
            this.copTrajectoryState.initializeStance(robotSide, this.bipedSupportPolygons.getFootPolygonInSoleFrame(robotSide), (ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        }
        copTrajectory.compute(this.copTrajectoryState);
        Object contactStateProviders = copTrajectory.getContactStateProviders();
        if (this.computeAngularMomentumOffset.getValue()) {
            if (this.comTrajectoryPlanner.hasTrajectories()) {
                this.angularMomentumHandler.solveForAngularMomentumTrajectory(this.copTrajectoryState, (List<TimeIntervalProvider>)contactStateProviders, (MultipleSegmentPositionTrajectoryGenerator<?>)this.comTrajectoryPlanner.getCoMTrajectory());
                contactStateProviders = this.angularMomentumHandler.computeECMPTrajectory((List<SettableContactStateProvider>)contactStateProviders);
            } else {
                this.angularMomentumHandler.resetAngularMomentum();
            }
            this.angularMomentumHandler.computeAngularMomentum(this.timeInSupportSequence.getDoubleValue());
        } else {
            this.comTrajectoryPlanner.reset();
        }
        this.comTrajectoryPlanner.solveForTrajectory((List<? extends ContactStateProvider>)contactStateProviders);
        this.comTrajectoryPlanner.compute(this.totalStateDuration.getDoubleValue());
        this.yoFinalDesiredCoM.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMPosition());
        this.yoFinalDesiredCoMVelocity.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMVelocity());
        this.yoFinalDesiredCoMAcceleration.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredCoMAcceleration());
        this.yoFinalDesiredICP.set((FrameTuple3DReadOnly)this.comTrajectoryPlanner.getDesiredDCMPosition());
        this.comTrajectoryPlanner.compute(this.timeInSupportSequence.getDoubleValue());
        if (this.footstepTimings.isEmpty()) {
            this.yoFinalDesiredICP.setToNaN();
            this.yoFinalDesiredCoM.setToNaN();
            this.yoFinalDesiredCoMVelocity.setToNaN();
            this.yoFinalDesiredCoMAcceleration.setToNaN();
        }
        if (this.footsteps.isEmpty() || !this.icpPlannerDone.getValue()) {
            this.timeInSupportSequence.add(this.controllerToolbox.getControlDT());
        }
        this.icpPlannerDone.set(this.timeInSupportSequence.getValue() >= this.currentStateDuration.getValue());
        this.decayDesiredICPVelocity();
        this.plannerTimer.stopMeasurement();
    }

    private void decayDesiredICPVelocity() {
        if (Double.isNaN(this.icpVelocityDecayDurationWhenDone.getValue())) {
            this.icpVelocityReductionFactor.set(Double.NaN);
            return;
        }
        if (this.inSingleSupport.getValue() || !this.icpPlannerDone.getValue()) {
            this.icpVelocityReductionFactor.set(Double.NaN);
            return;
        }
        if (this.icpVelocityReductionFactor.isNaN()) {
            this.icpVelocityReductionFactor.set(1.0);
            return;
        }
        double scaleUpdated = this.icpVelocityReductionFactor.getValue() - this.controllerToolbox.getControlDT() / this.icpVelocityDecayDurationWhenDone.getValue();
        this.icpVelocityReductionFactor.set(Math.max(0.0, scaleUpdated));
    }

    public void packFootstepForRecoveringFromDisturbance(RobotSide swingSide, double swingTimeRemaining, Footstep footstepToPack) {
        this.pushRecoveryControlModule.packFootstepForRecoveringFromDisturbance(swingSide, swingTimeRemaining, footstepToPack);
    }

    public void disablePelvisXYControl() {
        this.pelvisICPBasedTranslationManager.disable();
    }

    public void disablePushRecovery() {
        this.pushRecoveryControlModule.setIsEnabled(false);
    }

    public void enablePelvisXYControl() {
        this.pelvisICPBasedTranslationManager.enable();
    }

    public void enablePushRecovery() {
        this.pushRecoveryControlModule.setIsEnabled(true);
    }

    public double estimateTimeRemainingForSwingUnderDisturbance() {
        double stateDuration = this.currentTiming.getStepTime();
        double timeRemainingInCurrentState = this.timeInSupportSequence.getDoubleValue() - stateDuration;
        if (this.icpPlannerDone.getBooleanValue()) {
            return 0.0;
        }
        this.controllerToolbox.getCapturePoint((FixedFramePoint2DBasics)this.capturePoint2d);
        this.perfectCMP2d.set((FrameTuple3DReadOnly)this.yoPerfectCMP);
        double deltaTimeToBeAccounted = this.swingSpeedUpCalculator.estimateDeltaTimeBetweenDesiredICPAndActualICP((FramePoint2DReadOnly)this.yoDesiredCapturePoint, (FramePoint2DReadOnly)this.perfectCMP2d, (FramePoint2DReadOnly)this.yoFinalDesiredICP, (FramePoint2DReadOnly)this.capturePoint2d, this.controllerToolbox.getOmega0());
        if (Double.isNaN(deltaTimeToBeAccounted)) {
            return 0.0;
        }
        double estimatedTimeRemaining = timeRemainingInCurrentState - deltaTimeToBeAccounted;
        estimatedTimeRemaining = MathTools.clamp((double)estimatedTimeRemaining, (double)0.0, (double)Double.POSITIVE_INFINITY);
        return estimatedTimeRemaining;
    }

    public void freezePelvisXYControl() {
        this.pelvisICPBasedTranslationManager.freeze();
    }

    public int getMaxNumberOfStepsToConsider() {
        return this.maxNumberOfStepsToConsider;
    }

    public FramePoint2DReadOnly getDesiredCMP() {
        return this.desiredCMP;
    }

    public FramePoint2DReadOnly getFinalDesiredICP() {
        return this.yoFinalDesiredICP;
    }

    public FramePoint2DReadOnly getDesiredICP() {
        return this.yoDesiredCapturePoint;
    }

    public FrameVector2DReadOnly getDesiredICPVelocity() {
        return this.yoDesiredICPVelocity;
    }

    public FramePoint3DReadOnly getFinalDesiredCoMPosition() {
        return this.yoFinalDesiredCoM;
    }

    public FrameVector3DReadOnly getFinalDesiredCoMVelocity() {
        return this.yoFinalDesiredCoMVelocity;
    }

    public FrameVector3DReadOnly getFinalDesiredCoMAcceleration() {
        return this.yoFinalDesiredCoMAcceleration;
    }

    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.yoDesiredCoMVelocity;
    }

    public FramePoint3DReadOnly getFirstExitCMPForToeOff(boolean isInTransfer) {
        if (isInTransfer) {
            return ((SettableContactStateProvider)this.copTrajectory.getContactStateProviders().get(0)).getECMPStartPosition();
        }
        return ((SettableContactStateProvider)this.copTrajectory.getContactStateProviders().get(4)).getECMPEndPosition();
    }

    public double getTimeRemainingInCurrentState() {
        if (this.footstepTimings.isEmpty()) {
            return 0.0;
        }
        return this.currentTiming.getStepTime() - this.timeInSupportSequence.getValue();
    }

    public void goHome() {
        if (this.pelvisICPBasedTranslationManager.isEnabled()) {
            this.pelvisICPBasedTranslationManager.goToHome();
        }
    }

    public void handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        this.pelvisICPBasedTranslationManager.handlePelvisTrajectoryCommand(command);
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        this.pelvisICPBasedTranslationManager.handleStopAllTrajectoryCommand(command);
    }

    public void initialize() {
        this.yoFinalDesiredICP.setToNaN();
        this.yoFinalDesiredCoM.setToNaN();
        this.yoFinalDesiredCoMVelocity.setToNaN();
        this.yoFinalDesiredCoMAcceleration.setToNaN();
        this.yoDesiredCapturePoint.set((FrameTuple3DReadOnly)this.controllerToolbox.getCapturePoint());
        this.yoDesiredCoMPosition.setFromReferenceFrame(this.controllerToolbox.getCenterOfMassFrame());
        this.yoDesiredCoMVelocity.setToZero();
        this.yoPerfectCoP.setMatchingFrame((FrameTuple2DReadOnly)this.bipedSupportPolygons.getSupportPolygonInMidFeetZUp().getCentroid(), 0.0);
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectCoP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.timeInSupportSequence.set(0.0);
        this.inSingleSupport.set(false);
        this.currentStateDuration.set(Double.NaN);
        this.totalStateDuration.set(Double.NaN);
        this.comTrajectoryPlanner.setMaintainInitialCoMVelocityContinuity(false);
        this.initializeOnStateChange = true;
        this.stepAdjustmentController.reset();
        this.comTrajectoryPlanner.reset();
        this.angularMomentumHandler.resetAngularMomentum();
    }

    public void prepareForDoubleSupportPushRecovery() {
        this.pushRecoveryControlModule.initializeParametersForDoubleSupportPushRecovery();
    }

    public void initializeICPPlanForSingleSupport() {
        this.inSingleSupport.set(true);
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffset.getValue());
        this.currentTiming.set(this.footstepTimings.get(0));
        this.currentFootstep.set(this.footsteps.get(0));
        this.stepAdjustmentController.reset();
        this.stepAdjustmentController.setFootstepToAdjust(this.currentFootstep, this.currentTiming.getSwingTime(), this.currentTiming.getTransferTime());
        this.stepAdjustmentController.initialize(this.yoTime.getDoubleValue(), this.supportSide);
        this.timeInSupportSequence.set(this.currentTiming.getTransferTime());
        this.currentStateDuration.set(this.currentTiming.getStepTime());
        this.totalStateDuration.set(this.currentTiming.getStepTime());
        this.comTrajectoryPlanner.setMaintainInitialCoMVelocityContinuity(this.maintainInitialCoMVelocityContinuitySingleSupport.getValue());
        this.initializeOnStateChange = true;
        this.icpPlannerDone.set(false);
    }

    public void initializeICPPlanForStanding() {
        if (this.holdICPToCurrentCoMLocationInNextDoubleSupport.getBooleanValue()) {
            this.requestICPPlannerToHoldCurrentCoM();
            this.holdICPToCurrentCoMLocationInNextDoubleSupport.set(false);
        }
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffset.getValue() && this.useAngularMomentumOffsetInStanding.getValue());
        this.angularMomentumHandler.clearSwingFootTrajectory();
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectCoP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.comTrajectoryPlanner.initializeTrajectory((FramePoint3DReadOnly)this.yoDesiredCoMPosition, Double.POSITIVE_INFINITY);
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(Double.POSITIVE_INFINITY);
        this.totalStateDuration.set(Double.POSITIVE_INFINITY);
        this.inSingleSupport.set(false);
        this.initializeOnStateChange = true;
        this.comTrajectoryPlanner.setMaintainInitialCoMVelocityContinuity(true);
        this.stepAdjustmentController.reset();
        this.icpPlannerDone.set(false);
    }

    public void initializeICPPlanForTransferToStanding() {
        this.comTrajectoryPlanner.removeCompletedSegments(this.totalStateDuration.getDoubleValue());
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffset.getValue());
        if (this.holdICPToCurrentCoMLocationInNextDoubleSupport.getBooleanValue()) {
            this.requestICPPlannerToHoldCurrentCoM();
            this.holdICPToCurrentCoMLocationInNextDoubleSupport.set(false);
        }
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectCoP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(this.copTrajectoryState.getFinalTransferDuration());
        this.totalStateDuration.set(this.copTrajectoryState.getFinalTransferDuration());
        this.inSingleSupport.set(false);
        this.initializeOnStateChange = true;
        this.comTrajectoryPlanner.setMaintainInitialCoMVelocityContinuity(true);
        this.stepAdjustmentController.reset();
        this.icpPlannerDone.set(false);
    }

    public void initializeICPPlanForTransfer() {
        this.computeAngularMomentumOffset.set(this.useAngularMomentumOffset.getValue());
        if (this.holdICPToCurrentCoMLocationInNextDoubleSupport.getBooleanValue()) {
            this.requestICPPlannerToHoldCurrentCoM();
            this.holdICPToCurrentCoMLocationInNextDoubleSupport.set(false);
        }
        this.stepAdjustmentController.reset();
        this.comTrajectoryPlanner.removeCompletedSegments(this.totalStateDuration.getDoubleValue());
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.yoPerfectCoP);
        this.copTrajectoryState.initializeStance(this.bipedSupportPolygons.getFootPolygonsInSoleZUpFrame(), this.soleFrames);
        this.comTrajectoryPlanner.setInitialCenterOfMassState((FramePoint3DReadOnly)this.yoDesiredCoMPosition, (FrameVector3DReadOnly)this.yoDesiredCoMVelocity);
        this.currentTiming.set(this.footstepTimings.get(0));
        this.timeInSupportSequence.set(0.0);
        this.currentStateDuration.set(this.currentTiming.getTransferTime());
        this.totalStateDuration.set(this.currentTiming.getStepTime());
        this.inSingleSupport.set(false);
        this.comTrajectoryPlanner.setMaintainInitialCoMVelocityContinuity(this.maintainInitialCoMVelocityContinuityTransfer.getValue());
        this.initializeOnStateChange = true;
        this.icpPlannerDone.set(false);
    }

    public void computeNormalizedEllipticICPError(RobotSide transferToSide) {
        this.getICPError(this.icpError2d);
        MovingReferenceFrame leadingSoleZUpFrame = this.controllerToolbox.getReferenceFrames().getSoleZUpFrame((Enum)transferToSide);
        this.icpError2d.changeFrame((ReferenceFrame)leadingSoleZUpFrame);
        boolean isICPErrorToTheInside = transferToSide == RobotSide.RIGHT ? this.icpError2d.getY() > 0.0 : this.icpError2d.getY() < 0.0;
        double maxICPErrorBeforeSingleSupportX = this.icpError2d.getX() > 0.0 ? this.maxICPErrorBeforeSingleSupportForwardX.getValue() : this.maxICPErrorBeforeSingleSupportBackwardX.getValue();
        double maxICPErrorBeforeSingleSupportY = isICPErrorToTheInside ? this.maxICPErrorBeforeSingleSupportInnerY.getValue() : this.maxICPErrorBeforeSingleSupportOuterY.getValue();
        this.normalizedICPError.set(MathTools.square((double)(this.icpError2d.getX() / maxICPErrorBeforeSingleSupportX)) + MathTools.square((double)(this.icpError2d.getY() / maxICPErrorBeforeSingleSupportY)));
    }

    public double getNormalizedEllipticICPError() {
        return this.normalizedICPError.getValue();
    }

    public double getEllipticICPErrorForMomentumRecovery() {
        return this.ellipticICPErrorForMomentumRecovery.getValue();
    }

    public double getICPDistanceOutsideSupportForStep() {
        return this.icpDistanceOutsideSupportForStep.getValue();
    }

    public double getICPErrorMagnitude() {
        return this.controllerToolbox.getCapturePoint().distanceXY((FramePoint2DReadOnly)this.yoDesiredCapturePoint);
    }

    public void getICPError(FrameVector2D icpErrorToPack) {
        icpErrorToPack.setIncludingFrame((FrameTuple2DReadOnly)this.yoDesiredCapturePoint);
        icpErrorToPack.checkReferenceFrameMatch((ReferenceFrameHolder)this.controllerToolbox.getCapturePoint());
        icpErrorToPack.sub(this.controllerToolbox.getCapturePoint().getX(), this.controllerToolbox.getCapturePoint().getY());
    }

    public boolean isPrecomputedICPPlannerActive() {
        return this.precomputedICPPlanner.isWithinInterval(this.yoTime.getDoubleValue());
    }

    public boolean isICPPlanDone() {
        return this.icpPlannerDone.getValue();
    }

    public boolean isPushRecoveryEnabled() {
        return this.pushRecoveryControlModule.isEnabled();
    }

    public boolean isRecovering() {
        return this.pushRecoveryControlModule.isRecovering();
    }

    public boolean isRecoveringFromDoubleSupportFall() {
        return this.pushRecoveryControlModule.isEnabled() && this.pushRecoveryControlModule.isRecoveringFromDoubleSupportFall();
    }

    public boolean isRecoveryImpossible() {
        return this.pushRecoveryControlModule.isCaptureRegionEmpty();
    }

    public boolean isRobotBackToSafeState() {
        return this.pushRecoveryControlModule.isRobotBackToSafeState();
    }

    public RobotSide isRobotFallingFromDoubleSupport() {
        return this.pushRecoveryControlModule.isRobotFallingFromDoubleSupport();
    }

    public void resetPushRecovery() {
        this.pushRecoveryControlModule.reset();
    }

    public void requestICPPlannerToHoldCurrentCoMInNextDoubleSupport() {
        this.holdICPToCurrentCoMLocationInNextDoubleSupport.set(true);
    }

    public void requestICPPlannerToHoldCurrentCoM() {
        this.centerOfMassPosition.setToZero(this.centerOfMassFrame);
        FrameConvexPolygon2DReadOnly supportPolygonInMidFeetZUp = this.bipedSupportPolygons.getSupportPolygonInMidFeetZUp();
        this.convexPolygonShrinker.scaleConvexPolygon(supportPolygonInMidFeetZUp, this.distanceToShrinkSupportPolygonWhenHoldingCurrent.getDoubleValue(), this.shrunkSupportPolygon);
        this.centerOfMassPosition.changeFrame(this.shrunkSupportPolygon.getReferenceFrame());
        this.centerOfMassPosition2d.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassPosition);
        this.shrunkSupportPolygon.orthogonalProjection((FramePoint2DBasics)this.centerOfMassPosition2d);
        this.centerOfMassPosition.set((FrameTuple2DReadOnly)this.centerOfMassPosition2d, 0.0);
        this.centerOfMassPosition.changeFrame(worldFrame);
        this.copTrajectoryState.setInitialCoP((FramePoint3DReadOnly)this.centerOfMassPosition);
    }

    public void setFinalTransferTime(double finalTransferDuration) {
        this.copTrajectoryState.setFinalTransferDuration(finalTransferDuration);
    }

    public CapturabilityBasedStatus updateAndReturnCapturabilityBasedStatus() {
        this.centerOfMassPosition.setToZero(this.centerOfMassFrame);
        this.centerOfMassPosition.changeFrame(worldFrame);
        this.capturabilityBasedStatus.setOmega(this.controllerToolbox.getOmega0());
        this.capturabilityBasedStatus.getCapturePoint2d().set((Tuple3DReadOnly)this.controllerToolbox.getCapturePoint());
        this.capturabilityBasedStatus.getDesiredCapturePoint2d().set((Tuple2DReadOnly)this.yoDesiredCapturePoint);
        this.capturabilityBasedStatus.getCenterOfMass3d().set((Tuple3DReadOnly)this.centerOfMassPosition);
        for (RobotSide robotSide : RobotSide.values) {
            HumanoidMessageTools.packFootSupportPolygon((RobotSide)robotSide, (FrameConvexPolygon2DReadOnly)this.bipedSupportPolygons.getFootPolygonInSoleFrame(robotSide), (CapturabilityBasedStatus)this.capturabilityBasedStatus);
        }
        return this.capturabilityBasedStatus;
    }

    public void updateSwingTimeRemaining(double timeRemainingInSwing) {
        this.timeRemainingInSwing = timeRemainingInSwing;
    }

    @Deprecated
    public FrameVector3DReadOnly getEffectiveICPAdjustment() {
        return this.effectiveICPAdjustment;
    }

    public FramePoint3DReadOnly getCapturePoint() {
        return this.controllerToolbox.getCapturePoint();
    }

    public void minimizeAngularMomentumRateZ(boolean minimizeAngularMomentumRateZ) {
        this.minimizeAngularMomentumRateZ = minimizeAngularMomentumRateZ;
    }

    public LinearMomentumRateControlModuleInput getLinearMomentumRateControlModuleInput() {
        return this.linearMomentumRateControlModuleInput;
    }

    public void setLinearMomentumRateControlModuleOutput(LinearMomentumRateControlModuleOutput output) {
        this.desiredCMP.set((FrameTuple2DReadOnly)output.getDesiredCMP());
        this.residualICPErrorForStepAdjustment.set((FrameTuple2DReadOnly)output.getResidualICPErrorForStepAdjustment());
    }

    public TaskspaceTrajectoryStatusMessage pollPelvisXYTranslationStatusToReport() {
        return this.pelvisICPBasedTranslationManager.pollStatusToReport();
    }
}

