/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.geometry.Point2dInConvexPolygon2d;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoFramePoint2dInPolygonCoordinate {
    private YoDouble eccentricity;
    private YoDouble angle;
    private FramePoint2D framePoint2d;
    private Point2dInConvexPolygon2d point2dInConvexPolygon2d;

    public YoFramePoint2dInPolygonCoordinate(String namePrefix, YoRegistry registry) {
        this.eccentricity = new YoDouble(namePrefix + "Eccentricity", registry);
        this.angle = new YoDouble(namePrefix + "Angle", registry);
        this.framePoint2d = null;
        this.point2dInConvexPolygon2d = null;
    }

    public FramePoint2D getCurrentPoint() {
        this.point2dInConvexPolygon2d.setAngle(this.angle.getDoubleValue());
        this.point2dInConvexPolygon2d.setEccentricity(this.eccentricity.getDoubleValue());
        this.framePoint2d.set(this.point2dInConvexPolygon2d.getX(), this.point2dInConvexPolygon2d.getY());
        return this.framePoint2d;
    }

    public void updatePointAndPolygon(FrameConvexPolygon2D polygon, FramePoint2D pointInAnyFrame) {
        FramePoint2D temp = new FramePoint2D((FrameTuple2DReadOnly)pointInAnyFrame);
        temp.changeFrame(polygon.getReferenceFrame());
        this.updatePointAndPolygon(polygon, temp);
    }

    public void updatePointAndPolygon(FrameConvexPolygon2D polygon, Point2D pointInPolygonFrame) {
        this.framePoint2d = new FramePoint2D(polygon.getReferenceFrame(), (Tuple2DReadOnly)pointInPolygonFrame);
        this.point2dInConvexPolygon2d = new Point2dInConvexPolygon2d(new ConvexPolygon2D((Vertex2DSupplier)polygon), this.framePoint2d.getX(), this.framePoint2d.getY());
        this.angle.set(this.point2dInConvexPolygon2d.getAngle());
        this.eccentricity.set(this.point2dInConvexPolygon2d.getEccentricity());
    }
}

