/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointBasics;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class YoContactPoint
implements ContactPointBasics {
    private final YoRegistry registry;
    private final YoFramePoint3D yoPosition;
    private final YoBoolean isInContact;
    private final String namePrefix;
    private final PlaneContactState parentContactState;

    public YoContactPoint(String namePrefix, int index, FramePoint2D contactPointPosition2d, PlaneContactState parentContactState, YoRegistry parentRegistry) {
        this(namePrefix, index, contactPointPosition2d.getReferenceFrame(), parentContactState, parentRegistry);
        this.set((FrameTuple2DReadOnly)contactPointPosition2d);
    }

    public YoContactPoint(String namePrefix, int index, FramePoint3D contactPointPosition, PlaneContactState parentContactState, YoRegistry parentRegistry) {
        this(namePrefix, index, contactPointPosition.getReferenceFrame(), parentContactState, parentRegistry);
        this.set((FrameTuple3DReadOnly)contactPointPosition);
    }

    public YoContactPoint(String namePrefix, int index, ReferenceFrame pointFrame, PlaneContactState parentContactState, YoRegistry parentRegistry) {
        this.parentContactState = parentContactState;
        this.namePrefix = namePrefix;
        this.registry = parentRegistry;
        this.yoPosition = new YoFramePoint3D(namePrefix + "Contact" + index, pointFrame, this.registry);
        this.isInContact = new YoBoolean(namePrefix + "InContact" + index, this.registry);
    }

    public String getNamePrefix() {
        return this.yoPosition.getNamePrefix();
    }

    public String getNameSuffix() {
        return this.yoPosition.getNameSuffix();
    }

    @Override
    public boolean isInContact() {
        return this.isInContact.getBooleanValue();
    }

    @Override
    public void setInContact(boolean inContact) {
        this.isInContact.set(inContact);
    }

    public void setX(double x) {
        this.yoPosition.setX(x);
    }

    public void setY(double y) {
        this.yoPosition.setY(y);
    }

    public void setZ(double z) {
        this.yoPosition.setZ(z);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.yoPosition.getReferenceFrame();
    }

    public double getX() {
        return this.yoPosition.getX();
    }

    public double getY() {
        return this.yoPosition.getY();
    }

    public double getZ() {
        return this.yoPosition.getZ();
    }

    @Override
    public PlaneContactState getParentContactState() {
        return this.parentContactState;
    }

    public boolean epsilonEquals(FramePoint2D contactPointPosition2d, double threshold) {
        this.yoPosition.checkReferenceFrameMatch((ReferenceFrameHolder)contactPointPosition2d);
        if (!MathTools.epsilonEquals((double)this.yoPosition.getX(), (double)contactPointPosition2d.getX(), (double)threshold)) {
            return false;
        }
        return MathTools.epsilonEquals((double)this.yoPosition.getY(), (double)contactPointPosition2d.getY(), (double)threshold);
    }

    public String toString() {
        return this.namePrefix + ", in contact: " + this.isInContact() + ", position: " + this.yoPosition.toString();
    }
}

