/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class SimpleContactPointPlaneBody
implements ContactablePlaneBody {
    private final String name;
    private final RigidBodyBasics rigidBody;
    private final PoseReferenceFrame contactFrame;
    private final List<FramePoint2D> contactPoints = new ArrayList<FramePoint2D>();

    public SimpleContactPointPlaneBody(String name, RigidBodyBasics rigidBody, RigidBodyTransform contactFramePoseInJointFrame) {
        this.name = name;
        this.rigidBody = rigidBody;
        MovingReferenceFrame frameAfterJoint = rigidBody.getParentJoint().getFrameAfterJoint();
        this.contactFrame = new PoseReferenceFrame(name + "Frame", (ReferenceFrame)frameAfterJoint);
        this.contactFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)contactFramePoseInJointFrame);
        this.contactPoints.add(new FramePoint2D((ReferenceFrame)this.contactFrame));
    }

    public String getName() {
        return this.name;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public MovingReferenceFrame getFrameAfterParentJoint() {
        return this.rigidBody.getParentJoint().getFrameAfterJoint();
    }

    public int getTotalNumberOfContactPoints() {
        return 1;
    }

    public List<FramePoint3D> getContactPointsCopy() {
        ArrayList<FramePoint3D> contactPoints = new ArrayList<FramePoint3D>();
        contactPoints.add(new FramePoint3D((ReferenceFrame)this.contactFrame));
        return contactPoints;
    }

    public ReferenceFrame getSoleFrame() {
        return this.contactFrame;
    }

    public List<FramePoint2D> getContactPoints2d() {
        return this.contactPoints;
    }

    public void setSoleFrameTransformFromParentJoint(RigidBodyTransform transform) {
        this.contactFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)transform);
    }
}

