/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.util.List;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointBasics;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public interface PlaneContactState {
    public RigidBodyBasics getRigidBody();

    public ReferenceFrame getFrameAfterParentJoint();

    public ReferenceFrame getPlaneFrame();

    public boolean inContact();

    public FrameVector3D getContactNormalFrameVectorCopy();

    public void getContactNormalFrameVector(FrameVector3D var1);

    public List<FramePoint3D> getContactFramePointsInContactCopy();

    public void getContactFramePointsInContact(List<FramePoint3D> var1);

    public List<FramePoint2D> getContactFramePoints2dInContactCopy();

    public double getCoefficientOfFriction();

    public int getNumberOfContactPointsInContact();

    public int getTotalNumberOfContactPoints();

    public List<? extends ContactPointBasics> getContactPoints();

    public void updateFromPlaneContactStateCommand(PlaneContactStateCommand var1);

    public void getPlaneContactStateCommand(PlaneContactStateCommand var1);

    public void notifyContactStateHasChanged();

    public boolean pollContactHasChangedNotification();

    public boolean peekContactHasChangedNotification();

    public static void enableToeContacts(PlaneContactState contactState) {
        double x;
        int i;
        double maxX = Double.NEGATIVE_INFINITY;
        for (i = 0; i < contactState.getContactPoints().size(); ++i) {
            x = contactState.getContactPoints().get(i).getX();
            maxX = Math.max(maxX, x);
        }
        for (i = 0; i < contactState.getContactPoints().size(); ++i) {
            x = contactState.getContactPoints().get(i).getX();
            contactState.getContactPoints().get(i).setInContact(Precision.equals((double)x, (double)maxX));
        }
        contactState.notifyContactStateHasChanged();
    }

    public static void enableHeelContacts(PlaneContactState contactState) {
        double x;
        int i;
        double minX = Double.POSITIVE_INFINITY;
        for (i = 0; i < contactState.getContactPoints().size(); ++i) {
            x = contactState.getContactPoints().get(i).getX();
            minX = Math.min(minX, x);
        }
        for (i = 0; i < contactState.getContactPoints().size(); ++i) {
            x = contactState.getContactPoints().get(i).getX();
            contactState.getContactPoints().get(i).setInContact(Precision.equals((double)x, (double)minX));
        }
        contactState.notifyContactStateHasChanged();
    }

    public static void enableAllContacts(PlaneContactState contactState) {
        for (int i = 0; i < contactState.getContactPoints().size(); ++i) {
            contactState.getContactPoints().get(i).setInContact(true);
        }
        contactState.notifyContactStateHasChanged();
    }
}

