/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.util.Random;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.RectangularContactableBody;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public class ContactablePlaneBodyTools {
    public static RectangularContactableBody createTypicalContactablePlaneBodyForTests(RigidBodyBasics rigidBody, ReferenceFrame endEffectorFrame) {
        RigidBodyTransform transform3D = new RigidBodyTransform();
        transform3D.getTranslation().set(0.1, 0.2, -0.5);
        transform3D.setRotationPitchAndZeroTranslation(1.5707963267948966);
        ReferenceFrame soleFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(rigidBody.getName() + "SoleFrame"), (ReferenceFrame)endEffectorFrame, (RigidBodyTransformReadOnly)transform3D);
        double forward = 0.2;
        double back = -0.1;
        double left = 0.1;
        double right = -0.15;
        RectangularContactableBody rectangularContactableBody = new RectangularContactableBody(rigidBody, soleFrame, forward, back, left, right);
        return rectangularContactableBody;
    }

    public static RectangularContactableBody createRandomContactablePlaneBodyForTests(Random random, RigidBodyBasics rigidBody) {
        ReferenceFrame endEffectorFrame = ReferenceFrame.getWorldFrame();
        RigidBodyTransform transform3D = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ReferenceFrame soleFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(rigidBody.getName() + "SoleFrame"), (ReferenceFrame)endEffectorFrame, (RigidBodyTransformReadOnly)transform3D);
        double forward = 0.2;
        double back = -0.1;
        double left = 0.1;
        double right = -0.15;
        RectangularContactableBody rectangularContactableBody = new RectangularContactableBody(rigidBody, soleFrame, forward, back, left, right);
        return rectangularContactableBody;
    }
}

