/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.bipedSupportPolygons;

import java.awt.Color;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointBasics;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.desiredFootStep.FootstepListVisualizer;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BipedSupportPolygons {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static boolean VISUALIZE = true;
    private static final int maxNumberOfContactPointsPerFoot = 6;
    private final YoRegistry registry = new YoRegistry("BipedSupportPolygons");
    private final SideDependentList<FixedFrameConvexPolygon2DBasics> footPolygonsInWorldFrame = new SideDependentList();
    private final SideDependentList<FixedFrameConvexPolygon2DBasics> footPolygonsInSoleFrame = new SideDependentList();
    private final SideDependentList<FixedFrameConvexPolygon2DBasics> footPolygonsInSoleZUpFrame = new SideDependentList();
    private final SideDependentList<FixedFrameConvexPolygon2DBasics> footPolygonsInMidFeetZUp = new SideDependentList();
    private final FixedFrameConvexPolygon2DBasics supportPolygonInMidFeetZUp;
    private final FixedFrameConvexPolygon2DBasics supportPolygonInWorld;
    private final YoFrameConvexPolygon2D supportPolygonViz;
    private final SideDependentList<YoFrameConvexPolygon2D> footPolygonsViz = new SideDependentList();
    private final FramePoint3D tempContactPosition = new FramePoint3D();

    public BipedSupportPolygons(CommonHumanoidReferenceFrames referenceFrames, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this((ReferenceFrame)referenceFrames.getMidFeetZUpFrame(), (SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleZUpFrames(), (SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleFrames(), parentRegistry, yoGraphicsListRegistry);
    }

    public BipedSupportPolygons(ReferenceFrame midFeetZUpFrame, SideDependentList<? extends ReferenceFrame> soleZUpFrames, SideDependentList<? extends ReferenceFrame> soleFrames, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.supportPolygonViz = new YoFrameConvexPolygon2D("combinedPolygon", "", worldFrame, 12, this.registry);
        ArtifactList artifactList = new ArtifactList(this.getClass().getSimpleName());
        YoArtifactPolygon supportPolygonArtifact = new YoArtifactPolygon("Combined Polygon", this.supportPolygonViz, Color.pink, false);
        artifactList.add((Artifact)supportPolygonArtifact);
        this.supportPolygonInMidFeetZUp = new FrameConvexPolygon2D(midFeetZUpFrame);
        this.supportPolygonInWorld = new FrameConvexPolygon2D(worldFrame);
        for (RobotSide robotSide : RobotSide.values) {
            this.footPolygonsInWorldFrame.put((Enum)robotSide, (Object)new FrameConvexPolygon2D(worldFrame));
            this.footPolygonsInSoleFrame.put((Enum)robotSide, (Object)new FrameConvexPolygon2D((ReferenceFrame)soleFrames.get((Enum)robotSide)));
            this.footPolygonsInSoleZUpFrame.put((Enum)robotSide, (Object)new FrameConvexPolygon2D((ReferenceFrame)soleZUpFrames.get((Enum)robotSide)));
            this.footPolygonsInMidFeetZUp.put((Enum)robotSide, (Object)new FrameConvexPolygon2D(midFeetZUpFrame));
            String robotSidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            YoFrameConvexPolygon2D footPolygonViz = new YoFrameConvexPolygon2D(robotSidePrefix + "FootPolygon", "", worldFrame, 6, this.registry);
            this.footPolygonsViz.put((Enum)robotSide, (Object)footPolygonViz);
            YoArtifactPolygon footPolygonArtifact = new YoArtifactPolygon(robotSide.getCamelCaseNameForMiddleOfExpression() + " Foot Polygon", footPolygonViz, (Color)FootstepListVisualizer.defaultFeetColors.get((Enum)robotSide), false);
            artifactList.add((Artifact)footPolygonArtifact);
        }
        if (yoGraphicsListRegistry != null) {
            yoGraphicsListRegistry.registerArtifactList(artifactList);
        }
        parentRegistry.addChild(this.registry);
    }

    public void updateUsingContactStates(SideDependentList<? extends PlaneContactState> contactStates) {
        boolean inDoubleSupport = true;
        boolean neitherFootIsSupportingFoot = true;
        RobotSide supportSide = null;
        for (RobotSide robotSide : RobotSide.values) {
            PlaneContactState contactState = (PlaneContactState)contactStates.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInWorldFrame = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInWorldFrame.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInSoleFrame = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInSoleFrame.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInSoleZUpFrame = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInSoleZUpFrame.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInMidFeetZUp = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInMidFeetZUp.get((Enum)robotSide);
            footPolygonInWorldFrame.clearAndUpdate();
            footPolygonInSoleFrame.clearAndUpdate();
            footPolygonInSoleZUpFrame.clearAndUpdate();
            footPolygonInMidFeetZUp.clearAndUpdate();
            if (contactState.inContact()) {
                supportSide = robotSide;
                neitherFootIsSupportingFoot = false;
                for (int i = 0; i < contactState.getTotalNumberOfContactPoints(); ++i) {
                    ContactPointBasics contactPoint = contactState.getContactPoints().get(i);
                    if (!contactPoint.isInContact()) continue;
                    footPolygonInWorldFrame.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                    footPolygonInSoleFrame.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                    footPolygonInSoleZUpFrame.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                    footPolygonInMidFeetZUp.addVertexMatchingFrame((FramePoint3DReadOnly)contactPoint);
                }
                footPolygonInWorldFrame.update();
                footPolygonInSoleFrame.update();
                footPolygonInSoleZUpFrame.update();
                footPolygonInMidFeetZUp.update();
                continue;
            }
            inDoubleSupport = false;
        }
        this.updateSupportPolygon(inDoubleSupport, neitherFootIsSupportingFoot, supportSide);
        if (VISUALIZE) {
            this.visualize();
        }
    }

    public void updateUsingContactStateCommand(SideDependentList<PlaneContactStateCommand> contactStateCommands) {
        boolean inDoubleSupport = true;
        boolean neitherFootIsSupportingFoot = true;
        RobotSide supportSide = null;
        for (RobotSide robotSide : RobotSide.values) {
            PlaneContactStateCommand contactStateCommand = (PlaneContactStateCommand)contactStateCommands.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInWorldFrame = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInWorldFrame.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInSoleFrame = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInSoleFrame.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInSoleZUpFrame = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInSoleZUpFrame.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygonInMidFeetZUp = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInMidFeetZUp.get((Enum)robotSide);
            footPolygonInWorldFrame.clearAndUpdate();
            footPolygonInSoleFrame.clearAndUpdate();
            footPolygonInSoleZUpFrame.clearAndUpdate();
            footPolygonInMidFeetZUp.clearAndUpdate();
            if (!contactStateCommand.isEmpty()) {
                supportSide = robotSide;
                neitherFootIsSupportingFoot = false;
                for (int i = 0; i < contactStateCommand.getNumberOfContactPoints(); ++i) {
                    this.tempContactPosition.setIncludingFrame((FrameTuple3DReadOnly)contactStateCommand.getContactPoint(i));
                    footPolygonInWorldFrame.addVertexMatchingFrame((FramePoint3DReadOnly)this.tempContactPosition);
                    footPolygonInSoleFrame.addVertexMatchingFrame((FramePoint3DReadOnly)this.tempContactPosition);
                    footPolygonInSoleZUpFrame.addVertexMatchingFrame((FramePoint3DReadOnly)this.tempContactPosition);
                    footPolygonInMidFeetZUp.addVertexMatchingFrame((FramePoint3DReadOnly)this.tempContactPosition);
                }
                footPolygonInWorldFrame.update();
                footPolygonInSoleFrame.update();
                footPolygonInSoleZUpFrame.update();
                footPolygonInMidFeetZUp.update();
                continue;
            }
            inDoubleSupport = false;
        }
        this.updateSupportPolygon(inDoubleSupport, neitherFootIsSupportingFoot, supportSide);
        if (VISUALIZE) {
            this.visualize();
        }
    }

    private void updateSupportPolygon(boolean inDoubleSupport, boolean neitherFootIsSupportingFoot, RobotSide supportSide) {
        if (inDoubleSupport) {
            this.supportPolygonInMidFeetZUp.set((FrameVertex2DSupplier)this.footPolygonsInMidFeetZUp.get((Enum)RobotSide.LEFT), (FrameVertex2DSupplier)this.footPolygonsInMidFeetZUp.get((Enum)RobotSide.RIGHT));
        } else if (neitherFootIsSupportingFoot) {
            this.supportPolygonInMidFeetZUp.clearAndUpdate();
        } else {
            this.supportPolygonInMidFeetZUp.set((FrameVertex2DSupplier)this.footPolygonsInMidFeetZUp.get((Enum)supportSide));
        }
        this.supportPolygonInWorld.setMatchingFrame((FrameVertex2DSupplier)this.supportPolygonInMidFeetZUp, true);
    }

    private void visualize() {
        this.supportPolygonViz.set((FrameVertex2DSupplier)this.supportPolygonInWorld);
        for (RobotSide robotSide : RobotSide.values) {
            YoFrameConvexPolygon2D footPolygonViz = (YoFrameConvexPolygon2D)this.footPolygonsViz.get((Enum)robotSide);
            FixedFrameConvexPolygon2DBasics footPolygon = (FixedFrameConvexPolygon2DBasics)this.footPolygonsInWorldFrame.get((Enum)robotSide);
            if (footPolygon.isEmpty()) {
                footPolygonViz.clear();
                continue;
            }
            footPolygonViz.set((FrameVertex2DSupplier)footPolygon);
        }
    }

    public FrameConvexPolygon2DReadOnly getSupportPolygonInMidFeetZUp() {
        return this.supportPolygonInMidFeetZUp;
    }

    public FrameConvexPolygon2DReadOnly getSupportPolygonInWorld() {
        return this.supportPolygonInWorld;
    }

    public FrameConvexPolygon2DReadOnly getFootPolygonInSoleFrame(RobotSide robotSide) {
        return (FrameConvexPolygon2DReadOnly)this.footPolygonsInSoleFrame.get((Enum)robotSide);
    }

    public FrameConvexPolygon2DReadOnly getFootPolygonInSoleZUpFrame(RobotSide robotSide) {
        return (FrameConvexPolygon2DReadOnly)this.footPolygonsInSoleZUpFrame.get((Enum)robotSide);
    }

    public SideDependentList<? extends FrameConvexPolygon2DReadOnly> getFootPolygonsInSoleZUpFrame() {
        return this.footPolygonsInSoleZUpFrame;
    }

    public FrameConvexPolygon2DReadOnly getFootPolygonInWorldFrame(RobotSide robotSide) {
        return (FrameConvexPolygon2DReadOnly)this.footPolygonsInWorldFrame.get((Enum)robotSide);
    }

    public String toString() {
        return "supportPolygonInMidFeetZUp = " + this.supportPolygonInMidFeetZUp;
    }
}

