/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.barrierScheduler.context;

import java.util.Arrays;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.concurrent.runtime.barrierScheduler.implicitContext.tasks.InPlaceCopyable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;

public class HumanoidRobotContextData
implements InPlaceCopyable<HumanoidRobotContextData>,
Settable<HumanoidRobotContextData> {
    private long timestamp = Long.MIN_VALUE;
    private long schedulerTick = Long.MIN_VALUE;
    private final SensorDataContext sensorDataContext;
    private boolean estimatorRan = false;
    private final HumanoidRobotContextJointData processedJointData;
    private final ForceSensorDataHolder forceSensorDataHolder;
    private boolean controllerRan = false;
    private final CenterOfPressureDataHolder centerOfPressureDataHolder;
    private final RobotMotionStatusHolder robotMotionStatusHolder;
    private final LowLevelOneDoFJointDesiredDataHolder jointDesiredOutputList;

    public HumanoidRobotContextData() {
        this.processedJointData = new HumanoidRobotContextJointData();
        this.forceSensorDataHolder = new ForceSensorDataHolder();
        this.centerOfPressureDataHolder = new CenterOfPressureDataHolder();
        this.robotMotionStatusHolder = new RobotMotionStatusHolder();
        this.jointDesiredOutputList = new LowLevelOneDoFJointDesiredDataHolder();
        this.sensorDataContext = new SensorDataContext();
    }

    public HumanoidRobotContextData(HumanoidRobotContextJointData processedJointData, ForceSensorDataHolder forceSensorDataHolder, CenterOfPressureDataHolder centerOfPressureDataHolder, RobotMotionStatusHolder robotMotionStatusHolder, LowLevelOneDoFJointDesiredDataHolder jointDesiredOutputList, SensorDataContext sensorDataContext) {
        this.processedJointData = processedJointData;
        this.forceSensorDataHolder = forceSensorDataHolder;
        this.centerOfPressureDataHolder = centerOfPressureDataHolder;
        this.robotMotionStatusHolder = robotMotionStatusHolder;
        this.jointDesiredOutputList = jointDesiredOutputList;
        this.sensorDataContext = sensorDataContext;
    }

    public HumanoidRobotContextData(FullHumanoidRobotModel fullRobotModel) {
        this.processedJointData = new HumanoidRobotContextJointData(fullRobotModel.getOneDoFJoints().length);
        this.forceSensorDataHolder = new ForceSensorDataHolder(Arrays.asList(fullRobotModel.getForceSensorDefinitions()));
        this.centerOfPressureDataHolder = new CenterOfPressureDataHolder(fullRobotModel);
        this.robotMotionStatusHolder = new RobotMotionStatusHolder();
        this.jointDesiredOutputList = new LowLevelOneDoFJointDesiredDataHolder((OneDoFJointReadOnly[])fullRobotModel.getControllableOneDoFJoints());
        this.sensorDataContext = new SensorDataContext((FullRobotModel)fullRobotModel);
    }

    public HumanoidRobotContextJointData getProcessedJointData() {
        return this.processedJointData;
    }

    public ForceSensorDataHolder getForceSensorDataHolder() {
        return this.forceSensorDataHolder;
    }

    public CenterOfPressureDataHolder getCenterOfPressureDataHolder() {
        return this.centerOfPressureDataHolder;
    }

    public RobotMotionStatusHolder getRobotMotionStatusHolder() {
        return this.robotMotionStatusHolder;
    }

    public LowLevelOneDoFJointDesiredDataHolder getJointDesiredOutputList() {
        return this.jointDesiredOutputList;
    }

    public SensorDataContext getSensorDataContext() {
        return this.sensorDataContext;
    }

    public void set(HumanoidRobotContextData other) {
        this.copyFrom(other);
    }

    public void copyFrom(HumanoidRobotContextData src) {
        this.timestamp = src.timestamp;
        this.schedulerTick = src.schedulerTick;
        this.controllerRan = src.controllerRan;
        this.estimatorRan = src.estimatorRan;
        this.processedJointData.set(src.processedJointData);
        this.forceSensorDataHolder.set(src.forceSensorDataHolder);
        this.centerOfPressureDataHolder.set(src.centerOfPressureDataHolder);
        this.robotMotionStatusHolder.set(src.robotMotionStatusHolder);
        this.jointDesiredOutputList.set(src.jointDesiredOutputList);
        this.sensorDataContext.set(src.sensorDataContext);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getSchedulerTick() {
        return this.schedulerTick;
    }

    public void setSchedulerTick(long schedulerTick) {
        this.schedulerTick = schedulerTick;
    }

    public void setControllerRan(boolean controllerRan) {
        this.controllerRan = controllerRan;
    }

    public boolean getControllerRan() {
        return this.controllerRan;
    }

    public void setEstimatorRan(boolean estimatorRan) {
        this.estimatorRan = estimatorRan;
    }

    public boolean getEstimatorRan() {
        return this.estimatorRan;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HumanoidRobotContextData) {
            HumanoidRobotContextData other = (HumanoidRobotContextData)obj;
            if (this.timestamp != other.timestamp) {
                return false;
            }
            if (this.schedulerTick != other.schedulerTick) {
                return false;
            }
            if (this.controllerRan ^ other.controllerRan) {
                return false;
            }
            if (this.estimatorRan ^ other.estimatorRan) {
                return false;
            }
            if (!this.processedJointData.equals(other.processedJointData)) {
                return false;
            }
            if (!this.forceSensorDataHolder.equals((Object)other.forceSensorDataHolder)) {
                return false;
            }
            if (!this.centerOfPressureDataHolder.equals((Object)other.centerOfPressureDataHolder)) {
                return false;
            }
            if (!this.robotMotionStatusHolder.equals((Object)other.robotMotionStatusHolder)) {
                return false;
            }
            if (!this.jointDesiredOutputList.equals((JointDesiredOutputListReadOnly)other.jointDesiredOutputList)) {
                return false;
            }
            return this.sensorDataContext.equals((Object)other.sensorDataContext);
        }
        return false;
    }
}

