/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.state.implementations;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JointState
extends State {
    public static final int size = 3;
    private final String jointName;
    private final DMatrixRMaj stateVector = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj tempStateVector = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj F = new DMatrixRMaj(3, 3);
    private final DoubleProvider accelerationVariance;
    private final double sqrtHz;
    private final DMatrixRMaj Qref = new DMatrixRMaj(3, 3);

    public JointState(String jointName, double dt, YoRegistry registry) {
        this(jointName, FilterTools.stringToPrefix(jointName), dt, registry);
    }

    public JointState(String jointName, String parameterGroup, double dt, YoRegistry registry) {
        this.jointName = jointName;
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.F);
        this.F.set(0, 1, dt);
        this.F.set(0, 2, 0.5 * dt * dt);
        this.F.set(1, 2, dt);
        FilterTools.packQref(dt, (DMatrix1Row)this.Qref, 1);
        this.accelerationVariance = FilterTools.findOrCreate(parameterGroup + "AccelerationVariance", registry, 1.0);
    }

    public void initialize(double initialPosition, double initialVelocity) {
        this.stateVector.set(0, initialPosition);
        this.stateVector.set(1, initialVelocity);
        this.stateVector.set(2, 0.0);
    }

    public String getJointName() {
        return this.jointName;
    }

    @Override
    public String getName() {
        return this.getJointName();
    }

    @Override
    public void setStateVector(DMatrix1Row newState) {
        FilterTools.checkVectorDimensions(newState, (DMatrix1Row)this.stateVector);
        System.arraycopy(newState.data, 0, this.stateVector.data, 0, this.getSize());
    }

    @Override
    public void getStateVector(DMatrix1Row vectorToPack) {
        vectorToPack.set((DMatrixD1)this.stateVector);
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public void predict() {
        this.tempStateVector.set((DMatrixD1)this.stateVector);
        CommonOps_DDRM.mult((DMatrix1Row)this.F, (DMatrix1Row)this.tempStateVector, (DMatrix1Row)this.stateVector);
    }

    @Override
    public void getFMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.set((DMatrixD1)this.F);
    }

    @Override
    public void getQMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.set((DMatrixD1)this.Qref);
        CommonOps_DDRM.scale((double)(this.accelerationVariance.getValue() * this.sqrtHz), (DMatrixD1)matrixToPack);
    }

    public double getQ() {
        return this.stateVector.get(0);
    }

    public double getQd() {
        return this.stateVector.get(1);
    }

    public double getQdd() {
        return this.stateVector.get(2);
    }
}

