/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor.implementations;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.ekf.filter.state.implementations.BiasState;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LinearAccelerationSensor
extends Sensor {
    private static final int measurementSize = 3;
    private final BiasState biasState;
    private final GeometricJacobianCalculator robotJacobian = new GeometricJacobianCalculator();
    private final List<String> oneDofJointNames = new ArrayList<String>();
    private final ReferenceFrame measurementFrame;
    private final FrameVector3D measurement = new FrameVector3D();
    private final double dt;
    private final double sqrtHz;
    private boolean hasBeenCalled = false;
    private final DoubleProvider variance;
    private final DMatrixRMaj tempRobotState = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jacobianMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jacobianAngularPart = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jacobianLinearPart = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj qd = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj qdd = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jointAccelerationTerm = new DMatrixRMaj(6, 1);
    private final FrameVector3DBasics linearJointTerm = new FrameVector3D();
    private final DMatrixRMaj convectiveTerm = new DMatrixRMaj(6, 1);
    private final FrameVector3DBasics linearConvectiveTerm = new FrameVector3D();
    private final Twist sensorTwist = new Twist();
    private final FrameVector3DBasics sensorAngularVelocity = new FrameVector3D();
    private final FrameVector3DBasics sensorLinearVelocity = new FrameVector3D();
    private final FrameVector3DBasics centrifugalTerm = new FrameVector3D();
    private final FrameVector3DBasics gravityTerm = new FrameVector3D();
    private final DMatrixRMaj linearJointTermLinearization = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj previousJacobianMatrixLinearPart = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jacobianDotLinearPart = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj convectiveTermLinearization = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj crossProductLinearization = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj centrifugalTermLinearization = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj gravityTermLinearization = new DMatrixRMaj(0, 0);
    private final Matrix3D gravityPart = new Matrix3D();
    private final RigidBodyTransform rootToMeasurement = new RigidBodyTransform();
    private final RigidBodyTransform rootTransform = new RigidBodyTransform();
    private final Vector3D Aqd = new Vector3D();
    private final Vector3D Lqd = new Vector3D();
    private final Matrix3D Aqdx_matrix = new Matrix3D();
    private final Matrix3D Lqdx_matrix = new Matrix3D();
    private final DMatrixRMaj Aqdx = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj Lqdx = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj tempResult = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj AqdxL = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj LqdxA = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj biasStateJacobian = new DMatrixRMaj(0, 0);
    private final String name;

    public LinearAccelerationSensor(String sensorName, double dt, RigidBodyBasics body, ReferenceFrame measurementFrame, boolean estimateBias, YoRegistry registry) {
        this.dt = dt;
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.measurementFrame = measurementFrame;
        this.name = sensorName;
        this.robotJacobian.setKinematicChain((RigidBodyReadOnly)MultiBodySystemTools.getRootBody((RigidBodyBasics)body), (RigidBodyReadOnly)body);
        this.robotJacobian.setJacobianFrame(measurementFrame);
        List oneDofJoints = MultiBodySystemTools.filterJoints((List)this.robotJacobian.getJointsFromBaseToEndEffector(), OneDoFJointBasics.class);
        oneDofJoints.stream().forEach(joint -> this.oneDofJointNames.add(joint.getName()));
        this.variance = FilterTools.findOrCreate(sensorName + "Variance", registry, 1.0);
        if (estimateBias) {
            this.biasState = new BiasState(sensorName, dt, registry);
            FilterTools.setIdentity((DMatrix1Row)this.biasStateJacobian, 3);
        } else {
            this.biasState = null;
        }
        int degreesOfFreedom = this.robotJacobian.getNumberOfDegreesOfFreedom();
        this.jacobianAngularPart.reshape(3, degreesOfFreedom);
        this.jacobianLinearPart.reshape(3, degreesOfFreedom);
        this.jacobianDotLinearPart.reshape(3, degreesOfFreedom);
        this.crossProductLinearization.reshape(3, degreesOfFreedom);
        this.AqdxL.reshape(3, degreesOfFreedom);
        this.LqdxA.reshape(3, degreesOfFreedom);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public State getSensorState() {
        return this.biasState == null ? super.getSensorState() : this.biasState;
    }

    @Override
    public int getMeasurementSize() {
        return 3;
    }

    @Override
    public void getMeasurementJacobian(DMatrix1Row jacobianToPack, RobotState robotState) {
        robotState.getStateVector((DMatrix1Row)this.tempRobotState);
        this.robotJacobian.reset();
        this.jacobianMatrix.set((DMatrixD1)this.robotJacobian.getJacobianMatrix());
        CommonOps_DDRM.extract((DMatrix)this.jacobianMatrix, (int)0, (int)3, (int)0, (int)this.jacobianMatrix.getNumCols(), (DMatrix)this.jacobianAngularPart, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.jacobianMatrix, (int)3, (int)6, (int)0, (int)this.jacobianMatrix.getNumCols(), (DMatrix)this.jacobianLinearPart, (int)0, (int)0);
        this.linearJointTermLinearization.reshape(this.jacobianLinearPart.getNumRows(), robotState.getSize());
        this.linearJointTermLinearization.zero();
        FilterTools.insertForAcceleration((DMatrix1Row)this.linearJointTermLinearization, this.oneDofJointNames, (DMatrix1Row)this.jacobianLinearPart, robotState);
        if (!this.hasBeenCalled) {
            this.jacobianDotLinearPart.zero();
            this.hasBeenCalled = true;
        } else {
            CommonOps_DDRM.subtract((DMatrixD1)this.jacobianLinearPart, (DMatrixD1)this.previousJacobianMatrixLinearPart, (DMatrixD1)this.jacobianDotLinearPart);
            CommonOps_DDRM.scale((double)(1.0 / this.dt), (DMatrixD1)this.jacobianDotLinearPart);
        }
        this.convectiveTermLinearization.reshape(this.jacobianDotLinearPart.getNumRows(), robotState.getSize());
        this.convectiveTermLinearization.zero();
        FilterTools.insertForVelocity((DMatrix1Row)this.convectiveTermLinearization, this.oneDofJointNames, (DMatrix1Row)this.jacobianDotLinearPart, robotState);
        this.previousJacobianMatrixLinearPart.set((DMatrixD1)this.jacobianLinearPart);
        FilterTools.packQd((DMatrix1Row)this.qd, this.oneDofJointNames, (DMatrix1Row)this.tempRobotState, robotState);
        this.linearizeCrossProduct((DMatrix1Row)this.jacobianAngularPart, (DMatrix1Row)this.jacobianLinearPart, (DMatrix1Row)this.qd, (DMatrix1Row)this.crossProductLinearization);
        this.centrifugalTermLinearization.reshape(this.crossProductLinearization.getNumRows(), robotState.getSize());
        this.centrifugalTermLinearization.zero();
        FilterTools.insertForVelocity((DMatrix1Row)this.centrifugalTermLinearization, this.oneDofJointNames, (DMatrix1Row)this.crossProductLinearization, robotState);
        this.gravityTermLinearization.reshape(3, robotState.getSize());
        this.gravityTermLinearization.zero();
        if (robotState.isFloating()) {
            MovingReferenceFrame rootFrame = ((JointReadOnly)this.robotJacobian.getJointsFromBaseToEndEffector().get(0)).getFrameAfterJoint();
            MovingReferenceFrame baseFrame = ((JointReadOnly)this.robotJacobian.getJointsFromBaseToEndEffector().get(0)).getFrameBeforeJoint();
            rootFrame.getTransformToDesiredFrame(this.rootToMeasurement, this.measurementFrame);
            baseFrame.getTransformToDesiredFrame(this.rootTransform, (ReferenceFrame)rootFrame);
            this.gravityTerm.setIncludingFrame(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -robotState.getGravity());
            this.gravityTerm.changeFrame(this.measurementFrame);
            this.gravityPart.setToTildeForm((Tuple3DReadOnly)this.gravityTerm);
            this.gravityPart.multiply((Matrix3DReadOnly)this.rootToMeasurement.getRotation());
            this.gravityPart.multiply((Matrix3DReadOnly)this.rootTransform.getRotation());
            this.gravityPart.get(0, robotState.findOrientationIndex(), (DMatrix)this.gravityTermLinearization);
        }
        jacobianToPack.set((DMatrixD1)this.linearJointTermLinearization);
        CommonOps_DDRM.add((DMatrixD1)jacobianToPack, (DMatrixD1)this.convectiveTermLinearization, (DMatrixD1)jacobianToPack);
        CommonOps_DDRM.add((DMatrixD1)jacobianToPack, (DMatrixD1)this.centrifugalTermLinearization, (DMatrixD1)jacobianToPack);
        CommonOps_DDRM.add((DMatrixD1)jacobianToPack, (DMatrixD1)this.gravityTermLinearization, (DMatrixD1)jacobianToPack);
        if (this.biasState != null) {
            int biasStartIndex = robotState.getStartIndex(this.biasState);
            CommonOps_DDRM.insert((DMatrix)this.biasStateJacobian, (DMatrix)jacobianToPack, (int)0, (int)biasStartIndex);
        }
    }

    @Override
    public void getResidual(DMatrix1Row residualToPack, RobotState robotState) {
        robotState.getStateVector((DMatrix1Row)this.tempRobotState);
        this.robotJacobian.reset();
        this.jacobianMatrix.set((DMatrixD1)this.robotJacobian.getJacobianMatrix());
        FilterTools.packQdd((DMatrix1Row)this.qdd, this.oneDofJointNames, (DMatrix1Row)this.tempRobotState, robotState);
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobianMatrix, (DMatrix1Row)this.qdd, (DMatrix1Row)this.jointAccelerationTerm);
        this.linearJointTerm.setIncludingFrame(this.measurementFrame, 3, (DMatrix)this.jointAccelerationTerm);
        this.convectiveTerm.set((DMatrixD1)this.robotJacobian.getConvectiveTermMatrix());
        this.linearConvectiveTerm.setIncludingFrame(this.measurementFrame, 3, (DMatrix)this.convectiveTerm);
        this.robotJacobian.getEndEffector().getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.sensorTwist);
        this.sensorTwist.changeFrame(this.measurementFrame);
        this.centrifugalTerm.setToZero(this.measurementFrame);
        this.sensorAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.sensorTwist.getAngularPart());
        this.sensorLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.sensorTwist.getLinearPart());
        this.centrifugalTerm.cross((FrameVector3DReadOnly)this.sensorAngularVelocity, (FrameVector3DReadOnly)this.sensorLinearVelocity);
        this.gravityTerm.setIncludingFrame(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -robotState.getGravity());
        this.gravityTerm.changeFrame(this.measurementFrame);
        residualToPack.reshape(3, 1);
        residualToPack.set(0, this.measurement.getX() - this.linearJointTerm.getX() - this.linearConvectiveTerm.getX() - this.centrifugalTerm.getX() - this.gravityTerm.getX());
        residualToPack.set(1, this.measurement.getY() - this.linearJointTerm.getY() - this.linearConvectiveTerm.getY() - this.centrifugalTerm.getY() - this.gravityTerm.getY());
        residualToPack.set(2, this.measurement.getZ() - this.linearJointTerm.getZ() - this.linearConvectiveTerm.getZ() - this.centrifugalTerm.getZ() - this.gravityTerm.getZ());
        if (this.biasState != null) {
            residualToPack.set(0, residualToPack.get(0) - this.biasState.getBias(0));
            residualToPack.set(1, residualToPack.get(1) - this.biasState.getBias(1));
            residualToPack.set(2, residualToPack.get(2) - this.biasState.getBias(2));
        }
    }

    @Override
    public void getRMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(3, 3);
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)(this.variance.getValue() * this.sqrtHz), (DMatrixD1)matrixToPack);
    }

    public void setMeasurement(Vector3DReadOnly measurement) {
        this.measurement.setIncludingFrame(this.robotJacobian.getJacobianFrame(), (Tuple3DReadOnly)measurement);
    }

    public void linearizeCrossProduct(DMatrix1Row A, DMatrix1Row L, DMatrix1Row qd0, DMatrix1Row matrixToPack) {
        CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)qd0, (DMatrix1Row)this.tempResult);
        this.Aqd.set((DMatrix)this.tempResult);
        CommonOps_DDRM.mult((DMatrix1Row)L, (DMatrix1Row)qd0, (DMatrix1Row)this.tempResult);
        this.Lqd.set((DMatrix)this.tempResult);
        this.Aqdx_matrix.setToTildeForm((Tuple3DReadOnly)this.Aqd);
        this.Lqdx_matrix.setToTildeForm((Tuple3DReadOnly)this.Lqd);
        this.Aqdx_matrix.get((DMatrix)this.Aqdx);
        this.Lqdx_matrix.get((DMatrix)this.Lqdx);
        CommonOps_DDRM.mult((DMatrix1Row)this.Aqdx, (DMatrix1Row)L, (DMatrix1Row)this.AqdxL);
        CommonOps_DDRM.mult((DMatrix1Row)this.Lqdx, (DMatrix1Row)A, (DMatrix1Row)this.LqdxA);
        CommonOps_DDRM.subtract((DMatrixD1)this.AqdxL, (DMatrixD1)this.LqdxA, (DMatrixD1)matrixToPack);
    }

    public void resetBias() {
        if (this.biasState != null) {
            this.biasState.reset();
        }
    }
}

