/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor.implementations;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.sensor.implementations.LinearVelocitySensor;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FootVelocitySensor
extends LinearVelocitySensor {
    private final double sqrtHz;
    private final DoubleProvider maxVariance;
    private final DoubleProvider minVariance;
    private final DoubleProvider weightFractionForFullTrust;
    private final DoubleProvider weightFractionForNoTrust;
    private final YoDouble loadPercentage;
    private final YoDouble variance;

    public FootVelocitySensor(double dt, RigidBodyBasics foot, ReferenceFrame measurementFrame, YoRegistry registry) {
        this(dt, foot, measurementFrame, FilterTools.stringToPrefix(foot.getName()), registry);
    }

    public FootVelocitySensor(double dt, RigidBodyBasics foot, ReferenceFrame measurementFrame, String parameterGroup, YoRegistry registry) {
        super(FilterTools.stringToPrefix(foot.getName()) + "Velocity", dt, foot, measurementFrame, false, (DoubleProvider)null, registry);
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.weightFractionForFullTrust = FilterTools.findOrCreate(parameterGroup + "WeightFractionForFullTrust", registry, 0.5);
        this.weightFractionForNoTrust = FilterTools.findOrCreate(parameterGroup + "WeightFractionForNoTrust", registry, 0.05);
        this.maxVariance = FilterTools.findOrCreate(parameterGroup + "MaxVariance", registry, 1.0E10);
        this.minVariance = FilterTools.findOrCreate(parameterGroup + "MinVariance", registry, 0.01);
        String footName = FilterTools.stringToPrefix(foot.getName());
        this.loadPercentage = new YoDouble(footName + "LoadPercentage", registry);
        this.variance = new YoDouble(footName + "Variance", registry);
    }

    public void setLoad(double loadPercentage) {
        this.loadPercentage.set(loadPercentage);
    }

    @Override
    public void setMeasurement(Vector3DReadOnly measurement) {
        throw new RuntimeException("Setting a velocity measurement on " + this.getClass().getSimpleName() + " is not supported.");
    }

    @Override
    public void getRMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(this.getMeasurementSize(), this.getMeasurementSize());
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
        double percent = (this.loadPercentage.getValue() - this.weightFractionForNoTrust.getValue()) / (this.weightFractionForFullTrust.getValue() - this.weightFractionForNoTrust.getValue());
        percent = MathTools.clamp((double)percent, (double)0.0, (double)1.0);
        this.variance.set(this.maxVariance.getValue() - percent * (this.maxVariance.getValue() - this.minVariance.getValue()));
        CommonOps_DDRM.scale((double)(this.variance.getValue() * this.sqrtHz), (DMatrixD1)matrixToPack);
    }
}

