/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter;

import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commons.Conversions;
import us.ihmc.ekf.filter.NativeFilterMatrixOps;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.ComposedSensor;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class StateEstimator {
    private final RobotState robotState;
    private final ComposedSensor sensor = new ComposedSensor("ComposedSensor");
    private final YoDouble predictionTime;
    private final YoDouble correctionTime;
    private final DMatrixRMaj F = new DMatrixRMaj(0);
    private final DMatrixRMaj Q = new DMatrixRMaj(0);
    private final DMatrixRMaj H = new DMatrixRMaj(0);
    private final DMatrixRMaj R = new DMatrixRMaj(0);
    private final DMatrixRMaj K = new DMatrixRMaj(0);
    private final DMatrixRMaj residual = new DMatrixRMaj(0);
    private final DMatrixRMaj Xprior = new DMatrixRMaj(0);
    private final DMatrixRMaj Pprior = new DMatrixRMaj(0);
    private final DMatrixRMaj Xposterior = new DMatrixRMaj(0);
    private final DMatrixRMaj Pposterior = new DMatrixRMaj(0);

    public StateEstimator(List<Sensor> sensors, RobotState robotState, YoRegistry registry) {
        this.robotState = robotState;
        sensors.forEach(s -> this.sensor.addSensor((Sensor)s));
        robotState.addState(this.sensor.getSensorState());
        this.Pposterior.reshape(robotState.getSize(), robotState.getSize());
        this.reset();
        this.predictionTime = new YoDouble("PredictionTimeMs", registry);
        this.correctionTime = new YoDouble("CorrectionTimeMs", registry);
    }

    public void reset() {
        this.Pposterior.zero();
    }

    public void predict() {
        long startTime = System.nanoTime();
        this.robotState.predict();
        this.robotState.getFMatrix((DMatrix1Row)this.F);
        this.robotState.getQMatrix((DMatrix1Row)this.Q);
        NativeFilterMatrixOps.predictErrorCovariance((DMatrix1Row)this.Pprior, (DMatrix1Row)this.F, (DMatrix1Row)this.Pposterior, (DMatrix1Row)this.Q);
        this.predictionTime.set(Conversions.nanosecondsToMilliseconds((double)(System.nanoTime() - startTime)));
    }

    public void correct() {
        long startTime = System.nanoTime();
        this.sensor.getMeasurementJacobian((DMatrix1Row)this.H, this.robotState);
        this.sensor.getResidual((DMatrix1Row)this.residual, this.robotState);
        this.sensor.getRMatrix((DMatrix1Row)this.R);
        NativeFilterMatrixOps.computeKalmanGain((DMatrix1Row)this.K, (DMatrix1Row)this.Pprior, (DMatrix1Row)this.H, (DMatrix1Row)this.R);
        this.robotState.getStateVector((DMatrix1Row)this.Xprior);
        NativeFilterMatrixOps.updateState((DMatrix1Row)this.Xposterior, (DMatrix1Row)this.Xprior, (DMatrix1Row)this.K, (DMatrix1Row)this.residual);
        NativeFilterMatrixOps.updateErrorCovariance((DMatrix1Row)this.Pposterior, (DMatrix1Row)this.K, (DMatrix1Row)this.H, (DMatrix1Row)this.Pprior);
        this.robotState.setStateVector((DMatrix1Row)this.Xposterior);
        this.correctionTime.set(Conversions.nanosecondsToMilliseconds((double)(System.nanoTime() - startTime)));
    }

    public void getCovariance(DMatrix1Row covarianceToPack) {
        covarianceToPack.set((DMatrixD1)this.Pposterior);
    }
}

