/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter;

public interface RobotStateIndexProvider {
    public int getSize();

    public boolean isFloating();

    public int getJointStartIndex(String var1);

    default public int findJointPositionIndex(String jointName) {
        return this.getJointStartIndex(jointName);
    }

    default public int findJointVelocityIndex(String jointName) {
        return this.getJointStartIndex(jointName) + 1;
    }

    default public int findJointAccelerationIndex(String jointName) {
        return this.getJointStartIndex(jointName) + 2;
    }

    default public int findOrientationIndex() {
        this.checkFloating();
        return 0;
    }

    default public int findAngularVelocityIndex() {
        this.checkFloating();
        return 3;
    }

    default public int findAngularAccelerationIndex() {
        this.checkFloating();
        return 6;
    }

    default public int findPositionIndex() {
        this.checkFloating();
        return 9;
    }

    default public int findLinearVelocityIndex() {
        this.checkFloating();
        return 12;
    }

    default public int findLinearAccelerationIndex() {
        this.checkFloating();
        return 15;
    }

    default public void checkFloating() {
        if (!this.isFloating()) {
            throw new RuntimeException("Robot is not a floating base robot. Can not get pose indices.");
        }
    }
}

