/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.gla.terrier.jtreceval;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class trec_eval {
    static boolean DELETE = true;
    static File trec_eval_temp = null;
    static Map<String, String[]> LIB_DEPENDENCIES = new HashMap<String, String[]>();
    static Map<String, String[]> FILE_DEPENDENCIES = new HashMap<String, String[]>();
    File ourTE;
    int exit = Integer.MAX_VALUE;

    static String getOSShort() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return "win";
        }
        if (osName.startsWith("Linux")) {
            return "linux";
        }
        if (osName.equals("Mac OS X")) {
            return "macosx";
        }
        throw new UnsupportedOperationException("Unsupported os: " + osName);
    }

    public static boolean isPlatformSupported() {
        String execName = trec_eval.getExecName();
        if (trec_eval.class.getClassLoader().getResource(execName) == null) {
            return false;
        }
        for (String f : FILE_DEPENDENCIES.getOrDefault(execName, new String[0])) {
            if (new File(f).exists()) continue;
            return false;
        }
        return true;
    }

    static File getTrecEvalBinary() {
        if (trec_eval_temp != null) {
            return trec_eval_temp;
        }
        String resName = trec_eval.getExecName();
        if (trec_eval.class.getClassLoader().getResource(resName) == null) {
            throw new UnsupportedOperationException("Unsupported os/arch: " + resName);
        }
        File tempExec = null;
        try {
            String[] libs;
            Path tempExecDir = Files.createTempDirectory("jtrec_eval", new FileAttribute[0]);
            if (DELETE) {
                tempExecDir.toFile().deleteOnExit();
            }
            tempExec = File.createTempFile("trec_eval", ".exe", tempExecDir.toFile());
            InputStream in = trec_eval.class.getClassLoader().getResourceAsStream(resName);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempExec));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            ((OutputStream)out).close();
            tempExec.setExecutable(true);
            if (DELETE) {
                tempExec.deleteOnExit();
            }
            if ((libs = LIB_DEPENDENCIES.get(resName)) != null) {
                for (String lib : libs) {
                    File tmpLib = new File(tempExecDir.toFile(), lib);
                    in = trec_eval.class.getClassLoader().getResourceAsStream(lib);
                    out = new BufferedOutputStream(new FileOutputStream(tmpLib));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    in.close();
                    ((OutputStream)out).close();
                    if (!DELETE) continue;
                    tmpLib.deleteOnExit();
                }
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        assert (tempExec.exists()) : "Exe file " + tempExec.toString() + " does not exist after creation";
        return tempExec;
    }

    protected static String getExecName() {
        return "trec_eval-" + trec_eval.getOSShort() + "-" + System.getProperty("os.arch");
    }

    public trec_eval() {
        this.ourTE = trec_eval.getTrecEvalBinary();
    }

    ProcessBuilder getBuilder(String[] args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.ourTE.getAbsolutePath().toString());
        for (String arg : args) {
            cmd.add(arg);
        }
        return new ProcessBuilder(cmd);
    }

    public String[][] runAndGetOutput(String[] args) {
        ArrayList<String[]> output = new ArrayList<String[]>();
        try {
            ProcessBuilder pb = this.getBuilder(args);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            InputStream in = p.getInputStream();
            LineIterator it = IOUtils.lineIterator((Reader)new InputStreamReader(in));
            while (it.hasNext()) {
                output.add(it.next().split("\\s+"));
            }
            p.waitFor();
            this.exit = p.exitValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.exit != 0) {
            throw new RuntimeException("trec_eval ended with non-zero exit code (" + this.exit + ")");
        }
        return (String[][])output.toArray((T[])new String[output.size()][]);
    }

    public int getLastExitCode() {
        return this.exit;
    }

    public int run(String[] args) {
        try {
            boolean windowsJVMRedirectBug;
            ProcessBuilder pb = this.getBuilder(args);
            boolean bl = windowsJVMRedirectBug = System.getProperty("java.specification.version").equals("1.7") && System.getProperty("os.name").startsWith("Windows");
            if (!windowsJVMRedirectBug) {
                pb.inheritIO();
            }
            Thread t1 = null;
            Thread t2 = null;
            Process p = pb.start();
            if (windowsJVMRedirectBug) {
                t1 = trec_eval.inheritIO(p.getInputStream(), System.out);
                t2 = trec_eval.inheritIO(p.getErrorStream(), System.err);
            }
            p.waitFor();
            this.exit = p.exitValue();
            if (windowsJVMRedirectBug) {
                assert (t1 != null);
                assert (t2 != null);
                t1.join();
                t2.join();
            }
        }
        catch (IOException e) {
            System.err.println(e);
            if (e.getMessage().contains("No such file or directory")) {
                System.err.println("Your OS may not have the necessary libraries installed. We expected: " + Arrays.toString(FILE_DEPENDENCIES.getOrDefault(trec_eval.getExecName(), new String[0])));
            }
            e.printStackTrace();
            this.exit = -1;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            this.exit = -1;
        }
        return this.exit;
    }

    private static Thread inheritIO(final InputStream src, final PrintStream dest) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    dest.println(sc.nextLine());
                }
                sc.close();
            }
        });
        t.start();
        return t;
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--checkplatform")) {
            System.out.println("Platform supported: " + trec_eval.isPlatformSupported());
            return;
        }
        System.exit(new trec_eval().run(args));
    }

    static {
        LIB_DEPENDENCIES.put("trec_eval-win-x86", new String[]{"cygwin1.dll"});
        LIB_DEPENDENCIES.put("trec_eval-win-amd64", new String[]{"cygwin1.dll"});
        FILE_DEPENDENCIES.put("trec_eval-linux-amd64", new String[]{"/lib64/ld-linux-x86-64.so.2"});
        FILE_DEPENDENCIES.put("trec_eval-linux-i386", new String[]{"/lib/libm.so.6"});
        FILE_DEPENDENCIES.put("trec_eval-linux-i386", new String[]{"/lib/libc.so.6"});
    }
}

