/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import one.nio.util.Hex;

public final class URLEncoder {
    private static final String SAFE_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!*'()";
    private static final boolean[] IS_SAFE_CHAR = new boolean[128];

    public static String encode(String url) {
        int length = url.length();
        int specialChars = 0;
        for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            if (c >= '\u0080') {
                specialChars += c <= '\u0fff' ? 5 : 8;
                continue;
            }
            if (IS_SAFE_CHAR[c]) continue;
            specialChars += 2;
        }
        if (specialChars == 0) {
            return url;
        }
        char[] chars = new char[length + specialChars];
        int p = 0;
        for (int i = 0; i < length; ++i) {
            char c = url.charAt(i);
            if (c >= '\u0080') {
                if (c <= '\u0fff') {
                    URLEncoder.encodeByte(chars, p, 0xC0 | c >>> 6 & 0x1F);
                    URLEncoder.encodeByte(chars, p + 3, 0x80 | c & 0x3F);
                    p += 6;
                    continue;
                }
                URLEncoder.encodeByte(chars, p, 0xE0 | c >>> 12 & 0xF);
                URLEncoder.encodeByte(chars, p + 3, 0x80 | c >>> 6 & 0x3F);
                URLEncoder.encodeByte(chars, p + 6, 0x80 | c & 0x3F);
                p += 9;
                continue;
            }
            if (!IS_SAFE_CHAR[c]) {
                URLEncoder.encodeByte(chars, p, c);
                p += 3;
                continue;
            }
            chars[p++] = c;
        }
        return new String(chars);
    }

    public static String decode(String url) {
        int i = url.indexOf(37);
        int j = url.indexOf(43);
        if (i < 0 && j < 0) {
            return url;
        }
        char[] chars = url.toCharArray();
        while (j >= 0) {
            chars[j] = 32;
            j = url.indexOf(43, j + 1);
        }
        if (i < 0) {
            return new String(chars);
        }
        try {
            int p = i;
            while (i + 3 <= chars.length) {
                int c2;
                int c1 = URLEncoder.decodeByte(chars, i);
                if (c1 <= 127) {
                    chars[p] = (char)c1;
                    i += 3;
                } else if ((c1 & 0xE0) == 192 && i + 6 <= chars.length && chars[i + 3] == '%') {
                    c2 = URLEncoder.decodeByte(chars, i + 3);
                    chars[p] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                    i += 6;
                } else if (i + 9 <= chars.length && chars[i + 3] == '%' && chars[i + 6] == '%') {
                    c2 = URLEncoder.decodeByte(chars, i + 3);
                    int c3 = URLEncoder.decodeByte(chars, i + 6);
                    chars[p] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    i += 9;
                } else {
                    chars[p] = 37;
                    ++i;
                }
                ++p;
                while (i < chars.length && chars[i] != '%') {
                    chars[p++] = chars[i++];
                }
            }
            return new String(chars, 0, p);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
    }

    private static void encodeByte(char[] chars, int p, int value) {
        chars[p] = 37;
        chars[p + 1] = Hex.CAPITAL[value >>> 4];
        chars[p + 2] = Hex.CAPITAL[value & 0xF];
    }

    private static int decodeByte(char[] chars, int p) {
        return Hex.DIGIT_VALUE[chars[p + 1]] << 4 | Hex.DIGIT_VALUE[chars[p + 2]];
    }

    static {
        int length = SAFE_CHARS.length();
        for (int i = 0; i < length; ++i) {
            URLEncoder.IS_SAFE_CHAR[SAFE_CHARS.charAt((int)i)] = true;
        }
    }
}

