/*
 * Decompiled with CFR 0.152.
 */
package one.nio.util;

import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import one.nio.util.JavaInternals;

public class MethodHandlesReflection {
    public static final MethodHandles.Lookup privateLookup = MethodHandlesReflection.getPrivateLookup();

    private static MethodHandles.Lookup getPrivateLookup() {
        try {
            return (MethodHandles.Lookup)JavaInternals.getField(MethodHandles.Lookup.class, "IMPL_LOOKUP").get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static MethodHandleInfo findInstanceMethod(Class<?> cls, String name, MethodType type) {
        try {
            return MethodHandlesReflection.findInstanceMethodOrThrow(cls, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static MethodHandleInfo findInstanceMethodOrThrow(Class<?> cls, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        return privateLookup.revealDirect(privateLookup.findVirtual(cls, name, type));
    }

    public static MethodHandleInfo findStaticMethod(Class<?> cls, String name, MethodType type) {
        try {
            return MethodHandlesReflection.findStaticMethodOrThrow(cls, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static MethodHandleInfo findStaticMethodOrThrow(Class<?> cls, String name, MethodType type) throws NoSuchMethodException, IllegalAccessException {
        return privateLookup.revealDirect(privateLookup.findStatic(cls, name, type));
    }
}

