/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import one.nio.serial.DataStream;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;

public class DeserializeStream
extends DataStream {
    private static final int INITIAL_CAPACITY = 24;
    protected Object[] context = new Object[24];
    protected int contextSize;

    public DeserializeStream(byte[] array) {
        super(array);
    }

    public DeserializeStream(byte[] array, int length) {
        super(array, JavaInternals.byteArrayOffset, length);
    }

    public DeserializeStream(long address, long length) {
        super(address, length);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Serializer serializer;
        byte b = this.readByte();
        if (b >= 0) {
            --this.offset;
            serializer = Repository.requestSerializer(this.readLong());
        } else if (b <= -10) {
            serializer = Repository.requestBootstrapSerializer(b);
        } else {
            switch (b) {
                case -1: {
                    return null;
                }
                case -2: {
                    return this.context[this.readUnsignedShort() + 1];
                }
                case -3: {
                    return this.context[this.readInt() + 1];
                }
                case -4: {
                    serializer = (Serializer)this.readObject();
                    break;
                }
                default: {
                    return this.readRef(b);
                }
            }
        }
        if (++this.contextSize >= this.context.length) {
            this.context = Arrays.copyOf(this.context, this.context.length * 2);
        }
        return serializer.read(this);
    }

    @Override
    public void close() throws IOException {
        this.context = null;
    }

    @Override
    public void register(Object obj) {
        this.context[this.contextSize] = obj;
    }

    @Override
    public Closeable newScope() {
        return new Closeable(){
            private final Object[] prevContext;
            private final int prevContextSize;
            {
                this.prevContext = DeserializeStream.this.context;
                this.prevContextSize = DeserializeStream.this.contextSize;
                DeserializeStream.this.context = new Object[24];
                DeserializeStream.this.contextSize = 0;
            }

            @Override
            public void close() {
                DeserializeStream.this.context = this.prevContext;
                DeserializeStream.this.contextSize = this.prevContextSize;
            }
        };
    }
}

