/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import one.nio.mem.DirectMemory;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.util.JavaInternals;
import one.nio.util.Utf8;

public class DataStream
implements ObjectInput,
ObjectOutput {
    protected static final byte REF_NULL = -1;
    protected static final byte REF_RECURSIVE = -2;
    protected static final byte REF_RECURSIVE2 = -3;
    protected static final byte REF_EMBEDDED = -4;
    protected static final byte FIRST_BOOT_UID = -10;
    protected byte[] array;
    protected long address;
    protected long limit;
    protected long offset;

    public DataStream(int capacity) {
        this(new byte[capacity], JavaInternals.byteArrayOffset, capacity);
    }

    public DataStream(byte[] array) {
        this(array, JavaInternals.byteArrayOffset, array.length);
    }

    public DataStream(long address, long length) {
        this(null, address, length);
    }

    protected DataStream(byte[] array, long address, long length) {
        this.array = array;
        this.address = address;
        this.limit = address + length;
        this.offset = address;
    }

    public byte[] array() {
        return this.array;
    }

    public long address() {
        return this.address;
    }

    public int count() {
        return (int)(this.offset - this.address);
    }

    @Override
    public void write(int b) throws IOException {
        long offset = this.alloc(1);
        JavaInternals.unsafe.putByte(this.array, offset, (byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        long offset = this.alloc(b.length);
        JavaInternals.unsafe.copyMemory(b, JavaInternals.byteArrayOffset, this.array, offset, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long offset = this.alloc(len);
        JavaInternals.unsafe.copyMemory(b, JavaInternals.byteArrayOffset + (long)off, this.array, offset, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        long offset = this.alloc(1);
        JavaInternals.unsafe.putBoolean(this.array, offset, v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        long offset = this.alloc(1);
        JavaInternals.unsafe.putByte(this.array, offset, (byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        long offset = this.alloc(2);
        JavaInternals.unsafe.putShort(this.array, offset, Short.reverseBytes((short)v));
    }

    @Override
    public void writeChar(int v) throws IOException {
        long offset = this.alloc(2);
        JavaInternals.unsafe.putChar(this.array, offset, Character.reverseBytes((char)v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        long offset = this.alloc(4);
        JavaInternals.unsafe.putInt(this.array, offset, Integer.reverseBytes(v));
    }

    @Override
    public void writeLong(long v) throws IOException {
        long offset = this.alloc(8);
        JavaInternals.unsafe.putLong(this.array, offset, Long.reverseBytes(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int length = s.length();
        long offset = this.alloc(length);
        for (int i = 0; i < length; ++i) {
            JavaInternals.unsafe.putByte(this.array, offset++, (byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int length = s.length();
        long offset = this.alloc(length * 2);
        for (int i = 0; i < length; ++i) {
            JavaInternals.unsafe.putChar(this.array, offset, Character.reverseBytes(s.charAt(i)));
            offset += 2L;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int utfLength = Utf8.length(s);
        if (utfLength <= Short.MAX_VALUE) {
            this.writeShort(utfLength);
        } else {
            this.writeInt(utfLength | Integer.MIN_VALUE);
        }
        long offset = this.alloc(utfLength);
        Utf8.write(s, (Object)this.array, offset);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(-1);
        } else {
            Serializer<?> serializer = Repository.get(obj.getClass());
            if (serializer.uid < 0L) {
                this.writeByte((byte)serializer.uid);
            } else {
                this.writeLong(serializer.uid);
            }
            serializer.write(obj, this);
        }
    }

    public void write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        long offset = this.alloc(len);
        if (src.hasArray()) {
            JavaInternals.unsafe.copyMemory(src.array(), JavaInternals.byteArrayOffset + (long)src.arrayOffset() + (long)src.position(), this.array, offset, len);
        } else {
            JavaInternals.unsafe.copyMemory(null, DirectMemory.getAddress(src) + (long)src.position(), this.array, offset, len);
        }
        src.position(src.limit());
    }

    public void writeFrom(long address, int len) throws IOException {
        long offset = this.alloc(len);
        JavaInternals.unsafe.copyMemory(null, address, this.array, offset, len);
    }

    @Override
    public int read() throws IOException {
        long offset = this.alloc(1);
        return JavaInternals.unsafe.getByte(this.array, offset);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.readFully(b);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.readFully(b, off, len);
        return len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        long offset = this.alloc(b.length);
        JavaInternals.unsafe.copyMemory(this.array, offset, b, JavaInternals.byteArrayOffset, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        long offset = this.alloc(len);
        JavaInternals.unsafe.copyMemory(this.array, offset, b, JavaInternals.byteArrayOffset + (long)off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.alloc((int)n);
        return n;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.alloc(n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        long offset = this.alloc(1);
        return JavaInternals.unsafe.getBoolean(this.array, offset);
    }

    @Override
    public byte readByte() throws IOException {
        long offset = this.alloc(1);
        return JavaInternals.unsafe.getByte(this.array, offset);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        long offset = this.alloc(1);
        return JavaInternals.unsafe.getByte(this.array, offset) & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        long offset = this.alloc(2);
        return Short.reverseBytes(JavaInternals.unsafe.getShort(this.array, offset));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        long offset = this.alloc(2);
        return Short.reverseBytes(JavaInternals.unsafe.getShort(this.array, offset)) & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        long offset = this.alloc(2);
        return Character.reverseBytes(JavaInternals.unsafe.getChar(this.array, offset));
    }

    @Override
    public int readInt() throws IOException {
        long offset = this.alloc(4);
        return Integer.reverseBytes(JavaInternals.unsafe.getInt(this.array, offset));
    }

    @Override
    public long readLong() throws IOException {
        long offset = this.alloc(8);
        return Long.reverseBytes(JavaInternals.unsafe.getLong(this.array, offset));
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        for (long ptr = this.offset; ptr < this.limit; ++ptr) {
            if (JavaInternals.unsafe.getByte(this.array, ptr) != 10) continue;
            int length = (int)(ptr - this.offset);
            int cr = length > 0 && JavaInternals.unsafe.getByte(this.array, ptr - 1L) == 13 ? 1 : 0;
            return Utf8.read((Object)this.array, this.alloc(length + 1), length - cr);
        }
        int length = (int)(this.limit - this.offset);
        return length > 0 ? Utf8.read((Object)this.array, this.alloc(length), length) : null;
    }

    @Override
    public String readUTF() throws IOException {
        int length = this.readUnsignedShort();
        if (length == 0) {
            return "";
        }
        if (length > Short.MAX_VALUE) {
            length = (length & Short.MAX_VALUE) << 16 | this.readUnsignedShort();
        }
        long offset = this.alloc(length);
        return Utf8.read((Object)this.array, offset, length);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        Serializer serializer;
        byte b = this.readByte();
        if (b >= 0) {
            --this.offset;
            serializer = Repository.requestSerializer(this.readLong());
        } else if (b <= -10) {
            serializer = Repository.requestBootstrapSerializer(b);
        } else {
            return b == -1 ? null : this.readRef(b);
        }
        return serializer.read(this);
    }

    protected Object readRef(byte tag) throws IOException, ClassNotFoundException {
        throw new IOException("Invalid reference tag: " + tag);
    }

    public void read(ByteBuffer dst) throws IOException {
        int len = dst.remaining();
        long offset = this.alloc(len);
        if (dst.hasArray()) {
            JavaInternals.unsafe.copyMemory(this.array, offset, dst.array(), JavaInternals.byteArrayOffset + (long)dst.arrayOffset() + (long)dst.position(), len);
        } else {
            JavaInternals.unsafe.copyMemory(this.array, offset, null, DirectMemory.getAddress(dst) + (long)dst.position(), len);
        }
        dst.position(dst.limit());
    }

    public void readTo(long address, int len) throws IOException {
        long offset = this.alloc(len);
        JavaInternals.unsafe.copyMemory(this.array, offset, null, address, len);
    }

    public ByteBuffer byteBuffer(int len) throws IOException {
        long offset = this.alloc(len);
        if (this.array != null) {
            return ByteBuffer.wrap(this.array, (int)(offset - JavaInternals.byteArrayOffset), len);
        }
        return DirectMemory.wrap(offset, len);
    }

    @Override
    public int available() {
        return (int)(this.limit - this.offset);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public void register(Object obj) {
    }

    public Closeable newScope() {
        return null;
    }

    protected long alloc(int size) throws IOException {
        long currentOffset = this.offset;
        this.offset = currentOffset + (long)size;
        if (this.offset > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return currentOffset;
    }
}

