/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mgt;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Management {
    private static final Logger log = LoggerFactory.getLogger(Management.class);

    public static void registerMXBean(Object object, String name) {
        Management.registerMXBean(object, null, name);
    }

    public static <T> void registerMXBean(T object, Class<T> mxbeanInterface, String name) {
        try {
            StandardMBean mb = new StandardMBean(object, mxbeanInterface, true);
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(name);
            if (beanServer.isRegistered(objectName)) {
                beanServer.unregisterMBean(objectName);
            }
            beanServer.registerMBean(mb, objectName);
        }
        catch (Exception e) {
            log.error("Cannot register MXBean {}", (Object)name, (Object)e);
        }
    }

    public static void unregisterMXBean(String name) {
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(name);
            if (beanServer.isRegistered(objectName)) {
                beanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            log.error("Cannot unregister MXBean {}", (Object)name, (Object)e);
        }
    }

    public static Object getAttribute(String name, String attribute) throws JMException {
        return Management.getAttribute(new ObjectName(name), attribute);
    }

    public static Object getAttribute(ObjectName objName, String attribute) throws JMException {
        return ManagementFactory.getPlatformMBeanServer().getAttribute(objName, attribute);
    }

    public static Object[] getAttributes(String name, String ... attributes) throws JMException {
        return Management.getAttributes(new ObjectName(name), attributes);
    }

    public static Object[] getAttributes(ObjectName objName, String ... attributes) throws JMException {
        AttributeList list = ManagementFactory.getPlatformMBeanServer().getAttributes(objName, attributes);
        Object[] values = new Object[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = ((Attribute)list.get(i)).getValue();
        }
        return values;
    }

    public static Set<ObjectName> resolvePattern(String name) throws JMException {
        ObjectName objName = new ObjectName(name);
        if (name.indexOf(42) < 0 && name.indexOf(63) < 0) {
            return Collections.singleton(objName);
        }
        Set<ObjectName> objNames = ManagementFactory.getPlatformMBeanServer().queryNames(objName, null);
        if (objNames.isEmpty()) {
            throw new InstanceNotFoundException(name);
        }
        return objNames;
    }

    static {
        try {
            ManagementFactory.getPlatformMBeanServer().createMBean("sun.management.HotspotInternal", null);
        }
        catch (Exception e) {
            log.warn("Cannot register HotspotInternal", (Throwable)e);
        }
    }
}

