/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.util.Arrays;
import one.nio.mem.LongHashSet;

public class LongObjectHashMap<T>
extends LongHashSet {
    private static final long base = unsafe.arrayBaseOffset(Object[].class);
    private static final int shift = 31 - Integer.numberOfLeadingZeros(unsafe.arrayIndexScale(Object[].class));
    protected final Object[] values;

    public LongObjectHashMap(int capacity) {
        super(capacity);
        this.values = new Object[this.capacity];
    }

    public T get(long key) {
        int index = this.getKey(key);
        return index >= 0 ? (T)this.valueAt(index) : null;
    }

    public void put(long key, T value) {
        int index = this.putKey(key);
        this.setValueAt(index, value);
    }

    public boolean replace(long key, T oldValue, T newValue) {
        int index = this.getKey(key);
        return index >= 0 && unsafe.compareAndSwapObject(this.values, LongObjectHashMap.offset(index), oldValue, newValue);
    }

    public T replace(long key, T newValue) {
        int index = this.putKey(key);
        return this.replaceValueAt(index, newValue);
    }

    public T remove(long key) {
        int index = this.getKey(key);
        return index >= 0 ? this.replaceValueAt(index, null) : null;
    }

    public final T valueAt(int index) {
        return (T)this.values[index];
    }

    public final void setValueAt(int index, T value) {
        this.values[index] = value;
    }

    public final T replaceValueAt(int index, T newValue) {
        Object oldValue;
        long offset = LongObjectHashMap.offset(index);
        while (!unsafe.compareAndSwapObject(this.values, offset, oldValue = unsafe.getObjectVolatile(this.values, offset), newValue)) {
        }
        return (T)oldValue;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    private static long offset(int index) {
        return base + ((long)index << shift);
    }
}

