/*
 * Decompiled with CFR 0.152.
 */
package one.nio.mem;

import java.util.concurrent.atomic.AtomicLong;
import one.nio.mem.Allocator;
import one.nio.mem.DirectMemory;
import one.nio.mem.OutOfMemoryException;
import one.nio.util.JavaInternals;

public class ArenaAllocator
implements Allocator {
    private static final long MIN_ARENA_SIZE = 0x400000L;
    private volatile Arena current = new Arena(null, 0L, 0L);
    private long accumulatedBytes;

    public synchronized void release() {
        Arena arena = this.current;
        while (arena.addr != 0L) {
            this.releaseMemoryToSystem(arena.addr, arena.size);
            arena = arena.prev;
        }
        this.current = new Arena(null, 0L, 0L);
        this.accumulatedBytes = 0L;
    }

    @Override
    public long malloc(int size) {
        size = size + 7 & 0xFFFFFFF8;
        Arena arena = this.current;
        while (true) {
            long offs;
            if ((offs = arena.get()) + (long)size <= arena.size) {
                if (!arena.compareAndSet(offs, offs + (long)size)) continue;
                return arena.addr + offs;
            }
            arena = this.getNextArena(arena, size);
        }
    }

    @Override
    public long calloc(int size) {
        long address = this.malloc(size);
        DirectMemory.clearSmall(address, size);
        return address;
    }

    @Override
    public void free(long address) {
        throw new UnsupportedOperationException("Cannot free individual objects");
    }

    @Override
    public void verify() {
    }

    private synchronized Arena getNextArena(Arena current, long size) {
        if (this.current != current) {
            return this.current;
        }
        long arenaSize = Math.max(size, 0x400000L);
        long base = this.getMemoryFromSystem(arenaSize);
        if (base == 0L) {
            throw new OutOfMemoryException("Failed to reserve " + arenaSize + " bytes");
        }
        this.accumulatedBytes += current.size;
        this.current = new Arena(current, base, arenaSize);
        return this.current;
    }

    protected long getMemoryFromSystem(long size) {
        return JavaInternals.unsafe.allocateMemory(size);
    }

    protected void releaseMemoryToSystem(long addr, long size) {
        JavaInternals.unsafe.freeMemory(addr);
    }

    public synchronized long getAllocatedBytes() {
        return this.accumulatedBytes + this.current.get();
    }

    public synchronized long getReservedBytes() {
        return this.accumulatedBytes + this.current.size;
    }

    static final class Arena
    extends AtomicLong {
        final Arena prev;
        final long addr;
        final long size;

        Arena(Arena prev, long addr, long size) {
            this.prev = prev;
            this.addr = addr;
            this.size = size;
        }
    }
}

