/*
 * Decompiled with CFR 0.152.
 */
package one.nio.http;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import one.nio.util.URLEncoder;

final class QueryParameterIterator
implements Iterator<Map.Entry<String, String>> {
    private final String query;
    private int cur;

    QueryParameterIterator(String query) {
        assert (query != null);
        this.query = query;
        this.cur = 0;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.cur >= 0;
    }

    @Override
    public Map.Entry<String, String> next() {
        String parameter;
        if (!this.hasNext()) {
            throw new NoSuchElementException("Beyond query parameters");
        }
        int next = this.query.indexOf(38, this.cur);
        if (next < 0) {
            parameter = this.query.substring(this.cur);
            this.cur = -1;
        } else {
            parameter = this.query.substring(this.cur, next);
            this.cur = next;
            this.advance();
        }
        int q = parameter.indexOf(61);
        if (q < 0) {
            return new QueryParameter(parameter, "");
        }
        return new QueryParameter(parameter.substring(0, q), parameter.substring(q + 1));
    }

    private void advance() {
        assert (this.cur >= 0);
        while (this.cur < this.query.length() && this.query.charAt(this.cur) == '&') {
            ++this.cur;
        }
        if (this.cur == this.query.length()) {
            this.cur = -1;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Query parameter removal is not supported");
    }

    private static final class QueryParameter
    implements Map.Entry<String, String> {
        private final String key;
        private final String rawValue;

        QueryParameter(String key, String rawValue) {
            assert (key != null && !key.isEmpty());
            assert (rawValue != null);
            this.key = key;
            this.rawValue = rawValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return URLEncoder.decode(this.rawValue);
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }
}

