/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import one.nio.net.Session;
import one.nio.os.BatchThread;
import one.nio.server.SelectorThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupThread
extends BatchThread {
    private static final Logger log = LoggerFactory.getLogger(CleanupThread.class);
    private volatile SelectorThread[] selectors;
    private volatile long keepAlive;

    public CleanupThread(SelectorThread[] selectors, long keepAlive) {
        super("NIO Cleanup");
        this.selectors = selectors;
        this.setKeepAlive(keepAlive);
    }

    public void shutdown() {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        if (keepAlive > 0L && keepAlive < 1000L) {
            log.warn("Suspicious keepAlive! Consider specifying time units (ms, s)");
            keepAlive *= 1000L;
        }
        this.keepAlive = keepAlive;
    }

    public synchronized void update(SelectorThread[] selectors, long keepAlive) {
        this.selectors = selectors;
        this.setKeepAlive(keepAlive);
        this.notify();
    }

    private synchronized long waitKeepAlive() throws InterruptedException {
        long keepAlive = this.keepAlive;
        this.wait(keepAlive);
        return keepAlive;
    }

    @Override
    public void run() {
        CleanupThread.adjustPriority();
        while (!this.isInterrupted()) {
            try {
                long keepAlive = this.waitKeepAlive();
                if (keepAlive == 0L) continue;
                long cleanTime = System.currentTimeMillis();
                int idleCount = 0;
                int staleCount = 0;
                for (SelectorThread selector : this.selectors) {
                    for (Session session : selector.selector) {
                        int status = session.checkStatus(cleanTime, keepAlive);
                        if (status == 0) continue;
                        if (status == 1) {
                            ++idleCount;
                        } else {
                            ++staleCount;
                        }
                        session.close();
                    }
                }
                if (idleCount + staleCount <= 0) continue;
                log.info("{} idle + {} stale sessions closed in {} ms", new Object[]{idleCount, staleCount, System.currentTimeMillis() - cleanTime});
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Throwable e) {
                log.error("Uncaught exception in CleanupThread", e);
            }
        }
    }
}

