/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.IOException;
import one.nio.os.bpf.BpfMap;
import one.nio.os.bpf.MapType;
import one.nio.os.perf.CounterValue;
import one.nio.os.perf.GlobalValue;
import one.nio.os.perf.LocalValue;
import one.nio.os.perf.Perf;
import one.nio.os.perf.PerfCounter;
import one.nio.os.perf.PerfEvent;

public class PerfCounterGlobal
extends PerfCounter {
    final int[] fds;

    PerfCounterGlobal(PerfEvent event, long readFormat, int[] fds) {
        super(event, null, readFormat, 0);
        this.fds = fds;
    }

    @Override
    public void close() {
        if (fdUpdater.compareAndSet(this, 0, -1)) {
            for (int i = 0; i < this.fds.length; ++i) {
                int fd = this.fds[i];
                this.fds[i] = -1;
                if (fd <= 0) continue;
                Perf.close(fd);
            }
        }
    }

    @Override
    public long get() throws IOException {
        long sum = 0L;
        for (int fd : this.fds) {
            if (fd <= 0) continue;
            sum += Perf.get(fd);
        }
        return sum;
    }

    @Override
    public CounterValue getValue() throws IOException {
        int vals = this.hasReadFormat(3) ? 3 : 1;
        long[] buf = new long[3 * this.fds.length];
        for (int cpu = 0; cpu < this.fds.length; ++cpu) {
            int fd = this.fds[cpu];
            if (fd <= 0) continue;
            Perf.getValue(fd, buf, cpu * 3, vals);
        }
        return new GlobalValue(buf);
    }

    public long getForCpu(int cpu) throws IOException {
        int fd = this.fds[cpu];
        return fd > 0 ? Perf.get(fd) : 0L;
    }

    public LocalValue getValueForCpu(int cpu) throws IOException {
        int fd = this.fds[cpu];
        if (fd <= 0) {
            return LocalValue.ZERO;
        }
        long[] buf = this.newBuffer();
        Perf.getValue(fd, buf, 0, buf.length);
        return this.toValue(buf);
    }

    @Override
    protected long[] getRawValue() throws IOException {
        long[] buf = this.newBuffer();
        long[] total = this.newBuffer();
        for (int fd : this.fds) {
            if (fd <= 0) continue;
            Perf.getValue(fd, buf, 0, buf.length);
            for (int i = 0; i < buf.length; ++i) {
                int n = i;
                total[n] = total[n] + buf[i];
            }
        }
        return total;
    }

    @Override
    void ioctl(int cmd, int arg) throws IOException {
        for (int fd : this.fds) {
            if (fd <= 0) continue;
            Perf.ioctl(fd, cmd, arg);
        }
    }

    public void storeTo(BpfMap map) throws IOException {
        assert (this.fds.length == BpfMap.CPUS) : "Are some cpus offline?";
        for (int i = 0; i < this.fds.length; ++i) {
            this.storeTo(map, i);
        }
    }

    public void storeTo(BpfMap map, int cpu) throws IOException {
        if (map.type != MapType.PERF_EVENT_ARRAY) {
            throw new IllegalArgumentException();
        }
        int fd = this.fds[cpu];
        if (fd > 0) {
            map.put(BpfMap.bytes(cpu), BpfMap.bytes(fd));
        }
    }
}

