/*
 * Decompiled with CFR 0.152.
 */
package one.nio.os.perf;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import one.nio.os.perf.CounterValue;
import one.nio.os.perf.LocalValue;
import one.nio.os.perf.Perf;
import one.nio.os.perf.PerfEvent;
import one.nio.os.perf.PerfSample;
import one.nio.os.perf.RingBuffer;

public class PerfCounter
implements Closeable {
    private final PerfEvent event;
    private final RingBuffer ringBuffer;
    protected final long readFormat;
    volatile int fd;
    static final AtomicIntegerFieldUpdater<PerfCounter> fdUpdater = AtomicIntegerFieldUpdater.newUpdater(PerfCounter.class, "fd");

    PerfCounter(PerfEvent event, RingBuffer ringBuffer, long readFormat, int fd) {
        this.event = event;
        this.ringBuffer = ringBuffer;
        this.fd = fd;
        this.readFormat = readFormat;
    }

    public final PerfEvent event() {
        return this.event;
    }

    @Override
    public void close() {
        int fd = this.fd;
        if (fdUpdater.compareAndSet(this, fd, -1)) {
            Perf.close(fd);
            if (this.ringBuffer != null) {
                this.ringBuffer.close();
            }
        }
    }

    public long get() throws IOException {
        return Perf.get(this.fd);
    }

    public CounterValue getValue() throws IOException {
        return this.toValue(this.getRawValue());
    }

    protected long[] getRawValue() throws IOException {
        long[] buf = this.newBuffer();
        Perf.getValue(this.fd, buf, 0, buf.length);
        return buf;
    }

    protected long[] newBuffer() {
        return new long[1 + Long.bitCount(this.readFormat)];
    }

    protected LocalValue toValue(long[] raw) {
        long value = raw[0];
        int i = 1;
        long enabled = this.hasReadFormat(1) ? raw[i++] : 0L;
        long running = this.hasReadFormat(2) ? raw[i] : 0L;
        return new LocalValue(value, running, enabled);
    }

    public boolean hasReadFormat(int readFormat) {
        return (long)readFormat == (this.readFormat & (long)readFormat);
    }

    public PerfSample nextSample() {
        if (this.ringBuffer == null) {
            throw new IllegalStateException("Not a sampling counter");
        }
        return this.ringBuffer.nextSample();
    }

    public void reset() throws IOException {
        this.ioctl(0, 0);
    }

    public void attachBpf(int fd) throws IOException {
        this.ioctl(8, fd);
    }

    public void enable() throws IOException {
        this.ioctl(1, 0);
    }

    public void disable() throws IOException {
        this.ioctl(2, 0);
    }

    public void refresh(int count) throws IOException {
        if (count < 0) {
            throw new IllegalArgumentException("count must be > 0");
        }
        this.ioctl(3, count);
    }

    void ioctl(int cmd, int arg) throws IOException {
        Perf.ioctl(this.fd, cmd, arg);
    }
}

