/*
 * Decompiled with CFR 0.152.
 */
package one.nio.compiler;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import one.nio.compiler.CompilationException;
import one.nio.compiler.MemoryInputFileObject;
import one.nio.compiler.MemoryOutputFileObject;
import one.nio.util.URLEncoder;

public class Javac {
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
    private final String classPath;

    public Javac() {
        this(System.getProperty("java.class.path"));
    }

    public Javac(ClassLoader loader) {
        this(Javac.buildPathFromClassLoader(loader));
    }

    public Javac(String classPath) {
        this.classPath = classPath;
    }

    public byte[] compile(CharSequence code) throws CompilationException {
        CharArrayWriter messages = new CharArrayWriter();
        List<String> options = Arrays.asList("-classpath", this.classPath);
        final ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        ForwardingJavaFileManager<StandardJavaFileManager> manager = new ForwardingJavaFileManager<StandardJavaFileManager>(this.fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
                return new MemoryOutputFileObject(output);
            }
        };
        List<MemoryInputFileObject> input = Arrays.asList(new MemoryInputFileObject(code));
        if (this.compiler.getTask(messages, manager, null, options, null, input).call().booleanValue()) {
            return output.toByteArray();
        }
        throw new CompilationException(messages.toString());
    }

    private static String buildPathFromClassLoader(ClassLoader loader) {
        String classPath = "";
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        while (loader != null) {
            if (loader == systemClassLoader) {
                return System.getProperty("java.class.path") + File.pathSeparatorChar + classPath;
            }
            if (loader instanceof URLClassLoader) {
                StringBuilder sb = new StringBuilder(100);
                for (URL url : ((URLClassLoader)loader).getURLs()) {
                    if (!"file".equals(url.getProtocol())) continue;
                    String file = URLEncoder.decode(url.getFile());
                    sb.append(file).append(File.pathSeparatorChar);
                }
                classPath = sb.append(classPath).toString();
            }
            loader = loader.getParent();
        }
        return classPath;
    }
}

