/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.NotSerializableException;
import one.nio.http.Request;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.JsonReader;
import one.nio.serial.Serializer;

public class HttpRequestSerializer
extends Serializer<Request> {
    HttpRequestSerializer() {
        super(Request.class);
    }

    @Override
    public void calcSize(Request obj, CalcSizeStream css) throws IOException {
        throw new NotSerializableException(this.descriptor);
    }

    @Override
    public void write(Request obj, DataStream out) throws IOException {
        throw new NotSerializableException(this.descriptor);
    }

    @Override
    public Request read(DataStream in) throws IOException, ClassNotFoundException {
        String header;
        int uriTo;
        String requestLine = in.readLine();
        int method = HttpRequestSerializer.selectMethod(requestLine);
        int uriFrom = requestLine.indexOf(32) + 1;
        String uri = uriFrom <= (uriTo = requestLine.lastIndexOf(32)) ? requestLine.substring(uriFrom, uriTo) : requestLine.substring(uriFrom);
        boolean http11 = requestLine.endsWith("/1.1");
        Request request = new Request(method, uri, http11);
        while (!(header = in.readLine()).isEmpty()) {
            request.addHeader(header);
        }
        String contentLength = request.getHeader("content-length: ");
        if (contentLength != null) {
            if (Integer.parseInt(contentLength) != in.available()) {
                throw new IOException("Content-Length mismatch");
            }
            byte[] body = new byte[in.available()];
            in.readFully(body);
            request.setBody(body);
        }
        return request;
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
        String header;
        in.readLine();
        int contentLength = 0;
        while (!(header = in.readLine()).isEmpty()) {
            if (!header.regionMatches(true, 0, "content-length: ", 0, 16)) continue;
            contentLength = Integer.parseInt(header.substring(16));
        }
        in.skipBytes(contentLength);
    }

    @Override
    public void toJson(Request obj, StringBuilder builder) throws IOException {
        throw new NotSerializableException(this.descriptor);
    }

    @Override
    public Request fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.descriptor);
    }

    private static int selectMethod(String requestLine) throws IOException {
        if (requestLine.startsWith("ET ")) {
            return 1;
        }
        if (requestLine.startsWith("OST ")) {
            return 2;
        }
        if (requestLine.startsWith("EAD ")) {
            return 3;
        }
        throw new IOException("Invalid HTTP method");
    }
}

