/*
 * Decompiled with CFR 0.152.
 */
package one.nio.net;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import one.nio.mem.DirectMemory;
import one.nio.net.AddressHolder;
import one.nio.net.Msg;
import one.nio.net.NativeSslContext;
import one.nio.net.NativeSslSocket;
import one.nio.net.Socket;
import one.nio.net.SslContext;
import one.nio.net.SslOption;
import one.nio.os.Mem;
import one.nio.util.JavaInternals;

class NativeSocket
extends Socket {
    private static final int INET_FAMILY = NativeSocket.initNatives(Boolean.getBoolean("java.net.preferIPv4Stack"));
    private static final long ARRAY_FIELD = JavaInternals.fieldOffset(ByteBuffer.class, "hb");
    private static final long OFFSET_FIELD = JavaInternals.fieldOffset(ByteBuffer.class, "offset");
    int fd;

    NativeSocket(int domain, int type) throws IOException {
        this.fd = NativeSocket.socket0(domain != 0 ? domain : INET_FAMILY, type);
    }

    NativeSocket(int fd) {
        this.fd = fd;
    }

    @Override
    public final boolean isOpen() {
        return this.fd >= 0;
    }

    @Override
    public NativeSocket accept() throws IOException {
        return new NativeSocket(this.accept0(false));
    }

    @Override
    public NativeSocket acceptNonBlocking() throws IOException {
        return new NativeSocket(this.accept0(true));
    }

    @Override
    public final native InetSocketAddress getLocalAddress();

    @Override
    public final native InetSocketAddress getRemoteAddress();

    @Override
    public Socket sslWrap(SslContext context) throws IOException {
        return new NativeSslSocket(this.fd, (NativeSslContext)context, false);
    }

    @Override
    public Socket sslUnwrap() {
        return this;
    }

    @Override
    public SslContext getSslContext() {
        return null;
    }

    @Override
    public <T> T getSslOption(SslOption<T> option) {
        return null;
    }

    @Override
    public void connect(InetAddress address, int port) throws IOException {
        this.connect0(address.getAddress(), port);
    }

    @Override
    public void connect(String host, int port) throws IOException {
        this.connect0(NativeSocket.toNativeAddr(host, port), port);
    }

    @Override
    public void bind(InetAddress address, int port, int backlog) throws IOException {
        this.bind0(address.getAddress(), port);
    }

    @Override
    public void bind(String host, int port, int backlog) throws IOException {
        this.bind0(NativeSocket.toNativeAddr(host, port), port);
    }

    @Override
    public native void listen(int var1) throws IOException;

    @Override
    public native void close();

    @Override
    public native int writeRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public int send(ByteBuffer src, int flags, InetAddress address, int port) throws IOException {
        return this.sendTo(src, flags, address.getAddress(), port);
    }

    @Override
    public int send(ByteBuffer data, int flags, String host, int port) throws IOException {
        return this.sendTo(data, flags, NativeSocket.toNativeAddr(host, port), port);
    }

    private int sendTo(ByteBuffer src, int flags, Object address, int port) throws IOException {
        int result;
        if (src.isDirect()) {
            result = this.sendTo1(DirectMemory.getAddress(src) + (long)src.position(), src.remaining(), flags, address, port);
        } else if (src.hasArray()) {
            result = this.sendTo0(src.array(), src.arrayOffset() + src.position(), src.remaining(), flags, address, port);
        } else if (src.isReadOnly()) {
            try {
                result = this.sendTo0(this.getArray(src), this.getOffset(src) + src.position(), src.remaining(), flags, address, port);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Failed to access array in readonly ByteBuffer", e);
            }
        } else {
            throw new IOException("Cannot handle ByteBuffer " + src);
        }
        if (result > 0) {
            src.position(src.position() + result);
        }
        return result;
    }

    private byte[] getArray(ByteBuffer src) throws IllegalAccessException {
        return (byte[])JavaInternals.unsafe.getObject(src, ARRAY_FIELD);
    }

    private int getOffset(ByteBuffer src) throws IllegalAccessException {
        return JavaInternals.unsafe.getInt(src, OFFSET_FIELD);
    }

    @Override
    public native int write(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public native void writeFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public native int readRaw(long var1, int var3, int var4) throws IOException;

    @Override
    public native int read(byte[] var1, int var2, int var3, int var4) throws IOException;

    @Override
    public InetSocketAddress recv(ByteBuffer dst, int flags) throws IOException {
        AddressHolder holder = new AddressHolder();
        int result = dst.hasArray() ? this.recvFrom0(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining(), flags, holder) : this.recvFrom1(DirectMemory.getAddress(dst) + (long)dst.position(), dst.remaining(), flags, holder);
        if (result > 0) {
            dst.position(dst.position() + result);
            return holder.address;
        }
        return null;
    }

    @Override
    public native void readFully(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public long sendFile(RandomAccessFile file, long offset, long count) throws IOException {
        return this.sendFile0(Mem.getFD(file.getFD()), offset, count);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytes = dst.isDirect() ? this.readRaw(DirectMemory.getAddress(dst) + (long)dst.position(), dst.remaining(), 0) : this.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining(), 0);
        dst.position(dst.position() + bytes);
        return bytes;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int bytes;
        if (src.isDirect()) {
            bytes = this.writeRaw(DirectMemory.getAddress(src) + (long)src.position(), src.remaining(), 0);
        } else if (src.hasArray()) {
            bytes = this.write(src.array(), src.arrayOffset() + src.position(), src.remaining(), 0);
        } else if (src.isReadOnly()) {
            try {
                bytes = this.write(this.getArray(src), this.getOffset(src) + src.position(), src.remaining(), 0);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Failed to access array in readonly ByteBuffer", e);
            }
        } else {
            throw new IOException("Cannot handle ByteBuffer " + src);
        }
        src.position(src.position() + bytes);
        return bytes;
    }

    @Override
    public int sendMsg(Msg msg, int flags) throws IOException {
        return this.sendMsg0(msg.data(), msg.cmsgType(), msg.cmsgData(), flags);
    }

    @Override
    public int recvMsg(Msg msg, int flags) throws IOException {
        return this.recvMsg0(msg.data(), msg, flags);
    }

    @Override
    public final native void setBlocking(boolean var1);

    @Override
    public final native boolean isBlocking();

    @Override
    public final native void setTimeout(int var1);

    @Override
    public final native int getTimeout();

    @Override
    public final native void setKeepAlive(boolean var1);

    @Override
    public final native boolean getKeepAlive();

    @Override
    public final native void setNoDelay(boolean var1);

    @Override
    public final native boolean getNoDelay();

    @Override
    public final native void setTcpFastOpen(boolean var1);

    @Override
    public final native boolean getTcpFastOpen();

    @Override
    public final native void setDeferAccept(boolean var1);

    @Override
    public final native boolean getDeferAccept();

    @Override
    public final native void setReuseAddr(boolean var1, boolean var2);

    @Override
    public final native boolean getReuseAddr();

    @Override
    public final native boolean getReusePort();

    @Override
    public final native void setRecvBuffer(int var1);

    @Override
    public final native int getRecvBuffer();

    @Override
    public final native void setSendBuffer(int var1);

    @Override
    public final native int getSendBuffer();

    @Override
    public final native void setTos(int var1);

    @Override
    public final native int getTos();

    @Override
    public native byte[] getOption(int var1, int var2);

    @Override
    public native boolean setOption(int var1, int var2, byte[] var3);

    static Object toNativeAddr(String host, int port) throws UnknownHostException {
        return port == -1 ? host : (Object)InetAddress.getByName(host).getAddress();
    }

    private static native int initNatives(boolean var0);

    private static native int socket0(int var0, int var1) throws IOException;

    final native void connect0(Object var1, int var2) throws IOException;

    final native void bind0(Object var1, int var2) throws IOException;

    final native int accept0(boolean var1) throws IOException;

    final native long sendFile0(int var1, long var2, long var4) throws IOException;

    final native int sendTo0(byte[] var1, int var2, int var3, int var4, Object var5, int var6) throws IOException;

    final native int sendTo1(long var1, int var3, int var4, Object var5, int var6) throws IOException;

    final native int recvFrom0(byte[] var1, int var2, int var3, int var4, AddressHolder var5) throws IOException;

    final native int recvFrom1(long var1, int var3, int var4, AddressHolder var5) throws IOException;

    final native int sendMsg0(byte[] var1, int var2, int[] var3, int var4) throws IOException;

    final native int recvMsg0(byte[] var1, Msg var2, int var3) throws IOException;
}

