/*
 * Decompiled with CFR 0.152.
 */
package one.nio.server;

import one.nio.net.Session;
import one.nio.os.BatchThread;
import one.nio.server.SelectorThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CleanupThread
extends BatchThread {
    private static final Log log = LogFactory.getLog(CleanupThread.class);
    private volatile SelectorThread[] selectors;
    private volatile long keepAlive;

    public CleanupThread(SelectorThread[] selectors, long keepAlive) {
        super("NIO Cleanup");
        this.selectors = selectors;
        this.setKeepAlive(keepAlive);
    }

    public void shutdown() {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        if (keepAlive > 0L && keepAlive < 1000L) {
            log.warn((Object)"Suspicious keepAlive! Consider specifying time units (ms, s)");
            keepAlive *= 1000L;
        }
        this.keepAlive = keepAlive;
    }

    public synchronized void update(SelectorThread[] selectors, long keepAlive) {
        this.selectors = selectors;
        this.setKeepAlive(keepAlive);
        this.notify();
    }

    private synchronized long waitKeepAlive() throws InterruptedException {
        long keepAlive = this.keepAlive;
        this.wait(keepAlive);
        return keepAlive;
    }

    @Override
    public void run() {
        CleanupThread.adjustPriority();
        while (!this.isInterrupted()) {
            try {
                long keepAlive = this.waitKeepAlive();
                if (keepAlive == 0L) continue;
                long cleanTime = System.currentTimeMillis();
                int idleCount = 0;
                int staleCount = 0;
                for (SelectorThread selector : this.selectors) {
                    for (Session session : selector.selector) {
                        int status = session.checkStatus(cleanTime, keepAlive);
                        if (status == 0) continue;
                        if (status == 1) {
                            ++idleCount;
                        } else {
                            ++staleCount;
                        }
                        session.close();
                    }
                }
                if (!log.isInfoEnabled() || idleCount + staleCount <= 0) continue;
                log.info((Object)(idleCount + " idle + " + staleCount + " stale sessions closed in " + (System.currentTimeMillis() - cleanTime) + " ms"));
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Throwable e) {
                log.error((Object)"Uncaught exception in CleanupThread", e);
            }
        }
    }
}

