/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.util.Arrays;
import one.nio.serial.Repository;
import one.nio.serial.SerializeStream;
import one.nio.serial.Serializer;

public class PersistStream
extends SerializeStream {
    public PersistStream() {
        super(new byte[400]);
    }

    public PersistStream(int capacity) {
        super(new byte[capacity]);
    }

    public PersistStream(byte[] array) {
        super(array);
    }

    public PersistStream(long address, long length) {
        super(address, length);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.array, this.count());
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj == null) {
            this.writeByte(-1);
        } else {
            int index = this.context.indexOf(obj);
            if (index < 0) {
                Serializer<?> serializer = Repository.get(obj.getClass());
                if (serializer.uid < 0L) {
                    this.writeByte((byte)serializer.uid);
                } else {
                    this.writeByte(-4);
                    this.writeObject(serializer);
                }
                this.context.put(obj);
                serializer.write(obj, this);
            } else if (index <= 65535) {
                this.writeByte(-2);
                this.writeShort(index);
            } else {
                this.writeByte(-3);
                this.writeInt(index);
            }
        }
    }

    @Override
    protected long alloc(int size) {
        long currentOffset = this.offset;
        this.offset = currentOffset + (long)size;
        if (this.offset > this.limit) {
            this.limit = Math.max(this.offset, this.limit * 2L);
            this.array = Arrays.copyOf(this.array, (int)(this.limit - this.address));
        }
        return currentOffset;
    }
}

