/*
 * Decompiled with CFR 0.152.
 */
package one.nio.serial;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import one.nio.serial.CalcSizeStream;
import one.nio.serial.DataStream;
import one.nio.serial.Json;
import one.nio.serial.JsonReader;
import one.nio.serial.Renamed;
import one.nio.serial.Repository;
import one.nio.serial.Serializer;
import one.nio.serial.TypeDescriptor;

public class MethodSerializer<T>
extends Serializer<T> {
    static final AtomicInteger renamedMethods = new AtomicInteger();
    private String holderName;
    private String methodName;
    private TypeDescriptor[] args;
    private TypeDescriptor result;
    protected Method method;
    protected int argCount;

    protected MethodSerializer(Method method) {
        super(Method.class);
        this.holderName = TypeDescriptor.classDescriptor(method.getDeclaringClass());
        Renamed renamed = method.getAnnotation(Renamed.class);
        this.methodName = renamed == null ? method.getName() : method.getName() + '|' + renamed.from();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this.args = new TypeDescriptor[parameterTypes.length];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = new TypeDescriptor(parameterTypes[i]);
        }
        this.result = new TypeDescriptor(method.getReturnType());
        this.method = method;
        this.argCount = this.args.length;
        this.generateUid();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.holderName);
        out.writeUTF(this.methodName);
        out.writeShort(this.args.length);
        for (TypeDescriptor arg : this.args) {
            arg.write(out);
        }
        this.result.write(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.holderName = in.readUTF();
        this.methodName = in.readUTF();
        this.args = new TypeDescriptor[in.readUnsignedShort()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = TypeDescriptor.read(in);
        }
        this.result = TypeDescriptor.read(in);
        this.method = this.findMatchingMethod();
        this.argCount = this.args.length;
    }

    @Override
    public void skipExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.skipBytes(in.readUnsignedShort());
        in.skipBytes(in.readUnsignedShort());
        int argsAndReturnType = in.readUnsignedShort() + 1;
        for (int i = 0; i < argsAndReturnType; ++i) {
            if (in.readByte() >= 0) continue;
            in.skipBytes(in.readUnsignedShort());
        }
    }

    @Override
    public void toJson(StringBuilder sb) {
        sb.append("{\"cls\":\"").append(this.descriptor).append("\",\"uid\":").append(this.uid).append(",\"method\":\"").append(this.method).append("\"}");
    }

    @Override
    public String toString() {
        return super.toString() + "Method: " + this.method + '\n';
    }

    public Method method() {
        return this.method;
    }

    @Override
    public void calcSize(T obj, CalcSizeStream css) throws IOException {
    }

    @Override
    public void write(T obj, DataStream out) throws IOException {
    }

    @Override
    public T read(DataStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.cls.getName());
    }

    @Override
    public void skip(DataStream in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void toJson(T obj, StringBuilder builder) throws IOException {
        Json.appendString(builder, this.method.getName());
    }

    @Override
    public T fromJson(JsonReader in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.cls.getName());
    }

    private Method findMatchingMethod() throws ClassNotFoundException {
        Method[] methods;
        String name = this.methodName;
        String oldName = null;
        int p = name.indexOf(124);
        if (p >= 0) {
            oldName = name.substring(p + 1);
            name = name.substring(0, p);
        }
        Class<?> holder = TypeDescriptor.resolve(this.holderName);
        for (Method method : methods = holder.getMethods()) {
            if (!method.getName().equals(name) || !this.matches(method)) continue;
            return method;
        }
        if (oldName != null) {
            for (Method method : methods) {
                if (!method.getName().equals(oldName) || !this.matches(method)) continue;
                Repository.log.warn((Object)("[" + Long.toHexString(this.uid) + "] Method " + oldName + " renamed to " + name));
                renamedMethods.incrementAndGet();
                return method;
            }
        }
        throw new ClassNotFoundException("Remote call not found: " + holder.getName() + '.' + name);
    }

    private boolean matches(Method method) {
        if (method.getReturnType() != this.result.resolve()) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != this.args.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i] == this.args[i].resolve()) continue;
            return false;
        }
        return true;
    }
}

